/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.alarm.provider.slack;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.net.URI;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.alarm.AlarmMessage;
import org.apache.skywalking.oap.server.core.alarm.HttpAlarmCallback;
import org.apache.skywalking.oap.server.core.alarm.provider.AlarmRulesWatcher;
import org.apache.skywalking.oap.server.core.alarm.provider.slack.SlackSettings;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlackhookCallback
extends HttpAlarmCallback {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SlackhookCallback.class);
    private static final Gson GSON = new Gson();
    private final AlarmRulesWatcher alarmRulesWatcher;

    public void doAlarm(List<AlarmMessage> alarmMessages) throws Exception {
        Map<String, SlackSettings> settingsMap = this.alarmRulesWatcher.getSlackSettings();
        if (settingsMap == null || settingsMap.isEmpty()) {
            return;
        }
        Map groupedMessages = this.groupMessagesByHook(alarmMessages);
        for (Map.Entry entry : groupedMessages.entrySet()) {
            String hookName = (String)entry.getKey();
            List messages = (List)entry.getValue();
            SlackSettings setting = settingsMap.get(hookName);
            if (setting == null || CollectionUtils.isEmpty(setting.getWebhooks()) || CollectionUtils.isEmpty((List)messages)) continue;
            for (String url : setting.getWebhooks()) {
                JsonObject jsonObject = new JsonObject();
                JsonArray jsonElements = new JsonArray();
                for (AlarmMessage item : messages) {
                    jsonElements.add((JsonElement)GSON.fromJson(String.format(setting.getTextTemplate(), item.getAlarmMessage()), JsonObject.class));
                }
                jsonObject.add("blocks", (JsonElement)jsonElements);
                String body = GSON.toJson((JsonElement)jsonObject);
                this.post(URI.create(url), body, Map.of());
            }
        }
    }

    @Generated
    public SlackhookCallback(AlarmRulesWatcher alarmRulesWatcher) {
        this.alarmRulesWatcher = alarmRulesWatcher;
    }
}

