/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.alarm.provider.pagerduty;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.alarm.AlarmMessage;
import org.apache.skywalking.oap.server.core.alarm.HttpAlarmCallback;
import org.apache.skywalking.oap.server.core.alarm.provider.AlarmRulesWatcher;
import org.apache.skywalking.oap.server.core.alarm.provider.pagerduty.PagerDutySettings;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PagerDutyHookCallback
extends HttpAlarmCallback {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PagerDutyHookCallback.class);
    private static final String PAGER_DUTY_EVENTS_API_V2_URL = "http://events.pagerduty.com/v2/enqueue";
    private static final Gson GSON = new Gson();
    private final AlarmRulesWatcher alarmRulesWatcher;

    public void doAlarm(List<AlarmMessage> alarmMessages) throws Exception {
        Map<String, PagerDutySettings> settingsMap = this.alarmRulesWatcher.getPagerDutySettings();
        if (settingsMap == null || settingsMap.isEmpty()) {
            return;
        }
        Map groupedMessages = this.groupMessagesByHook(alarmMessages);
        for (Map.Entry entry : groupedMessages.entrySet()) {
            String hookName = (String)entry.getKey();
            List messages = (List)entry.getValue();
            PagerDutySettings setting = settingsMap.get(hookName);
            if (setting == null || CollectionUtils.isEmpty(setting.getIntegrationKeys()) || CollectionUtils.isEmpty((List)messages)) continue;
            for (String integrationKey : setting.getIntegrationKeys()) {
                for (AlarmMessage alarmMessage : messages) {
                    this.post(URI.create(PAGER_DUTY_EVENTS_API_V2_URL), this.getMessageBody(alarmMessage, integrationKey, setting.getTextTemplate()), Map.of());
                }
            }
        }
    }

    private String getMessageBody(AlarmMessage alarmMessage, String integrationKey, String textTemplate) {
        JsonObject body = new JsonObject();
        JsonObject payload = new JsonObject();
        payload.add("summary", (JsonElement)new JsonPrimitive(this.getFormattedMessage(alarmMessage, textTemplate)));
        payload.add("severity", (JsonElement)new JsonPrimitive("warning"));
        payload.add("source", (JsonElement)new JsonPrimitive("Skywalking"));
        body.add("payload", (JsonElement)payload);
        body.add("routing_key", (JsonElement)new JsonPrimitive(integrationKey));
        body.add("dedup_key", (JsonElement)new JsonPrimitive(UUID.randomUUID().toString()));
        body.add("event_action", (JsonElement)new JsonPrimitive("trigger"));
        return GSON.toJson((JsonElement)body);
    }

    private String getFormattedMessage(AlarmMessage alarmMessage, String textTemplate) {
        return String.format(textTemplate, alarmMessage.getAlarmMessage());
    }

    @Generated
    public PagerDutyHookCallback(AlarmRulesWatcher alarmRulesWatcher) {
        this.alarmRulesWatcher = alarmRulesWatcher;
    }
}

