/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.alarm.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.skywalking.mqe.rt.exception.ParseErrorListener;
import org.apache.skywalking.mqe.rt.grammar.MQELexer;
import org.apache.skywalking.mqe.rt.grammar.MQEParser;
import org.apache.skywalking.mqe.rt.type.ExpressionResult;
import org.apache.skywalking.mqe.rt.type.ExpressionResultType;
import org.apache.skywalking.mqe.rt.type.MQEValue;
import org.apache.skywalking.mqe.rt.type.MQEValues;
import org.apache.skywalking.oap.server.core.alarm.AlarmMessage;
import org.apache.skywalking.oap.server.core.alarm.MetaInAlarm;
import org.apache.skywalking.oap.server.core.alarm.provider.AlarmEntity;
import org.apache.skywalking.oap.server.core.alarm.provider.AlarmMessageFormatter;
import org.apache.skywalking.oap.server.core.alarm.provider.AlarmRule;
import org.apache.skywalking.oap.server.core.alarm.provider.expr.rt.AlarmMQEVisitor;
import org.apache.skywalking.oap.server.core.analysis.manual.searchtag.Tag;
import org.apache.skywalking.oap.server.core.analysis.metrics.DataTable;
import org.apache.skywalking.oap.server.core.analysis.metrics.DoubleValueHolder;
import org.apache.skywalking.oap.server.core.analysis.metrics.IntValueHolder;
import org.apache.skywalking.oap.server.core.analysis.metrics.LabeledValueHolder;
import org.apache.skywalking.oap.server.core.analysis.metrics.LongValueHolder;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.metrics.MultiIntValuesHolder;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.joda.time.LocalDateTime;
import org.joda.time.Minutes;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunningRule {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RunningRule.class);
    private static DateTimeFormatter TIME_BUCKET_FORMATTER = DateTimeFormat.forPattern((String)"yyyyMMddHHmm");
    private final String ruleName;
    private final int period;
    private final String expression;
    private final int silencePeriod;
    private final Map<AlarmEntity, Window> windows;
    private final List<String> includeNames;
    private final List<String> excludeNames;
    private final Pattern includeNamesRegex;
    private final Pattern excludeNamesRegex;
    private final AlarmMessageFormatter formatter;
    private final List<Tag> tags;
    private final Set<String> hooks;
    private final Set<String> includeMetrics;
    private final ParseTree exprTree;

    public RunningRule(AlarmRule alarmRule) {
        this.expression = alarmRule.getExpression();
        this.ruleName = alarmRule.getAlarmRuleName();
        this.includeMetrics = alarmRule.getIncludeMetrics();
        this.windows = new ConcurrentHashMap<AlarmEntity, Window>();
        this.period = alarmRule.getPeriod();
        this.silencePeriod = alarmRule.getSilencePeriod();
        this.includeNames = alarmRule.getIncludeNames();
        this.excludeNames = alarmRule.getExcludeNames();
        this.includeNamesRegex = StringUtil.isNotEmpty((String)alarmRule.getIncludeNamesRegex()) ? Pattern.compile(alarmRule.getIncludeNamesRegex()) : null;
        this.excludeNamesRegex = StringUtil.isNotEmpty((String)alarmRule.getExcludeNamesRegex()) ? Pattern.compile(alarmRule.getExcludeNamesRegex()) : null;
        this.formatter = new AlarmMessageFormatter(alarmRule.getMessage());
        this.tags = alarmRule.getTags().entrySet().stream().map(e -> new Tag((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList());
        this.hooks = alarmRule.getHooks();
        MQELexer lexer = new MQELexer((CharStream)CharStreams.fromString((String)alarmRule.getExpression()));
        MQEParser parser = new MQEParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        parser.addErrorListener((ANTLRErrorListener)new ParseErrorListener());
        this.exprTree = parser.expression();
    }

    public void in(MetaInAlarm meta, Metrics metrics) {
        if (!this.includeMetrics.contains(meta.getMetricsName())) {
            if (log.isTraceEnabled()) {
                log.trace("Metric name not in the expression, {}-{}", (Object)this.expression, (Object)meta.getMetricsName());
            }
            return;
        }
        String metaName = meta.getName();
        if (!this.validate(metaName, this.includeNames, this.excludeNames, this.includeNamesRegex, this.excludeNamesRegex)) {
            return;
        }
        AlarmEntity entity = new AlarmEntity(meta.getScope(), meta.getScopeId(), meta.getName(), meta.getId0(), meta.getId1());
        Window window = this.windows.computeIfAbsent(entity, ignored -> new Window(this.period));
        window.add(meta.getMetricsName(), metrics);
    }

    private boolean validate(String target, List<String> includeList, List<String> excludeList, Pattern includeRegex, Pattern excludeRegex) {
        if (CollectionUtils.isNotEmpty(includeList) && !includeList.contains(target)) {
            if (log.isTraceEnabled()) {
                log.trace("{} isn't in the including list {}", (Object)target, includeList);
            }
            return false;
        }
        if (CollectionUtils.isNotEmpty(excludeList) && excludeList.contains(target)) {
            if (log.isTraceEnabled()) {
                log.trace("{} is in the excluding list {}", (Object)target, excludeList);
            }
            return false;
        }
        if (includeRegex != null && !includeRegex.matcher(target).matches()) {
            if (log.isTraceEnabled()) {
                log.trace("{} doesn't match the include regex {}", (Object)target, (Object)includeRegex);
            }
            return false;
        }
        if (excludeRegex != null && excludeRegex.matcher(target).matches()) {
            if (log.isTraceEnabled()) {
                log.trace("{} matches the exclude regex {}", (Object)target, (Object)excludeRegex);
            }
            return false;
        }
        return true;
    }

    public void moveTo(LocalDateTime targetTime) {
        LocalDateTime target = targetTime.withSecondOfMinute(0).withMillisOfSecond(0);
        this.windows.values().forEach(window -> window.moveTo(target));
    }

    public List<AlarmMessage> check() {
        ArrayList<AlarmMessage> alarmMessageList = new ArrayList<AlarmMessage>(30);
        this.windows.forEach((alarmEntity, window) -> {
            Optional<AlarmMessage> alarmMessageOptional = window.checkAlarm();
            if (alarmMessageOptional.isPresent()) {
                AlarmMessage alarmMessage = alarmMessageOptional.get();
                alarmMessage.setScopeId(alarmEntity.getScopeId());
                alarmMessage.setScope(alarmEntity.getScope());
                alarmMessage.setName(alarmEntity.getName());
                alarmMessage.setId0(alarmEntity.getId0());
                alarmMessage.setId1(alarmEntity.getId1());
                alarmMessage.setRuleName(this.ruleName);
                alarmMessage.setAlarmMessage(this.formatter.format((AlarmEntity)alarmEntity));
                alarmMessage.setStartTime(System.currentTimeMillis());
                alarmMessage.setPeriod(this.period);
                alarmMessage.setTags(this.tags);
                alarmMessage.setHooks(this.hooks);
                alarmMessageList.add(alarmMessage);
            }
        });
        return alarmMessageList;
    }

    private LinkedList<Map<String, TraceLogMetric>> transformValues(LinkedList<Map<String, Metrics>> values) {
        LinkedList<Map<String, TraceLogMetric>> result = new LinkedList<Map<String, TraceLogMetric>>();
        for (Map map : values) {
            if (map == null) {
                result.add(null);
                continue;
            }
            map.forEach((name, m) -> {
                HashMap<String, TraceLogMetric> r = new HashMap<String, TraceLogMetric>();
                result.add(r);
                if (m instanceof LongValueHolder) {
                    r.put((String)name, new TraceLogMetric(m.getTimeBucket(), new Number[]{((LongValueHolder)m).getValue()}));
                } else if (m instanceof IntValueHolder) {
                    r.put((String)name, new TraceLogMetric(m.getTimeBucket(), new Number[]{((IntValueHolder)m).getValue()}));
                } else if (m instanceof DoubleValueHolder) {
                    r.put((String)name, new TraceLogMetric(m.getTimeBucket(), new Number[]{((DoubleValueHolder)m).getValue()}));
                } else if (m instanceof MultiIntValuesHolder) {
                    int[] iArr = ((MultiIntValuesHolder)m).getValues();
                    r.put((String)name, new TraceLogMetric(m.getTimeBucket(), (Number[])Arrays.stream(iArr).boxed().toArray(Number[]::new)));
                } else if (m instanceof LabeledValueHolder) {
                    DataTable dt = ((LabeledValueHolder)m).getValue();
                    TraceLogMetric l = new TraceLogMetric(m.getTimeBucket(), dt.sortedValues(Comparator.naturalOrder()).toArray(new Number[0]));
                    l.labels = dt.sortedKeys(Comparator.naturalOrder()).toArray(new String[0]);
                    r.put((String)name, l);
                } else {
                    log.warn("Unsupported metrics {}", m);
                }
            });
        }
        return result;
    }

    public class Window {
        private LocalDateTime endTime;
        private final int period;
        private int silenceCountdown;
        private LinkedList<Map<String, Metrics>> values;
        private ReentrantLock lock = new ReentrantLock();

        public Window(int period) {
            this.period = period;
            this.silenceCountdown = -1;
            this.init();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void moveTo(LocalDateTime current) {
            this.lock.lock();
            try {
                if (this.endTime == null) {
                    this.init();
                } else {
                    int minutes = Minutes.minutesBetween((ReadablePartial)this.endTime, (ReadablePartial)current).getMinutes();
                    if (minutes <= 0) {
                        return;
                    }
                    if (minutes > this.values.size()) {
                        this.init();
                    } else {
                        for (int i = 0; i < minutes; ++i) {
                            this.values.removeFirst();
                            this.values.addLast(null);
                        }
                    }
                }
                this.endTime = current;
            }
            finally {
                this.lock.unlock();
            }
            if (log.isTraceEnabled()) {
                log.trace("Move window {}", RunningRule.this.transformValues(this.values));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(String metricsName, Metrics metrics) {
            long bucket = metrics.getTimeBucket();
            LocalDateTime timeBucket = TIME_BUCKET_FORMATTER.parseLocalDateTime("" + bucket);
            this.lock.lock();
            try {
                int minutes;
                if (this.endTime == null) {
                    this.init();
                    this.endTime = timeBucket;
                }
                if ((minutes = Minutes.minutesBetween((ReadablePartial)timeBucket, (ReadablePartial)this.endTime).getMinutes()) < 0) {
                    this.moveTo(timeBucket);
                    minutes = 0;
                }
                if (minutes >= this.values.size()) {
                    if (log.isTraceEnabled()) {
                        log.trace("Timebucket is {}, endTime is {} and value size is {}", new Object[]{timeBucket, this.endTime, this.values.size()});
                    }
                    return;
                }
                int index = this.values.size() - minutes - 1;
                Map<String, Metrics> metricsMap = this.values.get(index);
                if (metricsMap == null) {
                    metricsMap = new HashMap<String, Metrics>();
                    metricsMap.put(metricsName, metrics);
                    this.values.set(index, metricsMap);
                } else {
                    metricsMap.put(metricsName, metrics);
                }
            }
            finally {
                this.lock.unlock();
            }
            if (log.isTraceEnabled()) {
                log.trace("Add metric {} to window {}", (Object)metrics, RunningRule.this.transformValues(this.values));
            }
        }

        public Optional<AlarmMessage> checkAlarm() {
            if (this.isMatch()) {
                if (this.silenceCountdown < 1) {
                    this.silenceCountdown = RunningRule.this.silencePeriod;
                    return Optional.of(new AlarmMessage());
                }
                --this.silenceCountdown;
            } else {
                --this.silenceCountdown;
            }
            return Optional.empty();
        }

        private boolean isMatch() {
            int isMatch = 0;
            AlarmMQEVisitor visitor = new AlarmMQEVisitor(this.values, this.endTime);
            ExpressionResult parseResult = (ExpressionResult)visitor.visit(RunningRule.this.exprTree);
            if (StringUtil.isNotBlank((String)parseResult.getError())) {
                log.error("expression:" + RunningRule.this.expression + " error: " + parseResult.getError());
                return false;
            }
            if (!parseResult.isBoolResult() || ExpressionResultType.SINGLE_VALUE != parseResult.getType() || CollectionUtils.isEmpty((List)parseResult.getResults())) {
                return false;
            }
            if (!parseResult.isLabeledResult()) {
                MQEValues mqeValues = (MQEValues)parseResult.getResults().get(0);
                if (mqeValues != null && CollectionUtils.isNotEmpty((List)mqeValues.getValues()) && mqeValues.getValues().get(0) != null) {
                    isMatch = (int)((MQEValue)mqeValues.getValues().get(0)).getDoubleValue();
                }
            } else {
                MQEValues mqeValues;
                Iterator iterator = parseResult.getResults().iterator();
                while (iterator.hasNext() && ((mqeValues = (MQEValues)iterator.next()) == null || !CollectionUtils.isNotEmpty((List)mqeValues.getValues()) || mqeValues.getValues().get(0) == null || (isMatch = (int)((MQEValue)mqeValues.getValues().get(0)).getDoubleValue()) != 1)) {
                }
            }
            if (log.isTraceEnabled()) {
                log.trace("Match expression is {}", (Object)RunningRule.this.expression);
            }
            return isMatch == 1;
        }

        private void init() {
            this.values = new LinkedList();
            for (int i = 0; i < this.period; ++i) {
                this.values.add(null);
            }
        }
    }

    private static class TraceLogMetric {
        private final long timeBucket;
        private final Number[] value;
        private String[] labels;

        @Generated
        public TraceLogMetric(long timeBucket, Number[] value) {
            this.timeBucket = timeBucket;
            this.value = value;
        }

        @Generated
        public String toString() {
            return "RunningRule.TraceLogMetric(timeBucket=" + this.timeBucket + ", value=" + Arrays.deepToString(this.value) + ", labels=" + Arrays.deepToString(this.labels) + ")";
        }
    }
}

