/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.library.datacarrier.buffer;

import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import org.apache.skywalking.oap.server.library.datacarrier.buffer.BufferStrategy;
import org.apache.skywalking.oap.server.library.datacarrier.buffer.QueueBuffer;

public class ArrayBlockingQueueBuffer<T>
implements QueueBuffer<T> {
    private BufferStrategy strategy;
    private ArrayBlockingQueue<T> queue;
    private int bufferSize;

    ArrayBlockingQueueBuffer(int bufferSize, BufferStrategy strategy) {
        this.strategy = strategy;
        this.queue = new ArrayBlockingQueue(bufferSize);
        this.bufferSize = bufferSize;
    }

    @Override
    public boolean save(T data) {
        try {
            this.queue.put(data);
        }
        catch (InterruptedException e) {
            return false;
        }
        return true;
    }

    @Override
    public void setStrategy(BufferStrategy strategy) {
        this.strategy = strategy;
    }

    @Override
    public void obtain(List<T> consumeList) {
        this.queue.drainTo(consumeList);
    }

    @Override
    public int getBufferSize() {
        return this.bufferSize;
    }
}

