/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.meter.analyzer.prometheus;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import io.vavr.API;
import io.vavr.Predicates;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.skywalking.oap.meter.analyzer.Analyzer;
import org.apache.skywalking.oap.meter.analyzer.MetricConvert;
import org.apache.skywalking.oap.meter.analyzer.dsl.Sample;
import org.apache.skywalking.oap.meter.analyzer.dsl.SampleFamily;
import org.apache.skywalking.oap.meter.analyzer.dsl.SampleFamilyBuilder;
import org.apache.skywalking.oap.meter.analyzer.prometheus.rule.Rule;
import org.apache.skywalking.oap.server.core.analysis.meter.MeterSystem;
import org.apache.skywalking.oap.server.library.util.prometheus.metrics.Counter;
import org.apache.skywalking.oap.server.library.util.prometheus.metrics.Gauge;
import org.apache.skywalking.oap.server.library.util.prometheus.metrics.Histogram;
import org.apache.skywalking.oap.server.library.util.prometheus.metrics.Metric;
import org.apache.skywalking.oap.server.library.util.prometheus.metrics.Summary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrometheusMetricConverter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PrometheusMetricConverter.class);
    private final Pattern metricsNameEscapePattern;
    private final LoadingCache<String, String> escapedMetricsNameCache = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<String, String>(){

        public String load(String name) {
            return PrometheusMetricConverter.this.metricsNameEscapePattern.matcher(name).replaceAll("_");
        }
    });
    private final MetricConvert convert;

    public PrometheusMetricConverter(Rule rule, MeterSystem service) {
        this.convert = new MetricConvert(rule, service);
        this.metricsNameEscapePattern = Pattern.compile("[/.]");
    }

    public void toMeter(Stream<Metric> metricStream) {
        ImmutableMap<String, SampleFamily> data = this.convertPromMetricToSampleFamily(metricStream);
        this.convert.toMeter(data);
    }

    public ImmutableMap<String, SampleFamily> convertPromMetricToSampleFamily(Stream<Metric> metricStream) {
        return (ImmutableMap)metricStream.peek(metric -> log.debug("Prom metric to be convert to SampleFamily: {}", metric)).flatMap(this::convertMetric).filter(t -> t != Analyzer.NIL && ((SampleFamily)t._2).samples.length > 0).peek(t -> log.debug("SampleFamily: {}", t)).collect(ImmutableMap.toImmutableMap(Tuple2::_1, Tuple2::_2, (a, b) -> {
            log.debug("merge {} {}", a, b);
            Sample[] m = new Sample[a.samples.length + b.samples.length];
            System.arraycopy(a.samples, 0, m, 0, a.samples.length);
            System.arraycopy(b.samples, 0, m, a.samples.length, b.samples.length);
            return SampleFamilyBuilder.newBuilder(m).build();
        }));
    }

    private Stream<Tuple2<String, SampleFamily>> convertMetric(Metric metric) {
        return (Stream)API.Match((Object)metric).of(new API.Match.Case[]{API.Case((API.Match.Pattern0)API.$((Predicate)Predicates.instanceOf(Histogram.class)), t -> Stream.of(Tuple.of((Object)this.escapedName(metric.getName() + "_count"), (Object)SampleFamilyBuilder.newBuilder(Sample.builder().name(this.escapedName(metric.getName() + "_count")).timestamp(metric.getTimestamp()).labels((ImmutableMap<String, String>)ImmutableMap.copyOf((Map)metric.getLabels())).value(((Histogram)metric).getSampleCount()).build()).build()), Tuple.of((Object)this.escapedName(metric.getName() + "_sum"), (Object)SampleFamilyBuilder.newBuilder(Sample.builder().name(this.escapedName(metric.getName() + "_sum")).timestamp(metric.getTimestamp()).labels((ImmutableMap<String, String>)ImmutableMap.copyOf((Map)metric.getLabels())).value(((Histogram)metric).getSampleSum()).build()).build()), this.convertToSample(metric).orElse(Analyzer.NIL))), API.Case((API.Match.Pattern0)API.$((Predicate)Predicates.instanceOf(Summary.class)), t -> Stream.of(Tuple.of((Object)this.escapedName(metric.getName() + "_count"), (Object)SampleFamilyBuilder.newBuilder(Sample.builder().name(this.escapedName(metric.getName() + "_count")).timestamp(metric.getTimestamp()).labels((ImmutableMap<String, String>)ImmutableMap.copyOf((Map)metric.getLabels())).value(((Summary)metric).getSampleCount()).build()).build()), Tuple.of((Object)this.escapedName(metric.getName() + "_sum"), (Object)SampleFamilyBuilder.newBuilder(Sample.builder().name(this.escapedName(metric.getName() + "_sum")).timestamp(metric.getTimestamp()).labels((ImmutableMap<String, String>)ImmutableMap.copyOf((Map)metric.getLabels())).value(((Summary)metric).getSampleSum()).build()).build()), this.convertToSample(metric).orElse(Analyzer.NIL))), API.Case((API.Match.Pattern0)API.$(), t -> Stream.of(this.convertToSample(metric).orElse(Analyzer.NIL)))});
    }

    private Optional<Tuple2<String, SampleFamily>> convertToSample(Metric metric) {
        Sample[] ss = ((List)API.Match((Object)metric).of(new API.Match.Case[]{API.Case((API.Match.Pattern0)API.$((Predicate)Predicates.instanceOf(Counter.class)), t -> Collections.singletonList(Sample.builder().name(this.escapedName(t.getName())).labels((ImmutableMap<String, String>)ImmutableMap.copyOf((Map)t.getLabels())).timestamp(t.getTimestamp()).value(t.getValue()).build())), API.Case((API.Match.Pattern0)API.$((Predicate)Predicates.instanceOf(Gauge.class)), t -> Collections.singletonList(Sample.builder().name(this.escapedName(t.getName())).labels((ImmutableMap<String, String>)ImmutableMap.copyOf((Map)t.getLabels())).timestamp(t.getTimestamp()).value(t.getValue()).build())), API.Case((API.Match.Pattern0)API.$((Predicate)Predicates.instanceOf(Histogram.class)), t -> t.getBuckets().entrySet().stream().map(b -> Sample.builder().name(this.escapedName(t.getName())).labels((ImmutableMap<String, String>)ImmutableMap.builder().putAll(t.getLabels()).put((Object)"le", (Object)((Double)b.getKey()).toString()).build()).timestamp(t.getTimestamp()).value(((Long)b.getValue()).longValue()).build()).collect(Collectors.toList())), API.Case((API.Match.Pattern0)API.$((Predicate)Predicates.instanceOf(Summary.class)), t -> t.getQuantiles().entrySet().stream().map(b -> Sample.builder().name(this.escapedName(t.getName())).labels((ImmutableMap<String, String>)ImmutableMap.builder().putAll(t.getLabels()).put((Object)"quantile", (Object)((Double)b.getKey()).toString()).build()).timestamp(t.getTimestamp()).value((Double)b.getValue()).build()).collect(Collectors.toList()))})).toArray(new Sample[0]);
        if (ss.length < 1) {
            return Optional.empty();
        }
        return Optional.of(Tuple.of((Object)this.escapedName(metric.getName()), (Object)SampleFamilyBuilder.newBuilder(ss).build()));
    }

    protected String escapedName(String name) {
        try {
            return (String)this.escapedMetricsNameCache.get((Object)name);
        }
        catch (ExecutionException e) {
            log.error("Failed to get escaped metrics name from cache", (Throwable)e);
            return this.metricsNameEscapePattern.matcher(name).replaceAll("_");
        }
    }
}

