/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.meter.analyzer;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import io.vavr.control.Try;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.skywalking.oap.meter.analyzer.Analyzer;
import org.apache.skywalking.oap.meter.analyzer.MetricRuleConfig;
import org.apache.skywalking.oap.meter.analyzer.dsl.DSL;
import org.apache.skywalking.oap.meter.analyzer.dsl.Expression;
import org.apache.skywalking.oap.meter.analyzer.dsl.ExpressionParsingException;
import org.apache.skywalking.oap.meter.analyzer.dsl.Result;
import org.apache.skywalking.oap.meter.analyzer.dsl.SampleFamily;
import org.apache.skywalking.oap.server.core.analysis.meter.MeterSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricConvert {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetricConvert.class);
    private final List<Analyzer> analyzers;

    public static <T> Stream<T> log(Try<T> t, String debugMessage) {
        return t.onSuccess(i -> log.debug(debugMessage + " :{}", i)).onFailure(e -> log.debug(debugMessage + " failed", e)).toJavaStream();
    }

    public MetricConvert(MetricRuleConfig rule, MeterSystem service) {
        Preconditions.checkState((!Strings.isNullOrEmpty((String)rule.getMetricPrefix()) ? 1 : 0) != 0);
        if (StringUtils.isNotEmpty((CharSequence)rule.getInitExp())) {
            this.handleInitExp(rule.getInitExp());
        }
        this.analyzers = rule.getMetricsRules().stream().map(r -> this.buildAnalyzer(this.formatMetricName(rule, r.getName()), rule.getFilter(), this.formatExp(rule.getExpPrefix(), rule.getExpSuffix(), r.getExp()), service)).collect(Collectors.toList());
    }

    Analyzer buildAnalyzer(String metricsName, String filter, String exp, MeterSystem service) {
        return Analyzer.build(metricsName, filter, exp, service);
    }

    private String formatExp(String expPrefix, String expSuffix, String exp) {
        String ret = exp;
        if (!Strings.isNullOrEmpty((String)expPrefix)) {
            ret = String.format("(%s.%s)", StringUtils.substringBefore((String)exp, (String)"."), expPrefix);
            String after = StringUtils.substringAfter((String)exp, (String)".");
            if (!Strings.isNullOrEmpty((String)after)) {
                ret = String.format("(%s.%s)", ret, after);
            }
        }
        if (!Strings.isNullOrEmpty((String)expSuffix)) {
            ret = String.format("(%s).%s", ret, expSuffix);
        }
        return ret;
    }

    public void toMeter(ImmutableMap<String, SampleFamily> sampleFamilies) {
        Preconditions.checkNotNull(sampleFamilies);
        if (sampleFamilies.size() < 1) {
            return;
        }
        for (Analyzer each : this.analyzers) {
            try {
                each.analyse(sampleFamilies);
            }
            catch (Throwable t) {
                log.error("Analyze {} error", (Object)each, (Object)t);
            }
        }
    }

    private String formatMetricName(MetricRuleConfig rule, String meterRuleName) {
        StringJoiner metricName = new StringJoiner("_");
        metricName.add(rule.getMetricPrefix()).add(meterRuleName);
        return metricName.toString();
    }

    private void handleInitExp(String exp) {
        Expression e = DSL.parse(exp);
        Result result = e.run((Map<String, SampleFamily>)ImmutableMap.of());
        if (!result.isSuccess() && result.isThrowable()) {
            throw new ExpressionParsingException("failed to execute init expression: " + exp + ", error:" + result.getError());
        }
    }
}

