/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.cluster.plugin.nacos;

import com.alibaba.nacos.api.naming.NamingFactory;
import com.alibaba.nacos.api.naming.NamingService;
import java.util.Properties;
import org.apache.skywalking.oap.server.cluster.plugin.nacos.ClusterModuleNacosConfig;
import org.apache.skywalking.oap.server.cluster.plugin.nacos.NacosCoordinator;
import org.apache.skywalking.oap.server.core.cluster.ClusterCoordinator;
import org.apache.skywalking.oap.server.core.cluster.ClusterModule;
import org.apache.skywalking.oap.server.core.cluster.ClusterNodesQuery;
import org.apache.skywalking.oap.server.core.cluster.ClusterRegister;
import org.apache.skywalking.oap.server.library.module.ModuleDefine;
import org.apache.skywalking.oap.server.library.module.ModuleDefineHolder;
import org.apache.skywalking.oap.server.library.module.ModuleProvider;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.library.module.Service;
import org.apache.skywalking.oap.server.library.module.ServiceNotProvidedException;
import org.apache.skywalking.oap.server.library.util.StringUtil;

public class ClusterModuleNacosProvider
extends ModuleProvider {
    private ClusterModuleNacosConfig config;
    private NamingService namingService;

    public String name() {
        return "nacos";
    }

    public Class<? extends ModuleDefine> module() {
        return ClusterModule.class;
    }

    public ModuleProvider.ConfigCreator newConfigCreator() {
        return new ModuleProvider.ConfigCreator<ClusterModuleNacosConfig>(){

            public Class type() {
                return ClusterModuleNacosConfig.class;
            }

            public void onInitialized(ClusterModuleNacosConfig initialized) {
                ClusterModuleNacosProvider.this.config = initialized;
            }
        };
    }

    public void prepare() throws ServiceNotProvidedException, ModuleStartException {
        try {
            Properties properties = new Properties();
            properties.put("serverAddr", this.config.getHostPort());
            properties.put("namespace", this.config.getNamespace());
            if (StringUtil.isNotEmpty((String)this.config.getUsername()) && StringUtil.isNotEmpty((String)this.config.getAccessKey())) {
                throw new ModuleStartException("Nacos Auth method should choose either username or accessKey, not both");
            }
            if (StringUtil.isNotEmpty((String)this.config.getUsername())) {
                properties.put("username", this.config.getUsername());
                properties.put("password", this.config.getPassword());
            } else if (StringUtil.isNotEmpty((String)this.config.getAccessKey())) {
                properties.put("accessKey", this.config.getAccessKey());
                properties.put("secretKey", this.config.getSecretKey());
            }
            this.namingService = NamingFactory.createNamingService((Properties)properties);
            NacosCoordinator coordinator = new NacosCoordinator((ModuleDefineHolder)this.getManager(), this.namingService, this.config);
            this.registerServiceImplementation(ClusterRegister.class, (Service)coordinator);
            this.registerServiceImplementation(ClusterNodesQuery.class, (Service)coordinator);
            this.registerServiceImplementation(ClusterCoordinator.class, (Service)coordinator);
        }
        catch (Exception e) {
            throw new ModuleStartException(e.getMessage(), (Throwable)e);
        }
    }

    public void start() throws ServiceNotProvidedException {
    }

    public void notifyAfterCompleted() throws ServiceNotProvidedException {
    }

    public String[] requiredModules() {
        return new String[]{"core"};
    }
}

