/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.banyandb.measure;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.skywalking.banyandb.v1.client.DataPoint;
import org.apache.skywalking.banyandb.v1.client.MeasureQuery;
import org.apache.skywalking.banyandb.v1.client.MeasureQueryResponse;
import org.apache.skywalking.banyandb.v1.client.TimestampRange;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.analysis.manual.searchtag.TagType;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.storage.query.ITagAutoCompleteQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBStorageClient;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.AbstractBanyanDBDAO;

public class BanyanDBTagAutocompleteQueryDAO
extends AbstractBanyanDBDAO
implements ITagAutoCompleteQueryDAO {
    private static final Set<String> TAGS_KEY = ImmutableSet.of((Object)"tag_type", (Object)"tag_key");
    private static final Set<String> TAGS_KV = ImmutableSet.of((Object)"tag_type", (Object)"tag_key", (Object)"tag_value");

    public BanyanDBTagAutocompleteQueryDAO(BanyanDBStorageClient client) {
        super(client);
    }

    public Set<String> queryTagAutocompleteKeys(final TagType tagType, final int limit, Duration duration) throws IOException {
        MeasureQueryResponse resp;
        long startTB = 0L;
        long endTB = 0L;
        if (Objects.nonNull(duration)) {
            startTB = TimeBucket.getMinuteTimeBucket((long)duration.getStartTimestamp());
            endTB = TimeBucket.getMinuteTimeBucket((long)duration.getEndTimestamp());
        }
        TimestampRange range = null;
        if (startTB > 0L && endTB > 0L) {
            range = new TimestampRange(TimeBucket.getTimestamp((long)startTB), TimeBucket.getTimestamp((long)endTB));
        }
        if ((resp = this.query("tag_autocomplete", TAGS_KEY, Collections.emptySet(), range, new AbstractBanyanDBDAO.QueryBuilder<MeasureQuery>(){

            @Override
            protected void apply(MeasureQuery query) {
                query.groupBy((Set)ImmutableSet.of((Object)"tag_key"));
                query.setLimit(Integer.valueOf(limit));
                query.and(this.eq("tag_type", tagType.name()));
            }
        })).size() == 0) {
            return Collections.emptySet();
        }
        HashSet<String> keys = new HashSet<String>();
        for (DataPoint dp : resp.getDataPoints()) {
            keys.add((String)dp.getTagValue("tag_key"));
        }
        return keys;
    }

    public Set<String> queryTagAutocompleteValues(final TagType tagType, final String tagKey, final int limit, Duration duration) throws IOException {
        MeasureQueryResponse resp;
        long startSecondTB = 0L;
        long endSecondTB = 0L;
        if (Objects.nonNull(duration)) {
            startSecondTB = duration.getStartTimeBucketInSec();
            endSecondTB = duration.getEndTimeBucketInSec();
        }
        long startTB = startSecondTB / 1000000L * 10000L;
        long endTB = endSecondTB / 1000000L * 10000L + 2359L;
        TimestampRange range = null;
        if (startTB > 0L && endTB > 0L) {
            range = new TimestampRange(TimeBucket.getTimestamp((long)startTB), TimeBucket.getTimestamp((long)endTB));
        }
        if ((resp = this.query("tag_autocomplete", TAGS_KV, Collections.emptySet(), range, new AbstractBanyanDBDAO.QueryBuilder<MeasureQuery>(){

            @Override
            protected void apply(MeasureQuery query) {
                query.groupBy((Set)ImmutableSet.of((Object)"tag_value"));
                query.setLimit(Integer.valueOf(limit));
                query.and(this.eq("tag_type", tagType.name()));
                query.and(this.eq("tag_key", tagKey));
            }
        })).size() == 0) {
            return Collections.emptySet();
        }
        HashSet<String> values = new HashSet<String>();
        for (DataPoint dp : resp.getDataPoints()) {
            values.add((String)dp.getTagValue("tag_value"));
        }
        return values;
    }
}

