/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.banyandb.measure;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.skywalking.banyandb.v1.client.MeasureQuery;
import org.apache.skywalking.oap.server.core.storage.profiling.ebpf.IServiceLabelDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBStorageClient;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.AbstractBanyanDBDAO;

public class BanyanDBServiceLabelDAO
extends AbstractBanyanDBDAO
implements IServiceLabelDAO {
    private static final Set<String> TAGS = ImmutableSet.of((Object)"label", (Object)"service_id");

    public BanyanDBServiceLabelDAO(BanyanDBStorageClient client) {
        super(client);
    }

    public List<String> queryAllLabels(final String serviceId) throws IOException {
        return this.query("service_label", TAGS, Collections.emptySet(), new AbstractBanyanDBDAO.QueryBuilder<MeasureQuery>(){

            @Override
            protected void apply(MeasureQuery query) {
                query.and(this.eq("service_id", serviceId));
            }
        }).getDataPoints().stream().map(point -> (String)point.getTagValue("label")).collect(Collectors.toList());
    }
}

