/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.banyandb.measure;

import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.skywalking.banyandb.v1.client.DataPoint;
import org.apache.skywalking.banyandb.v1.client.MeasureQuery;
import org.apache.skywalking.banyandb.v1.client.MeasureQueryResponse;
import org.apache.skywalking.banyandb.v1.client.TimestampRange;
import org.apache.skywalking.oap.server.core.analysis.DownSampling;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.analysis.manual.endpoint.EndpointTraffic;
import org.apache.skywalking.oap.server.core.analysis.manual.instance.InstanceTraffic;
import org.apache.skywalking.oap.server.core.analysis.manual.process.ProcessDetectType;
import org.apache.skywalking.oap.server.core.analysis.manual.process.ProcessTraffic;
import org.apache.skywalking.oap.server.core.analysis.manual.service.ServiceTraffic;
import org.apache.skywalking.oap.server.core.query.enumeration.Language;
import org.apache.skywalking.oap.server.core.query.enumeration.ProfilingSupportStatus;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.type.Attribute;
import org.apache.skywalking.oap.server.core.query.type.Endpoint;
import org.apache.skywalking.oap.server.core.query.type.Process;
import org.apache.skywalking.oap.server.core.query.type.Service;
import org.apache.skywalking.oap.server.core.query.type.ServiceInstance;
import org.apache.skywalking.oap.server.core.storage.query.IMetadataQueryDAO;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBConverter;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBStorageClient;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.MetadataRegistry;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.AbstractBanyanDBDAO;

public class BanyanDBMetadataQueryDAO
extends AbstractBanyanDBDAO
implements IMetadataQueryDAO {
    private static final Set<String> SERVICE_TRAFFIC_TAGS = ImmutableSet.of((Object)"service_traffic_name", (Object)"short_name", (Object)"service_group", (Object)"layer", (Object)"service_id");
    private static final Set<String> INSTANCE_TRAFFIC_TAGS = ImmutableSet.of((Object)"instance_traffic_name", (Object)"properties", (Object)"last_ping", (Object)"service_id");
    private static final Set<String> INSTANCE_TRAFFIC_COMPACT_TAGS = ImmutableSet.of((Object)"instance_traffic_name", (Object)"properties");
    private static final Set<String> ENDPOINT_TRAFFIC_TAGS = ImmutableSet.of((Object)"endpoint_traffic_name", (Object)"service_id");
    private static final Set<String> PROCESS_TRAFFIC_TAGS = ImmutableSet.of((Object)"name", (Object)"service_id", (Object)"instance_id", (Object)"agent_id", (Object)"detect_type", (Object)"properties", (Object[])new String[]{"labels_json", "last_ping", "profiling_support_status"});
    private static final Set<String> PROCESS_TRAFFIC_COMPACT_TAGS = ImmutableSet.of((Object)"name", (Object)"service_id", (Object)"instance_id", (Object)"agent_id", (Object)"detect_type", (Object)"properties", (Object[])new String[]{"labels_json"});
    private static final Gson GSON = new Gson();

    public BanyanDBMetadataQueryDAO(BanyanDBStorageClient client) {
        super(client);
    }

    public List<Service> listServices() throws IOException {
        MeasureQueryResponse resp = this.query("service_traffic", SERVICE_TRAFFIC_TAGS, Collections.emptySet(), new AbstractBanyanDBDAO.QueryBuilder<MeasureQuery>(){

            @Override
            protected void apply(MeasureQuery query) {
            }
        });
        ArrayList<Service> services = new ArrayList<Service>();
        MetadataRegistry.Schema schema = MetadataRegistry.INSTANCE.findMetadata("service_traffic", DownSampling.Minute);
        for (DataPoint dataPoint : resp.getDataPoints()) {
            services.add(this.buildService(dataPoint, schema));
        }
        return services;
    }

    public List<ServiceInstance> listInstances(final Duration duration, final String serviceId) throws IOException {
        MeasureQueryResponse resp = this.query("instance_traffic", INSTANCE_TRAFFIC_TAGS, Collections.emptySet(), new TimestampRange(0L, duration.getEndTimestamp()), new AbstractBanyanDBDAO.QueryBuilder<MeasureQuery>(){

            @Override
            protected void apply(MeasureQuery query) {
                if (StringUtil.isNotEmpty((String)serviceId)) {
                    query.and(this.eq("service_id", serviceId));
                }
                long minuteTimeBucket = TimeBucket.getMinuteTimeBucket((long)duration.getStartTimestamp());
                query.and(this.gte("last_ping", minuteTimeBucket));
            }
        });
        ArrayList<ServiceInstance> instances = new ArrayList<ServiceInstance>();
        MetadataRegistry.Schema schema = MetadataRegistry.INSTANCE.findMetadata("instance_traffic", DownSampling.Minute);
        for (DataPoint dataPoint : resp.getDataPoints()) {
            instances.add(this.buildInstance(dataPoint, schema));
        }
        return instances;
    }

    public ServiceInstance getInstance(String instanceId) throws IOException {
        final IDManager.ServiceInstanceID.InstanceIDDefinition id = IDManager.ServiceInstanceID.analysisId((String)instanceId);
        MeasureQueryResponse resp = this.query("instance_traffic", INSTANCE_TRAFFIC_COMPACT_TAGS, Collections.emptySet(), new AbstractBanyanDBDAO.QueryBuilder<MeasureQuery>(){

            @Override
            protected void apply(MeasureQuery query) {
                query.and(this.eq("service_id", id.getServiceId())).and(this.eq("instance_traffic_name", id.getName()));
            }
        });
        MetadataRegistry.Schema schema = MetadataRegistry.INSTANCE.findMetadata("instance_traffic", DownSampling.Minute);
        return resp.size() > 0 ? this.buildInstance((DataPoint)resp.getDataPoints().get(0), schema) : null;
    }

    public List<ServiceInstance> getInstances(final List<String> instanceIds) throws IOException {
        MeasureQueryResponse resp = this.query("instance_traffic", INSTANCE_TRAFFIC_TAGS, Collections.emptySet(), new AbstractBanyanDBDAO.QueryBuilder<MeasureQuery>(){

            @Override
            protected void apply(MeasureQuery query) {
                query.and(this.in("id", instanceIds));
            }
        });
        MetadataRegistry.Schema schema = MetadataRegistry.INSTANCE.findMetadata("instance_traffic", DownSampling.Minute);
        return resp.getDataPoints().stream().map(e -> this.buildInstance((DataPoint)e, schema)).collect(Collectors.toList());
    }

    public List<Endpoint> findEndpoint(String keyword, final String serviceId, int limit) throws IOException {
        MeasureQueryResponse resp = this.query("endpoint_traffic", ENDPOINT_TRAFFIC_TAGS, Collections.emptySet(), new AbstractBanyanDBDAO.QueryBuilder<MeasureQuery>(){

            @Override
            protected void apply(MeasureQuery query) {
                if (StringUtil.isNotEmpty((String)serviceId)) {
                    query.and(this.eq("service_id", serviceId));
                }
            }
        });
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        MetadataRegistry.Schema schema = MetadataRegistry.INSTANCE.findMetadata("endpoint_traffic", DownSampling.Minute);
        for (DataPoint dataPoint : resp.getDataPoints()) {
            endpoints.add(this.buildEndpoint(dataPoint, schema));
        }
        if (StringUtil.isNotEmpty((String)serviceId)) {
            return endpoints.stream().filter(e -> e.getName().contains(keyword)).collect(Collectors.toList());
        }
        return endpoints;
    }

    public List<Process> listProcesses(final String serviceId, final ProfilingSupportStatus supportStatus, final long lastPingStartTimeBucket, final long lastPingEndTimeBucket) throws IOException {
        MeasureQueryResponse resp = this.query("process_traffic", PROCESS_TRAFFIC_TAGS, Collections.emptySet(), new AbstractBanyanDBDAO.QueryBuilder<MeasureQuery>(){

            @Override
            protected void apply(MeasureQuery query) {
                query.and(this.eq("service_id", serviceId));
                if (lastPingStartTimeBucket > 0L) {
                    query.and(this.gte("last_ping", lastPingStartTimeBucket));
                }
                if (lastPingEndTimeBucket > 0L) {
                    query.and(this.lte("last_ping", lastPingEndTimeBucket));
                }
                if (supportStatus != null) {
                    query.and(this.eq("profiling_support_status", supportStatus.value()));
                }
                query.and(this.ne("detect_type", ProcessDetectType.VIRTUAL.value()));
            }
        });
        ArrayList<Process> processes = new ArrayList<Process>();
        MetadataRegistry.Schema schema = MetadataRegistry.INSTANCE.findMetadata("process_traffic", DownSampling.Minute);
        for (DataPoint dataPoint : resp.getDataPoints()) {
            processes.add(this.buildProcess(dataPoint, schema));
        }
        return processes;
    }

    public List<Process> listProcesses(final String serviceInstanceId, Duration duration, final boolean includeVirtual) throws IOException {
        final long lastPingStartTimeBucket = duration.getStartTimeBucket();
        MeasureQueryResponse resp = this.query("process_traffic", PROCESS_TRAFFIC_TAGS, Collections.emptySet(), new AbstractBanyanDBDAO.QueryBuilder<MeasureQuery>(){

            @Override
            protected void apply(MeasureQuery query) {
                query.and(this.eq("instance_id", serviceInstanceId));
                query.and(this.gte("last_ping", lastPingStartTimeBucket));
                if (!includeVirtual) {
                    query.and(this.ne("detect_type", ProcessDetectType.VIRTUAL.value()));
                }
            }
        });
        ArrayList<Process> processes = new ArrayList<Process>();
        MetadataRegistry.Schema schema = MetadataRegistry.INSTANCE.findMetadata("process_traffic", DownSampling.Minute);
        for (DataPoint dataPoint : resp.getDataPoints()) {
            processes.add(this.buildProcess(dataPoint, schema));
        }
        return processes;
    }

    public List<Process> listProcesses(final String agentId) throws IOException {
        MeasureQueryResponse resp = this.query("process_traffic", PROCESS_TRAFFIC_TAGS, Collections.emptySet(), new AbstractBanyanDBDAO.QueryBuilder<MeasureQuery>(){

            @Override
            protected void apply(MeasureQuery query) {
                query.and(this.eq("agent_id", agentId));
                query.and(this.ne("detect_type", ProcessDetectType.VIRTUAL.value()));
            }
        });
        ArrayList<Process> processes = new ArrayList<Process>();
        MetadataRegistry.Schema schema = MetadataRegistry.INSTANCE.findMetadata("process_traffic", DownSampling.Minute);
        for (DataPoint dataPoint : resp.getDataPoints()) {
            processes.add(this.buildProcess(dataPoint, schema));
        }
        return processes;
    }

    public long getProcessCount(final String serviceId, final ProfilingSupportStatus profilingSupportStatus, final long lastPingStartTimeBucket, long lastPingEndTimeBucket) throws IOException {
        MeasureQueryResponse resp = this.query("process_traffic", PROCESS_TRAFFIC_TAGS, Collections.emptySet(), new AbstractBanyanDBDAO.QueryBuilder<MeasureQuery>(){

            @Override
            protected void apply(MeasureQuery query) {
                query.and(this.eq("service_id", serviceId));
                query.and(this.gte("last_ping", lastPingStartTimeBucket));
                query.and(this.eq("profiling_support_status", profilingSupportStatus.value()));
                query.and(this.ne("detect_type", ProcessDetectType.VIRTUAL.value()));
            }
        });
        return resp.getDataPoints().stream().collect(Collectors.groupingBy(dataPoint -> (String)dataPoint.getTagValue("properties"))).size();
    }

    public long getProcessCount(final String instanceId) throws IOException {
        MeasureQueryResponse resp = this.query("process_traffic", PROCESS_TRAFFIC_TAGS, Collections.emptySet(), new AbstractBanyanDBDAO.QueryBuilder<MeasureQuery>(){

            @Override
            protected void apply(MeasureQuery query) {
                query.and(this.eq("instance_id", instanceId));
                query.and(this.ne("detect_type", ProcessDetectType.VIRTUAL.value()));
            }
        });
        return resp.getDataPoints().stream().collect(Collectors.groupingBy(dataPoint -> (String)dataPoint.getTagValue("properties"))).size();
    }

    public Process getProcess(final String processId) throws IOException {
        MeasureQueryResponse resp = this.query("process_traffic", PROCESS_TRAFFIC_COMPACT_TAGS, Collections.emptySet(), new AbstractBanyanDBDAO.QueryBuilder<MeasureQuery>(){

            @Override
            protected void apply(MeasureQuery query) {
                if (StringUtil.isNotEmpty((String)processId)) {
                    query.and(this.eq("id", processId));
                }
            }
        });
        MetadataRegistry.Schema schema = MetadataRegistry.INSTANCE.findMetadata("process_traffic", DownSampling.Minute);
        return resp.size() > 0 ? this.buildProcess((DataPoint)resp.getDataPoints().get(0), schema) : null;
    }

    private Service buildService(DataPoint dataPoint, MetadataRegistry.Schema schema) {
        ServiceTraffic.Builder builder = new ServiceTraffic.Builder();
        ServiceTraffic serviceTraffic = builder.storage2Entity((Convert2Entity)new BanyanDBConverter.StorageToMeasure(schema, dataPoint));
        String serviceName = serviceTraffic.getName();
        Service service = new Service();
        service.setId(serviceTraffic.getServiceId());
        service.setName(serviceName);
        service.setShortName(serviceTraffic.getShortName());
        service.setGroup(serviceTraffic.getGroup());
        service.getLayers().add(serviceTraffic.getLayer().name());
        return service;
    }

    private ServiceInstance buildInstance(DataPoint dataPoint, MetadataRegistry.Schema schema) {
        InstanceTraffic instanceTraffic = new InstanceTraffic.Builder().storage2Entity((Convert2Entity)new BanyanDBConverter.StorageToMeasure(schema, dataPoint));
        ServiceInstance serviceInstance = new ServiceInstance();
        serviceInstance.setId(instanceTraffic.id().build());
        serviceInstance.setName(instanceTraffic.getName());
        serviceInstance.setInstanceUUID(serviceInstance.getId());
        JsonObject properties = instanceTraffic.getProperties();
        if (properties != null) {
            for (Map.Entry property : properties.entrySet()) {
                String key = (String)property.getKey();
                String value = ((JsonElement)property.getValue()).getAsString();
                if (key.equals("language")) {
                    serviceInstance.setLanguage(Language.value((String)value));
                    continue;
                }
                serviceInstance.getAttributes().add(new Attribute(key, value));
            }
        } else {
            serviceInstance.setLanguage(Language.UNKNOWN);
        }
        return serviceInstance;
    }

    private Endpoint buildEndpoint(DataPoint dataPoint, MetadataRegistry.Schema schema) {
        EndpointTraffic endpointTraffic = new EndpointTraffic.Builder().storage2Entity((Convert2Entity)new BanyanDBConverter.StorageToMeasure(schema, dataPoint));
        Endpoint endpoint = new Endpoint();
        endpoint.setId(endpointTraffic.id().build());
        endpoint.setName(endpointTraffic.getName());
        return endpoint;
    }

    private Process buildProcess(DataPoint dataPoint, MetadataRegistry.Schema schema) {
        String labelsJson;
        ProcessTraffic processTraffic = new ProcessTraffic.Builder().storage2Entity((Convert2Entity)new BanyanDBConverter.StorageToMeasure(schema, dataPoint));
        Process process = new Process();
        process.setId(processTraffic.id().build());
        process.setName(processTraffic.getName());
        String serviceId = processTraffic.getServiceId();
        process.setServiceId(serviceId);
        process.setServiceName(IDManager.ServiceID.analysisId((String)serviceId).getName());
        String instanceId = processTraffic.getInstanceId();
        process.setInstanceId(instanceId);
        process.setInstanceName(IDManager.ServiceInstanceID.analysisId((String)instanceId).getName());
        process.setAgentId(processTraffic.getAgentId());
        process.setDetectType(ProcessDetectType.valueOf((int)processTraffic.getDetectType()).name());
        process.setProfilingSupportStatus(ProfilingSupportStatus.valueOf((int)processTraffic.getProfilingSupportStatus()).name());
        JsonObject properties = processTraffic.getProperties();
        if (properties != null) {
            for (Map.Entry property : properties.entrySet()) {
                String key = (String)property.getKey();
                String value = ((JsonElement)property.getValue()).getAsString();
                process.getAttributes().add(new Attribute(key, value));
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)(labelsJson = processTraffic.getLabelsJson()))) {
            List labels = (List)GSON.fromJson(labelsJson, ArrayList.class);
            process.getLabels().addAll(labels);
        }
        return process;
    }
}

