/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.banyandb;

import org.apache.skywalking.banyandb.v1.client.metadata.Group;
import org.apache.skywalking.banyandb.v1.client.metadata.IntervalRule;
import org.apache.skywalking.oap.server.core.storage.IBatchDAO;
import org.apache.skywalking.oap.server.core.storage.IHistoryDeleteDAO;
import org.apache.skywalking.oap.server.core.storage.StorageBuilderFactory;
import org.apache.skywalking.oap.server.core.storage.StorageDAO;
import org.apache.skywalking.oap.server.core.storage.StorageModule;
import org.apache.skywalking.oap.server.core.storage.cache.INetworkAddressAliasDAO;
import org.apache.skywalking.oap.server.core.storage.management.UIMenuManagementDAO;
import org.apache.skywalking.oap.server.core.storage.management.UITemplateManagementDAO;
import org.apache.skywalking.oap.server.core.storage.model.ModelCreator;
import org.apache.skywalking.oap.server.core.storage.model.ModelInstaller;
import org.apache.skywalking.oap.server.core.storage.profiling.continuous.IContinuousProfilingPolicyDAO;
import org.apache.skywalking.oap.server.core.storage.profiling.ebpf.IEBPFProfilingDataDAO;
import org.apache.skywalking.oap.server.core.storage.profiling.ebpf.IEBPFProfilingScheduleDAO;
import org.apache.skywalking.oap.server.core.storage.profiling.ebpf.IEBPFProfilingTaskDAO;
import org.apache.skywalking.oap.server.core.storage.profiling.ebpf.IServiceLabelDAO;
import org.apache.skywalking.oap.server.core.storage.profiling.trace.IProfileTaskLogQueryDAO;
import org.apache.skywalking.oap.server.core.storage.profiling.trace.IProfileTaskQueryDAO;
import org.apache.skywalking.oap.server.core.storage.profiling.trace.IProfileThreadSnapshotQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.IAggregationQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.IAlarmQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.IBrowserLogQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.IEventQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.ILogQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.IMetadataQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.IMetricsQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.IRecordsQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.ISpanAttachedEventQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.ITagAutoCompleteQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.ITopologyQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.ITraceQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.IZipkinQueryDAO;
import org.apache.skywalking.oap.server.library.module.ModuleDefine;
import org.apache.skywalking.oap.server.library.module.ModuleProvider;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.library.module.Service;
import org.apache.skywalking.oap.server.library.module.ServiceNotProvidedException;
import org.apache.skywalking.oap.server.library.util.HealthChecker;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBAggregationQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBBatchDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBIndexInstaller;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBRecordsQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBStorageClient;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBStorageConfig;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBUIMenuManagementDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBUITemplateManagementDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBZipkinQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.measure.BanyanDBEBPFProfilingScheduleQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.measure.BanyanDBEventQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.measure.BanyanDBMetadataQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.measure.BanyanDBMetricsQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.measure.BanyanDBNetworkAddressAliasDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.measure.BanyanDBServiceLabelDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.measure.BanyanDBTagAutocompleteQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.measure.BanyanDBTopologyQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.BanyanDBAlarmQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.BanyanDBBrowserLogQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.BanyanDBContinuousProfilingPolicyDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.BanyanDBEBPFProfilingDataDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.BanyanDBEBPFProfilingTaskDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.BanyanDBHistoryDeleteDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.BanyanDBLogQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.BanyanDBProfileTaskLogQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.BanyanDBProfileTaskQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.BanyanDBProfileThreadSnapshotQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.BanyanDBSpanAttachedEventQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.BanyanDBStorageDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.BanyanDBTraceQueryDAO;
import org.apache.skywalking.oap.server.telemetry.api.HealthCheckMetrics;
import org.apache.skywalking.oap.server.telemetry.api.MetricsCreator;
import org.apache.skywalking.oap.server.telemetry.api.MetricsTag;

public class BanyanDBStorageProvider
extends ModuleProvider {
    private BanyanDBStorageConfig config;
    private BanyanDBStorageClient client;
    private ModelInstaller modelInstaller;
    private IntervalRule bypass = IntervalRule.create((IntervalRule.Unit)IntervalRule.Unit.UNSPECIFIED, (int)0);

    public String name() {
        return "banyandb";
    }

    public Class<? extends ModuleDefine> module() {
        return StorageModule.class;
    }

    public ModuleProvider.ConfigCreator newConfigCreator() {
        return new ModuleProvider.ConfigCreator<BanyanDBStorageConfig>(){

            public Class type() {
                return BanyanDBStorageConfig.class;
            }

            public void onInitialized(BanyanDBStorageConfig initialized) {
                BanyanDBStorageProvider.this.config = initialized;
            }
        };
    }

    public void prepare() throws ServiceNotProvidedException, ModuleStartException {
        this.registerServiceImplementation(StorageBuilderFactory.class, (Service)new StorageBuilderFactory.Default());
        this.client = new BanyanDBStorageClient(this.config.getHost(), this.config.getPort());
        this.modelInstaller = new BanyanDBIndexInstaller(this.client, this.getManager(), this.config);
        this.registerServiceImplementation(IBatchDAO.class, (Service)new BanyanDBBatchDAO(this.client, this.config.getMaxBulkSize(), this.config.getFlushInterval(), this.config.getConcurrentWriteThreads()));
        this.registerServiceImplementation(StorageDAO.class, (Service)new BanyanDBStorageDAO(this.client));
        this.registerServiceImplementation(INetworkAddressAliasDAO.class, (Service)new BanyanDBNetworkAddressAliasDAO(this.client));
        this.registerServiceImplementation(ITraceQueryDAO.class, (Service)new BanyanDBTraceQueryDAO(this.client));
        this.registerServiceImplementation(IBrowserLogQueryDAO.class, (Service)new BanyanDBBrowserLogQueryDAO(this.client));
        this.registerServiceImplementation(IMetadataQueryDAO.class, (Service)new BanyanDBMetadataQueryDAO(this.client));
        this.registerServiceImplementation(IAlarmQueryDAO.class, (Service)new BanyanDBAlarmQueryDAO(this.client));
        this.registerServiceImplementation(ILogQueryDAO.class, (Service)new BanyanDBLogQueryDAO(this.client));
        this.registerServiceImplementation(IProfileTaskQueryDAO.class, (Service)new BanyanDBProfileTaskQueryDAO(this.client, this.config.getProfileTaskQueryMaxSize()));
        this.registerServiceImplementation(IProfileTaskLogQueryDAO.class, (Service)new BanyanDBProfileTaskLogQueryDAO(this.client, this.config.getProfileTaskQueryMaxSize()));
        this.registerServiceImplementation(IProfileThreadSnapshotQueryDAO.class, (Service)new BanyanDBProfileThreadSnapshotQueryDAO(this.client, this.config.getProfileTaskQueryMaxSize()));
        this.registerServiceImplementation(UITemplateManagementDAO.class, (Service)new BanyanDBUITemplateManagementDAO(this.client));
        this.registerServiceImplementation(UIMenuManagementDAO.class, (Service)new BanyanDBUIMenuManagementDAO(this.client));
        this.registerServiceImplementation(IEventQueryDAO.class, (Service)new BanyanDBEventQueryDAO(this.client));
        this.registerServiceImplementation(ITopologyQueryDAO.class, (Service)new BanyanDBTopologyQueryDAO(this.client));
        this.registerServiceImplementation(IEBPFProfilingTaskDAO.class, (Service)new BanyanDBEBPFProfilingTaskDAO(this.client));
        this.registerServiceImplementation(IEBPFProfilingDataDAO.class, (Service)new BanyanDBEBPFProfilingDataDAO(this.client));
        this.registerServiceImplementation(IEBPFProfilingScheduleDAO.class, (Service)new BanyanDBEBPFProfilingScheduleQueryDAO(this.client));
        this.registerServiceImplementation(IContinuousProfilingPolicyDAO.class, (Service)new BanyanDBContinuousProfilingPolicyDAO(this.client));
        this.registerServiceImplementation(IServiceLabelDAO.class, (Service)new BanyanDBServiceLabelDAO(this.client));
        this.registerServiceImplementation(ITagAutoCompleteQueryDAO.class, (Service)new BanyanDBTagAutocompleteQueryDAO(this.client));
        this.registerServiceImplementation(IHistoryDeleteDAO.class, (Service)new BanyanDBHistoryDeleteDAO());
        this.registerServiceImplementation(IMetricsQueryDAO.class, (Service)new BanyanDBMetricsQueryDAO(this.client));
        this.registerServiceImplementation(IAggregationQueryDAO.class, (Service)new BanyanDBAggregationQueryDAO(this.client));
        this.registerServiceImplementation(IRecordsQueryDAO.class, (Service)new BanyanDBRecordsQueryDAO(this.client));
        this.registerServiceImplementation(IZipkinQueryDAO.class, (Service)new BanyanDBZipkinQueryDAO(this.client));
        this.registerServiceImplementation(ISpanAttachedEventQueryDAO.class, (Service)new BanyanDBSpanAttachedEventQueryDAO(this.client));
    }

    public void start() throws ServiceNotProvidedException, ModuleStartException {
        MetricsCreator metricCreator = (MetricsCreator)this.getManager().find("telemetry").provider().getService(MetricsCreator.class);
        HealthCheckMetrics healthChecker = metricCreator.createHealthCheckerGauge("storage_banyandb", MetricsTag.EMPTY_KEY, MetricsTag.EMPTY_VALUE);
        this.client.registerChecker((HealthChecker)healthChecker);
        try {
            this.client.connect();
            this.client.defineIfEmpty(Group.create((String)"sw"));
            this.modelInstaller.start();
            ((ModelCreator)this.getManager().find("core").provider().getService(ModelCreator.class)).addModelListener((ModelCreator.CreatingListener)this.modelInstaller);
        }
        catch (Exception e) {
            throw new ModuleStartException(e.getMessage(), (Throwable)e);
        }
    }

    public void notifyAfterCompleted() throws ServiceNotProvidedException, ModuleStartException {
    }

    public String[] requiredModules() {
        return new String[]{"core"};
    }
}

