/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.banyandb;

import java.io.IOException;
import lombok.Generated;
import org.apache.skywalking.banyandb.v1.client.BanyanDBClient;
import org.apache.skywalking.banyandb.v1.client.grpc.exception.BanyanDBException;
import org.apache.skywalking.banyandb.v1.client.metadata.Measure;
import org.apache.skywalking.banyandb.v1.client.metadata.Stream;
import org.apache.skywalking.oap.server.core.config.ConfigService;
import org.apache.skywalking.oap.server.core.storage.StorageException;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.core.storage.model.ModelInstaller;
import org.apache.skywalking.oap.server.library.client.Client;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBStorageClient;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBStorageConfig;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.MetadataRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BanyanDBIndexInstaller
extends ModelInstaller {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BanyanDBIndexInstaller.class);
    private final BanyanDBStorageConfig config;

    public BanyanDBIndexInstaller(Client client, ModuleManager moduleManager, BanyanDBStorageConfig config) {
        super(client, moduleManager);
        this.config = config;
        MetadataRegistry.INSTANCE.initializeIntervals(config.getSpecificGroupSettings());
    }

    public boolean isExists(Model model) throws StorageException {
        if (!model.isTimeSeries()) {
            return true;
        }
        ConfigService configService = (ConfigService)this.moduleManager.find("core").provider().getService(ConfigService.class);
        MetadataRegistry.SchemaMetadata metadata = MetadataRegistry.INSTANCE.parseMetadata(model, this.config, configService);
        try {
            BanyanDBClient c = ((BanyanDBStorageClient)this.client).client;
            boolean resourceExist = metadata.checkResourceExistence(c);
            if (!resourceExist) {
                return false;
            }
            if (metadata.findRemoteSchema(c).isPresent()) {
                if (model.isRecord()) {
                    MetadataRegistry.INSTANCE.registerStreamModel(model, this.config, configService);
                } else {
                    MetadataRegistry.INSTANCE.registerMeasureModel(model, this.config, configService);
                }
                return true;
            }
            throw new IllegalStateException("inconsistent state:" + metadata);
        }
        catch (BanyanDBException ex) {
            throw new StorageException("fail to check existence", (Throwable)ex);
        }
    }

    public void createTable(Model model) throws StorageException {
        try {
            ConfigService configService = (ConfigService)this.moduleManager.find("core").provider().getService(ConfigService.class);
            if (model.isRecord()) {
                Stream stream = MetadataRegistry.INSTANCE.registerStreamModel(model, this.config, configService);
                if (stream != null) {
                    log.info("install stream schema {}", (Object)model.getName());
                    ((BanyanDBStorageClient)this.client).define(stream);
                }
            } else {
                Measure measure = MetadataRegistry.INSTANCE.registerMeasureModel(model, this.config, configService);
                if (measure != null) {
                    log.info("install measure schema {}", (Object)measure.name());
                    ((BanyanDBStorageClient)this.client).define(measure);
                    BanyanDBClient c = ((BanyanDBStorageClient)this.client).client;
                    MetadataRegistry.INSTANCE.findMetadata(model).installTopNAggregation(c);
                }
            }
        }
        catch (IOException ex) {
            throw new StorageException("fail to install schema", (Throwable)ex);
        }
        catch (BanyanDBException ex) {
            throw new StorageException("fail to install TopN schema", (Throwable)ex);
        }
    }
}

