/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.banyandb;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.skywalking.banyandb.v1.client.DataPoint;
import org.apache.skywalking.banyandb.v1.client.MeasureQuery;
import org.apache.skywalking.banyandb.v1.client.MeasureQueryResponse;
import org.apache.skywalking.banyandb.v1.client.TagAndValue;
import org.apache.skywalking.banyandb.v1.client.TimestampRange;
import org.apache.skywalking.banyandb.v1.client.TopNQueryResponse;
import org.apache.skywalking.oap.server.core.query.enumeration.Order;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.input.TopNCondition;
import org.apache.skywalking.oap.server.core.query.type.KeyValue;
import org.apache.skywalking.oap.server.core.query.type.SelectedRecord;
import org.apache.skywalking.oap.server.core.storage.query.IAggregationQueryDAO;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBStorageClient;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.MetadataRegistry;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.AbstractBanyanDBDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.util.ByteUtil;

public class BanyanDBAggregationQueryDAO
extends AbstractBanyanDBDAO
implements IAggregationQueryDAO {
    private static final Set<String> TAGS = ImmutableSet.of((Object)"entity_id");

    public BanyanDBAggregationQueryDAO(BanyanDBStorageClient client) {
        super(client);
    }

    public List<SelectedRecord> sortMetrics(TopNCondition condition, String valueColumnName, Duration duration, List<KeyValue> additionalConditions) throws IOException {
        String modelName = condition.getName();
        TimestampRange timestampRange = new TimestampRange(duration.getStartTimestamp(), duration.getEndTimestamp());
        MetadataRegistry.Schema schema = MetadataRegistry.INSTANCE.findMetadata(modelName, duration.getStep());
        if (schema == null) {
            throw new IOException("schema is not registered");
        }
        MetadataRegistry.ColumnSpec spec = schema.getSpec(valueColumnName);
        if (spec == null) {
            throw new IOException("field spec is not registered");
        }
        if (schema.getTopNSpec() != null && (CollectionUtils.isEmpty(additionalConditions) || additionalConditions.stream().map(KeyValue::getKey).collect(Collectors.toSet()).equals(ImmutableSet.copyOf(schema.getTopNSpec().getGroupByTagNames())))) {
            return this.serverSideTopN(condition, schema, spec, timestampRange, additionalConditions);
        }
        return this.directMetricsTopN(condition, valueColumnName, spec, timestampRange, additionalConditions);
    }

    List<SelectedRecord> serverSideTopN(TopNCondition condition, MetadataRegistry.Schema schema, MetadataRegistry.ColumnSpec valueColumnSpec, TimestampRange timestampRange, List<KeyValue> additionalConditions) throws IOException {
        TopNQueryResponse resp = null;
        resp = condition.getOrder() == Order.DES ? this.topN(schema, timestampRange, condition.getTopN(), additionalConditions) : this.bottomN(schema, timestampRange, condition.getTopN(), additionalConditions);
        if (resp.size() == 0) {
            return Collections.emptyList();
        }
        if (resp.size() > 1) {
            throw new IOException("invalid TopN response");
        }
        ArrayList<SelectedRecord> topNList = new ArrayList<SelectedRecord>();
        for (TopNQueryResponse.Item item : ((TopNQueryResponse.TopNList)resp.getTopNLists().get(0)).getItems()) {
            SelectedRecord record = new SelectedRecord();
            record.setId((String)((TagAndValue)item.getTagValuesMap().get("entity_id")).getValue());
            record.setValue(BanyanDBAggregationQueryDAO.extractFieldValueAsString(valueColumnSpec, item.getValue()));
            topNList.add(record);
        }
        return topNList;
    }

    List<SelectedRecord> directMetricsTopN(final TopNCondition condition, final String valueColumnName, MetadataRegistry.ColumnSpec valueColumnSpec, TimestampRange timestampRange, final List<KeyValue> additionalConditions) throws IOException {
        MeasureQueryResponse resp = this.query(condition.getName(), TAGS, Collections.singleton(valueColumnName), timestampRange, new AbstractBanyanDBDAO.QueryBuilder<MeasureQuery>(){

            @Override
            protected void apply(MeasureQuery query) {
                query.meanBy(valueColumnName, (Set)ImmutableSet.of((Object)"entity_id"));
                if (condition.getOrder() == Order.DES) {
                    query.topN(condition.getTopN(), valueColumnName);
                } else {
                    query.bottomN(condition.getTopN(), valueColumnName);
                }
                if (CollectionUtils.isNotEmpty((List)additionalConditions)) {
                    additionalConditions.forEach(additionalCondition -> query.and(this.eq(additionalCondition.getKey(), additionalCondition.getValue())));
                }
            }
        });
        if (resp.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<SelectedRecord> topNList = new ArrayList<SelectedRecord>();
        for (DataPoint dataPoint : resp.getDataPoints()) {
            SelectedRecord record = new SelectedRecord();
            record.setId((String)dataPoint.getTagValue("entity_id"));
            record.setValue(BanyanDBAggregationQueryDAO.extractFieldValueAsString(valueColumnSpec, dataPoint.getFieldValue(valueColumnName)));
            topNList.add(record);
        }
        return topNList;
    }

    private static String extractFieldValueAsString(MetadataRegistry.ColumnSpec spec, Object fieldValue) {
        if (Double.TYPE.equals(spec.getColumnClass())) {
            return String.valueOf(ByteUtil.bytes2Double((byte[])fieldValue).longValue());
        }
        if (String.class.equals(spec.getColumnClass())) {
            return (String)fieldValue;
        }
        return String.valueOf(((Number)fieldValue).longValue());
    }
}

