/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.encoding;

import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.encoding.StreamDecoderFactory;
import com.linecorp.armeria.internal.shaded.guava.base.Ascii;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.armeria.internal.shaded.guava.collect.Streams;
import com.linecorp.armeria.internal.shaded.guava.primitives.Ints;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.Service;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.SimpleDecoratingHttpService;
import com.linecorp.armeria.server.encoding.HttpDecodedRequest;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public final class DecodingService
extends SimpleDecoratingHttpService {
    private final Map<String, StreamDecoderFactory> decoderFactories;

    public static Function<? super HttpService, DecodingService> newDecorator() {
        return DecodingService.newDecorator(ImmutableList.of(StreamDecoderFactory.gzip(), StreamDecoderFactory.deflate(), StreamDecoderFactory.brotli()));
    }

    public static Function<? super HttpService, DecodingService> newDecorator(StreamDecoderFactory ... decoderFactories) {
        Objects.requireNonNull(decoderFactories, "decoderFactories");
        return DecodingService.newDecorator(ImmutableList.copyOf(decoderFactories));
    }

    public static Function<? super HttpService, DecodingService> newDecorator(Iterable<? extends StreamDecoderFactory> decoderFactories) {
        Objects.requireNonNull(decoderFactories, "decoderFactories");
        ImmutableList<? extends StreamDecoderFactory> immutableDecoderFactories = ImmutableList.copyOf(decoderFactories);
        return delegate -> new DecodingService((HttpService)delegate, (Iterable<? extends StreamDecoderFactory>)immutableDecoderFactories);
    }

    private DecodingService(HttpService delegate, Iterable<? extends StreamDecoderFactory> decoderFactories) {
        super(delegate);
        this.decoderFactories = Streams.stream(decoderFactories).collect(ImmutableMap.toImmutableMap(StreamDecoderFactory::encodingHeaderValue, Function.identity()));
    }

    @Override
    public HttpResponse serve(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        RequestHeaders headers = req.headers();
        String contentEncoding = headers.get((CharSequence)HttpHeaderNames.CONTENT_ENCODING);
        if (contentEncoding == null) {
            return (HttpResponse)((Service)this.unwrap()).serve(ctx, req);
        }
        StreamDecoderFactory decoderFactory = this.decoderFactories.get(Ascii.toLowerCase(contentEncoding));
        if (decoderFactory == null) {
            return (HttpResponse)((Service)this.unwrap()).serve(ctx, req);
        }
        RequestHeaders newHeaders = headers.toBuilder().removeAndThen((CharSequence)HttpHeaderNames.CONTENT_ENCODING).removeAndThen((CharSequence)HttpHeaderNames.CONTENT_LENGTH).build();
        HttpRequest newReq = req.withHeaders(newHeaders);
        HttpDecodedRequest decodedRequest = new HttpDecodedRequest(newReq, decoderFactory, ctx.alloc(), Ints.saturatedCast(ctx.maxRequestLength()));
        ctx.updateRequest(decodedRequest);
        return (HttpResponse)((Service)this.unwrap()).serve(ctx, decodedRequest);
    }
}

