/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.annotation;

import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.server.annotation.HttpResult;
import java.util.Objects;

final class DefaultHttpResult<T>
implements HttpResult<T> {
    private final HttpHeaders headers;
    @Nullable
    private final T content;
    private final HttpHeaders trailers;

    DefaultHttpResult(HttpHeaders headers) {
        this(headers, null, HttpHeaders.of());
    }

    DefaultHttpResult(HttpHeaders headers, T content) {
        this(headers, Objects.requireNonNull(content, "content"), HttpHeaders.of());
    }

    DefaultHttpResult(HttpHeaders headers, @Nullable T content, HttpHeaders trailers) {
        this.headers = Objects.requireNonNull(headers, "headers");
        this.content = content;
        this.trailers = Objects.requireNonNull(trailers, "trailers");
    }

    @Override
    public HttpHeaders headers() {
        return this.headers;
    }

    @Override
    public T content() {
        return this.content;
    }

    @Override
    public HttpHeaders trailers() {
        return this.trailers;
    }
}

