/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.ClosedSessionException;
import com.linecorp.armeria.common.ContentTooLargeException;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.internal.common.InitiateConnectionShutdown;
import com.linecorp.armeria.server.DecodedHttpRequest;
import com.linecorp.armeria.server.HttpStatusException;
import com.linecorp.armeria.server.ServerHttpObjectEncoder;
import com.linecorp.armeria.server.ServiceConfig;
import com.linecorp.armeria.server.StreamingDecodedHttpRequest;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.util.ReferenceCountUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class WebSocketSessionChannelHandler
extends ChannelDuplexHandler {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketSessionChannelHandler.class);
    private final StreamingDecodedHttpRequest req;
    private final ServerHttpObjectEncoder encoder;
    private final ServiceConfig serviceConfig;

    WebSocketSessionChannelHandler(StreamingDecodedHttpRequest req, ServerHttpObjectEncoder encoder, ServiceConfig serviceConfig) {
        this.req = req;
        this.encoder = encoder;
        this.serviceConfig = serviceConfig;
    }

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        super.channelUnregistered(ctx);
        this.req.close(ClosedSessionException.get());
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof InitiateConnectionShutdown) {
            this.encoder.keepAliveHandler().disconnectWhenFinished();
            return;
        }
        ctx.fireUserEventTriggered(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof DecodedHttpRequest) {
            ctx.fireChannelRead(msg);
            return;
        }
        if (msg == LastHttpContent.EMPTY_LAST_CONTENT) {
            return;
        }
        if (!(msg instanceof ByteBuf)) {
            logger.warn("{} Unexpected msg: {}", (Object)ctx.channel(), msg);
            return;
        }
        try {
            ByteBuf data = (ByteBuf)msg;
            int dataLength = data.readableBytes();
            if (dataLength != 0) {
                this.req.increaseTransferredBytes(dataLength);
                long maxContentLength = this.req.maxRequestLength();
                long transferredLength = this.req.transferredBytes();
                if (maxContentLength > 0L && transferredLength > maxContentLength) {
                    ContentTooLargeException cause = ContentTooLargeException.builder().maxContentLength(maxContentLength).contentLength(this.req.headers()).transferred(transferredLength).build();
                    if (this.encoder.isResponseHeadersSent(this.req.id(), 1)) {
                        this.encoder.writeReset(this.req.id(), 1, Http2Error.PROTOCOL_ERROR);
                    } else {
                        this.encoder.writeErrorResponse(this.req.id(), 1, this.serviceConfig, this.req.headers(), HttpStatus.REQUEST_ENTITY_TOO_LARGE, null, null);
                    }
                    this.req.abortResponse(HttpStatusException.of(HttpStatus.REQUEST_ENTITY_TOO_LARGE, (Throwable)cause), true);
                    return;
                }
                if (this.req.isOpen()) {
                    this.req.write(HttpData.wrap(data.retain()));
                }
            }
        }
        finally {
            ReferenceCountUtil.release((Object)msg);
        }
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof HttpResponse) {
            HttpResponse response = (HttpResponse)msg;
            HttpResponseStatus status = response.status();
            ctx.write(msg, promise);
            if (status == HttpResponseStatus.SWITCHING_PROTOCOLS) {
                ctx.pipeline().remove(HttpServerCodec.class);
            }
            return;
        }
        if (msg instanceof HttpContent) {
            ctx.write((Object)((HttpContent)msg).content(), promise);
            return;
        }
        ctx.write(msg, promise);
    }
}

