/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.internal.common.HttpHeadersUtil;
import com.linecorp.armeria.internal.server.DefaultServiceRequestContext;
import com.linecorp.armeria.server.AbstractHttpResponseSubscriber;
import com.linecorp.armeria.server.DecodedHttpRequest;
import com.linecorp.armeria.server.ServerConfig;
import com.linecorp.armeria.server.ServerHttpObjectEncoder;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.CompletableFuture;

final class WebSocketHttp1ResponseSubscriber
extends AbstractHttpResponseSubscriber {
    WebSocketHttp1ResponseSubscriber(ChannelHandlerContext ctx, ServerHttpObjectEncoder responseEncoder, DefaultServiceRequestContext reqCtx, DecodedHttpRequest req, CompletableFuture<Void> completionFuture) {
        super(ctx, responseEncoder, reqCtx, req, completionFuture);
        responseEncoder.keepAliveHandler().disconnectWhenFinished();
    }

    @Override
    void onResponseHeaders(ResponseHeaders headers) {
        boolean endOfStream = headers.isEndOfStream();
        ServerConfig config = this.reqCtx.config().server().config();
        ResponseHeaders merged = HttpHeadersUtil.mergeResponseHeaders(headers, this.reqCtx.additionalResponseHeaders(), this.reqCtx.config().defaultHeaders(), config.isServerHeaderEnabled(), config.isDateHeaderEnabled());
        this.logBuilder().responseHeaders(merged);
        this.setState(AbstractHttpResponseSubscriber.State.NEEDS_DATA);
        this.responseEncoder.writeHeaders(this.req.id(), this.req.streamId(), merged, endOfStream).addListener((GenericFutureListener)this.writeHeadersFutureListener(endOfStream));
    }
}

