/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpHeadersBuilder;
import com.linecorp.armeria.common.RequestId;
import com.linecorp.armeria.common.SuccessFunction;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.BlockingTaskExecutor;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.server.DecoratingHttpServiceFunction;
import com.linecorp.armeria.server.ExceptionReportingServiceErrorHandler;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.Route;
import com.linecorp.armeria.server.RoutingContext;
import com.linecorp.armeria.server.ServiceConfig;
import com.linecorp.armeria.server.ServiceConfigSetters;
import com.linecorp.armeria.server.ServiceErrorHandler;
import com.linecorp.armeria.server.ServiceNaming;
import com.linecorp.armeria.server.ShutdownSupport;
import com.linecorp.armeria.server.UnhandledExceptionsReporter;
import com.linecorp.armeria.server.VirtualHostBuilder;
import com.linecorp.armeria.server.logging.AccessLogWriter;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;

final class ServiceConfigBuilder
implements ServiceConfigSetters {
    private final Route route;
    private final HttpService service;
    @Nullable
    private Route mappedRoute;
    @Nullable
    private String defaultServiceName;
    @Nullable
    private ServiceNaming defaultServiceNaming;
    @Nullable
    private String defaultLogName;
    @Nullable
    private Long requestTimeoutMillis;
    @Nullable
    private Long maxRequestLength;
    @Nullable
    private Boolean verboseResponses;
    @Nullable
    private AccessLogWriter accessLogWriter;
    @Nullable
    private BlockingTaskExecutor blockingTaskExecutor;
    @Nullable
    private SuccessFunction successFunction;
    @Nullable
    private Long requestAutoAbortDelayMillis;
    @Nullable
    private Path multipartUploadsLocation;
    @Nullable
    private ServiceErrorHandler serviceErrorHandler;
    private final List<ShutdownSupport> shutdownSupports = new ArrayList<ShutdownSupport>();
    private final HttpHeadersBuilder defaultHeaders = HttpHeaders.builder();
    @Nullable
    private Function<? super RoutingContext, ? extends RequestId> requestIdGenerator;

    ServiceConfigBuilder(Route route, HttpService service) {
        this.route = Objects.requireNonNull(route, "route");
        this.service = Objects.requireNonNull(service, "service");
    }

    void addMappedRoute(Route mappedRoute) {
        this.mappedRoute = Objects.requireNonNull(mappedRoute, "mappedRoute");
    }

    @Override
    public ServiceConfigBuilder requestTimeout(Duration requestTimeout) {
        return this.requestTimeoutMillis(requestTimeout.toMillis());
    }

    @Override
    public ServiceConfigBuilder requestTimeoutMillis(long requestTimeoutMillis) {
        this.requestTimeoutMillis = requestTimeoutMillis;
        return this;
    }

    @Override
    public ServiceConfigBuilder maxRequestLength(long maxRequestLength) {
        this.maxRequestLength = maxRequestLength;
        return this;
    }

    @Override
    public ServiceConfigBuilder verboseResponses(boolean verboseResponses) {
        this.verboseResponses = verboseResponses;
        return this;
    }

    @Override
    public ServiceConfigBuilder accessLogWriter(AccessLogWriter accessLogWriter, boolean shutdownOnStop) {
        this.accessLogWriter = this.accessLogWriter != null ? this.accessLogWriter.andThen(accessLogWriter) : accessLogWriter;
        if (shutdownOnStop) {
            this.shutdownSupports.add(ShutdownSupport.of(accessLogWriter));
        }
        return this;
    }

    @Override
    public ServiceConfigBuilder accessLogFormat(String accessLogFormat) {
        return this.accessLogWriter(AccessLogWriter.custom(Objects.requireNonNull(accessLogFormat, "accessLogFormat")), false);
    }

    @Override
    public ServiceConfigBuilder decorator(DecoratingHttpServiceFunction decoratingHttpServiceFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ServiceConfigBuilder decorator(Function<? super HttpService, ? extends HttpService> decorator) {
        throw new UnsupportedOperationException();
    }

    @Override
    @SafeVarargs
    public final ServiceConfigBuilder decorators(Function<? super HttpService, ? extends HttpService> ... decorators) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ServiceConfigBuilder decorators(Iterable<? extends Function<? super HttpService, ? extends HttpService>> decorators) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ServiceConfigBuilder defaultLogName(String defaultLogName) {
        this.defaultLogName = Objects.requireNonNull(defaultLogName, "defaultLogName");
        return this;
    }

    @Override
    public ServiceConfigBuilder blockingTaskExecutor(ScheduledExecutorService blockingTaskExecutor, boolean shutdownOnStop) {
        Objects.requireNonNull(blockingTaskExecutor, "blockingTaskExecutor");
        return this.blockingTaskExecutor(BlockingTaskExecutor.of(blockingTaskExecutor), shutdownOnStop);
    }

    @Override
    public ServiceConfigBuilder blockingTaskExecutor(BlockingTaskExecutor blockingTaskExecutor, boolean shutdownOnStop) {
        this.blockingTaskExecutor = Objects.requireNonNull(blockingTaskExecutor, "blockingTaskExecutor");
        if (shutdownOnStop) {
            this.shutdownSupports.add(ShutdownSupport.of(blockingTaskExecutor));
        }
        return this;
    }

    @Override
    public ServiceConfigBuilder blockingTaskExecutor(int numThreads) {
        Preconditions.checkArgument(numThreads >= 0, "numThreads: %s (expected: >= 0)", numThreads);
        BlockingTaskExecutor executor = BlockingTaskExecutor.builder().numThreads(numThreads).build();
        return this.blockingTaskExecutor(executor, true);
    }

    @Override
    public ServiceConfigBuilder successFunction(SuccessFunction successFunction) {
        this.successFunction = Objects.requireNonNull(successFunction, "successFunction");
        return this;
    }

    @Override
    public ServiceConfigBuilder requestAutoAbortDelay(Duration delay) {
        return this.requestAutoAbortDelayMillis(Objects.requireNonNull(delay, "delay").toMillis());
    }

    @Override
    public ServiceConfigBuilder requestAutoAbortDelayMillis(long delayMillis) {
        this.requestAutoAbortDelayMillis = delayMillis;
        return this;
    }

    @Override
    public ServiceConfigBuilder multipartUploadsLocation(Path multipartUploadsLocation) {
        this.multipartUploadsLocation = multipartUploadsLocation;
        return this;
    }

    @Override
    public ServiceConfigBuilder requestIdGenerator(Function<? super RoutingContext, ? extends RequestId> requestIdGenerator) {
        this.requestIdGenerator = Objects.requireNonNull(requestIdGenerator, "requestIdGenerator");
        return this;
    }

    @Override
    public ServiceConfigBuilder addHeader(CharSequence name, Object value) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(value, "value");
        VirtualHostBuilder.ensureNoPseudoHeader(name);
        this.defaultHeaders.addObject(name, value);
        return this;
    }

    @Override
    public ServiceConfigBuilder addHeaders(Iterable<? extends Map.Entry<? extends CharSequence, ?>> defaultHeaders) {
        Objects.requireNonNull(defaultHeaders, "defaultHeaders");
        VirtualHostBuilder.ensureNoPseudoHeader(defaultHeaders);
        this.defaultHeaders.addObject(defaultHeaders);
        return this;
    }

    @Override
    public ServiceConfigBuilder setHeader(CharSequence name, Object value) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(value, "value");
        VirtualHostBuilder.ensureNoPseudoHeader(name);
        this.defaultHeaders.setObject(name, value);
        return this;
    }

    @Override
    public ServiceConfigBuilder setHeaders(Iterable<? extends Map.Entry<? extends CharSequence, ?>> defaultHeaders) {
        Objects.requireNonNull(defaultHeaders, "defaultHeaders");
        VirtualHostBuilder.ensureNoPseudoHeader(defaultHeaders);
        this.defaultHeaders.setObject(defaultHeaders);
        return this;
    }

    @Override
    public ServiceConfigBuilder errorHandler(ServiceErrorHandler serviceErrorHandler) {
        Objects.requireNonNull(serviceErrorHandler, "serviceErrorHandler");
        this.serviceErrorHandler = serviceErrorHandler;
        return this;
    }

    @Override
    public ServiceConfigBuilder defaultServiceName(String defaultServiceName) {
        Objects.requireNonNull(defaultServiceName, "defaultServiceName");
        this.defaultServiceName = defaultServiceName;
        this.defaultServiceNaming = ServiceNaming.of(defaultServiceName);
        return this;
    }

    @Override
    public ServiceConfigBuilder defaultServiceNaming(ServiceNaming defaultServiceNaming) {
        this.defaultServiceName = null;
        this.defaultServiceNaming = Objects.requireNonNull(defaultServiceNaming, "defaultServiceNaming");
        return this;
    }

    void shutdownSupports(List<ShutdownSupport> shutdownSupports) {
        Objects.requireNonNull(shutdownSupports, "shutdownSupports");
        this.shutdownSupports.addAll(shutdownSupports);
    }

    void defaultHeaders(HttpHeaders defaultHeaders) {
        Objects.requireNonNull(defaultHeaders, "defaultHeaders");
        defaultHeaders.forEach((name, value) -> this.defaultHeaders.add((CharSequence)name, (String)value));
    }

    ServiceConfig build(ServiceNaming defaultServiceNaming, long defaultRequestTimeoutMillis, long defaultMaxRequestLength, boolean defaultVerboseResponses, AccessLogWriter defaultAccessLogWriter, BlockingTaskExecutor defaultBlockingTaskExecutor, SuccessFunction defaultSuccessFunction, long requestAutoAbortDelayMillis, Path defaultMultipartUploadsLocation, HttpHeaders virtualHostDefaultHeaders, Function<? super RoutingContext, ? extends RequestId> defaultRequestIdGenerator, ServiceErrorHandler defaultServiceErrorHandler, @Nullable UnhandledExceptionsReporter unhandledExceptionsReporter) {
        ServiceErrorHandler errorHandler;
        ServiceErrorHandler serviceErrorHandler = errorHandler = this.serviceErrorHandler != null ? this.serviceErrorHandler.orElse(defaultServiceErrorHandler) : defaultServiceErrorHandler;
        if (unhandledExceptionsReporter != null) {
            errorHandler = new ExceptionReportingServiceErrorHandler(errorHandler, unhandledExceptionsReporter);
        }
        return new ServiceConfig(this.route, this.mappedRoute == null ? this.route : this.mappedRoute, this.service, this.defaultLogName, this.defaultServiceName, this.defaultServiceNaming != null ? this.defaultServiceNaming : defaultServiceNaming, this.requestTimeoutMillis != null ? this.requestTimeoutMillis : defaultRequestTimeoutMillis, this.maxRequestLength != null ? this.maxRequestLength : defaultMaxRequestLength, this.verboseResponses != null ? this.verboseResponses : defaultVerboseResponses, this.accessLogWriter != null ? this.accessLogWriter : defaultAccessLogWriter, this.blockingTaskExecutor != null ? this.blockingTaskExecutor : defaultBlockingTaskExecutor, this.successFunction != null ? this.successFunction : defaultSuccessFunction, this.requestAutoAbortDelayMillis != null ? this.requestAutoAbortDelayMillis : requestAutoAbortDelayMillis, this.multipartUploadsLocation != null ? this.multipartUploadsLocation : defaultMultipartUploadsLocation, ImmutableList.copyOf(this.shutdownSupports), VirtualHostBuilder.mergeDefaultHeaders(virtualHostDefaultHeaders.toBuilder(), this.defaultHeaders.build()), this.requestIdGenerator != null ? this.requestIdGenerator : defaultRequestIdGenerator, errorHandler);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("route", this.route).add("service", this.service).add("defaultServiceNaming", this.defaultServiceNaming).add("requestTimeoutMillis", this.requestTimeoutMillis).add("maxRequestLength", this.maxRequestLength).add("verboseResponses", this.verboseResponses).add("accessLogWriter", this.accessLogWriter).add("blockingTaskExecutor", this.blockingTaskExecutor).add("successFunction", this.successFunction).add("multipartUploadsLocation", this.multipartUploadsLocation).add("shutdownSupports", this.shutdownSupports).add("defaultHeaders", this.defaultHeaders).add("serviceErrorHandler", this.serviceErrorHandler).toString();
    }
}

