/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.AggregatedHttpResponse;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.server.DefaultServerErrorHandler;
import com.linecorp.armeria.server.ServiceConfig;
import com.linecorp.armeria.server.ServiceErrorHandler;
import com.linecorp.armeria.server.ServiceRequestContext;
import java.util.Objects;

@FunctionalInterface
public interface ServerErrorHandler {
    public static ServerErrorHandler ofDefault() {
        return DefaultServerErrorHandler.INSTANCE;
    }

    @Nullable
    public HttpResponse onServiceException(ServiceRequestContext var1, Throwable var2);

    @Nullable
    default public AggregatedHttpResponse onProtocolViolation(ServiceConfig config, @Nullable RequestHeaders headers, HttpStatus status, @Nullable String description, @Nullable Throwable cause) {
        return this.renderStatus(config, headers, status, description, cause);
    }

    @Nullable
    default public AggregatedHttpResponse renderStatus(ServiceConfig config, @Nullable RequestHeaders headers, HttpStatus status, @Nullable String description, @Nullable Throwable cause) {
        return null;
    }

    default public ServerErrorHandler orElse(final ServerErrorHandler other) {
        Objects.requireNonNull(other, "other");
        return new ServerErrorHandler(){

            @Override
            @Nullable
            public HttpResponse onServiceException(ServiceRequestContext ctx, Throwable cause) {
                HttpResponse response = ServerErrorHandler.this.onServiceException(ctx, cause);
                if (response != null) {
                    return response;
                }
                return other.onServiceException(ctx, cause);
            }

            @Override
            @Nullable
            public AggregatedHttpResponse onProtocolViolation(ServiceConfig config, @Nullable RequestHeaders headers, HttpStatus status, @Nullable String description, @Nullable Throwable cause) {
                AggregatedHttpResponse response = ServerErrorHandler.this.onProtocolViolation(config, headers, status, description, cause);
                if (response != null) {
                    return response;
                }
                return other.onProtocolViolation(config, headers, status, description, cause);
            }

            @Override
            @Nullable
            public AggregatedHttpResponse renderStatus(ServiceConfig config, @Nullable RequestHeaders headers, HttpStatus status, @Nullable String description, @Nullable Throwable cause) {
                AggregatedHttpResponse response = ServerErrorHandler.this.renderStatus(config, headers, status, description, cause);
                if (response != null) {
                    return response;
                }
                return other.renderStatus(config, headers, status, description, cause);
            }
        };
    }

    default public ServiceErrorHandler asServiceErrorHandler() {
        return new ServiceErrorHandler(){

            @Override
            @Nullable
            public HttpResponse onServiceException(ServiceRequestContext ctx, Throwable cause) {
                return ServerErrorHandler.this.onServiceException(ctx, cause);
            }

            @Override
            @Nullable
            public AggregatedHttpResponse renderStatus(ServiceConfig config, @Nullable RequestHeaders headers, HttpStatus status, @Nullable String description, @Nullable Throwable cause) {
                return ServerErrorHandler.this.renderStatus(config, headers, status, description, cause);
            }
        };
    }
}

