/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.google.errorprone.annotations.concurrent.GuardedBy;
import com.linecorp.armeria.common.Flags;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.DomainSocketAddress;
import com.linecorp.armeria.common.util.EventLoopGroups;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.common.util.ListenableAsyncCloseable;
import com.linecorp.armeria.common.util.ShutdownHooks;
import com.linecorp.armeria.common.util.StartStopSupport;
import com.linecorp.armeria.common.util.TransportType;
import com.linecorp.armeria.common.util.Version;
import com.linecorp.armeria.internal.common.RequestTargetCache;
import com.linecorp.armeria.internal.common.util.ChannelUtil;
import com.linecorp.armeria.internal.common.util.ReentrantShortLock;
import com.linecorp.armeria.internal.shaded.futures.CompletableFutures;
import com.linecorp.armeria.internal.shaded.guava.base.Joiner;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.armeria.internal.shaded.jctools.maps.NonBlockingHashSet;
import com.linecorp.armeria.server.CertificateUtil;
import com.linecorp.armeria.server.ConnectionLimitingHandler;
import com.linecorp.armeria.server.DefaultServerConfig;
import com.linecorp.armeria.server.GracefulShutdownSupport;
import com.linecorp.armeria.server.HttpServerPipelineConfigurator;
import com.linecorp.armeria.server.ServerBuilder;
import com.linecorp.armeria.server.ServerConfig;
import com.linecorp.armeria.server.ServerConfigurator;
import com.linecorp.armeria.server.ServerListener;
import com.linecorp.armeria.server.ServerPort;
import com.linecorp.armeria.server.ServerSslContextUtil;
import com.linecorp.armeria.server.ServiceCallbackInvoker;
import com.linecorp.armeria.server.ServiceConfig;
import com.linecorp.armeria.server.ShutdownSupport;
import com.linecorp.armeria.server.UpdatableServerConfig;
import com.linecorp.armeria.server.VirtualHost;
import com.linecorp.armeria.server.websocket.WebSocketService;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.handler.ssl.SslContext;
import io.netty.util.concurrent.FastThreadLocalThread;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ImmediateEventExecutor;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import javax.net.ssl.SSLSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Server
implements ListenableAsyncCloseable {
    static final Logger logger = LoggerFactory.getLogger(Server.class);
    private final UpdatableServerConfig config;
    private final StartStopSupport<Void, Void, Void, ServerListener> startStop;
    private final Set<ServerChannel> serverChannels = new NonBlockingHashSet<ServerChannel>();
    private final ReentrantLock lock = new ReentrantShortLock();
    @GuardedBy(value="lock")
    private final Map<InetSocketAddress, ServerPort> activePorts = new LinkedHashMap<InetSocketAddress, ServerPort>();
    private final ConnectionLimitingHandler connectionLimitingHandler;
    private boolean hasWebSocketService;
    @Nullable
    ServerBootstrap serverBootstrap;

    public static ServerBuilder builder() {
        return new ServerBuilder();
    }

    Server(DefaultServerConfig serverConfig) {
        serverConfig.setServer(this);
        this.config = new UpdatableServerConfig(Objects.requireNonNull(serverConfig, "serverConfig"));
        this.startStop = new ServerStartStopSupport(this.config.startStopExecutor());
        this.connectionLimitingHandler = new ConnectionLimitingHandler(this.config.maxNumConnections());
        RequestTargetCache.registerServerMetrics(this.config.meterRegistry());
        this.setupVersionMetrics();
        for (VirtualHost virtualHost : this.config().virtualHosts()) {
            if (virtualHost.sslContext() == null) continue;
            this.setupTlsMetrics(virtualHost.sslContext(), virtualHost.hostnamePattern());
        }
        this.config.serviceConfigs().forEach(cfg -> ServiceCallbackInvoker.invokeServiceAdded(cfg, cfg.service()));
        this.hasWebSocketService = Server.hasWebSocketService(this.config);
    }

    public ServerConfig config() {
        return this.config;
    }

    public List<ServiceConfig> serviceConfigs() {
        return this.config.serviceConfigs();
    }

    public String defaultHostname() {
        return this.config().defaultVirtualHost().defaultHostname();
    }

    public Map<InetSocketAddress, ServerPort> activePorts() {
        this.lock.lock();
        try {
            Map<InetSocketAddress, ServerPort> map = Collections.unmodifiableMap(new LinkedHashMap<InetSocketAddress, ServerPort>(this.activePorts));
            return map;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Nullable
    public ServerPort activePort() {
        return this.activePort0(null);
    }

    @Nullable
    public ServerPort activePort(SessionProtocol protocol) {
        return this.activePort0(Objects.requireNonNull(protocol, "protocol"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private ServerPort activePort0(@Nullable SessionProtocol protocol) {
        ServerPort candidate = null;
        this.lock.lock();
        try {
            for (ServerPort serverPort : this.activePorts.values()) {
                if (protocol != null && !serverPort.hasProtocol(protocol)) continue;
                if (!Server.isLocalPort(serverPort)) {
                    ServerPort serverPort2 = serverPort;
                    return serverPort2;
                }
                if (candidate != null) continue;
                candidate = serverPort;
            }
        }
        finally {
            this.lock.unlock();
        }
        return candidate;
    }

    public int activeLocalPort() {
        return this.activeLocalPort0(null);
    }

    public int activeLocalPort(SessionProtocol protocol) {
        return this.activeLocalPort0(Objects.requireNonNull(protocol, "protocol"));
    }

    private int activeLocalPort0(@Nullable SessionProtocol protocol) {
        this.lock.lock();
        try {
            int n = this.activePorts.values().stream().filter(activePort -> (protocol == null || activePort.hasProtocol(protocol)) && Server.isLocalPort(activePort)).findFirst().orElseThrow(() -> new IllegalStateException((protocol == null ? "no active local ports: " : "no active local ports for " + (Object)((Object)protocol) + ": ") + this.activePorts.values())).localAddress().getPort();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public MeterRegistry meterRegistry() {
        return this.config().meterRegistry();
    }

    public void addListener(ServerListener listener) {
        this.startStop.addListener(Objects.requireNonNull(listener, "listener"));
    }

    public boolean removeListener(ServerListener listener) {
        return this.startStop.removeListener(Objects.requireNonNull(listener, "listener"));
    }

    public CompletableFuture<Void> start() {
        return this.startStop.start(true);
    }

    public CompletableFuture<Void> stop() {
        return this.startStop.stop();
    }

    public EventLoop nextEventLoop() {
        return this.config().workerGroup().next();
    }

    @Override
    public boolean isClosing() {
        return this.startStop.isClosing();
    }

    @Override
    public boolean isClosed() {
        return this.startStop.isClosed();
    }

    @Override
    public CompletableFuture<?> whenClosed() {
        return this.startStop.whenClosed();
    }

    @Override
    public CompletableFuture<?> closeAsync() {
        return this.startStop.closeAsync();
    }

    @Override
    public void close() {
        this.startStop.close();
    }

    public int numConnections() {
        return this.connectionLimitingHandler.numConnections();
    }

    public void blockUntilShutdown() throws InterruptedException {
        try {
            this.whenClosed().get();
        }
        catch (ExecutionException e) {
            throw new CompletionException(e.toString(), Exceptions.peel(e));
        }
    }

    void setupVersionMetrics() {
        MeterRegistry meterRegistry = this.config().meterRegistry();
        Version versionInfo = Version.get("armeria", Server.class.getClassLoader());
        String version = versionInfo.artifactVersion();
        String commit = versionInfo.longCommitHash();
        String repositoryStatus = versionInfo.repositoryStatus();
        ImmutableList<Tag> tags = ImmutableList.of(Tag.of((String)"version", (String)version), Tag.of((String)"commit", (String)commit), Tag.of((String)"repo.status", (String)repositoryStatus));
        Gauge.builder((String)"armeria.build.info", () -> 1).tags(tags).description("A metric with a constant '1' value labeled by version and commit hash from which Armeria was built.").register(meterRegistry);
    }

    private void setupTlsMetrics(SslContext sslContext, String hostnamePattern) {
        MeterRegistry meterRegistry = this.config().meterRegistry();
        SSLSession sslSession = ServerSslContextUtil.validateSslContext(sslContext);
        for (Certificate certificate : sslSession.getLocalCertificates()) {
            if (!(certificate instanceof X509Certificate)) continue;
            try {
                X509Certificate x509Certificate = (X509Certificate)certificate;
                String commonName = MoreObjects.firstNonNull(CertificateUtil.getCommonName(x509Certificate), "");
                Gauge.builder((String)"armeria.server.tls.certificate.validity", (Object)x509Certificate, x509Cert -> {
                    try {
                        x509Cert.checkValidity();
                    }
                    catch (CertificateExpiredException | CertificateNotYetValidException e) {
                        return 0.0;
                    }
                    return 1.0;
                }).description("1 if TLS certificate is in validity period, 0 if certificate is not in validity period").tags(new String[]{"common.name", commonName, "hostname.pattern", hostnamePattern}).register(meterRegistry);
                Gauge.builder((String)"armeria.server.tls.certificate.validity.days", (Object)x509Certificate, x509Cert -> {
                    Duration diff = Duration.between(Instant.now(), x509Cert.getNotAfter().toInstant());
                    return diff.isNegative() ? -1.0 : (double)diff.toDays();
                }).description("Duration in days before TLS certificate expires, which becomes -1 if certificate is expired").tags(new String[]{"common.name", commonName, "hostname.pattern", hostnamePattern}).register(meterRegistry);
            }
            catch (Exception ex) {
                logger.warn("Failed to set up TLS certificate metrics for a host: {}", (Object)hostnamePattern, (Object)ex);
            }
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("config", this.config()).add("activePorts", this.activePorts()).add("state", this.startStop).toString();
    }

    public void reconfigure(ServerConfigurator serverConfigurator) {
        Objects.requireNonNull(serverConfigurator, "serverConfigurator");
        ServerBuilder sb = Server.builder();
        serverConfigurator.reconfigure(sb);
        DefaultServerConfig newConfig = sb.buildServerConfig(this.config());
        newConfig.setServer(this);
        this.config.updateConfig(newConfig);
        this.config.serviceConfigs().forEach(cfg -> ServiceCallbackInvoker.invokeServiceAdded(cfg, cfg.service()));
        this.hasWebSocketService = Server.hasWebSocketService(this.config);
    }

    private static boolean hasWebSocketService(UpdatableServerConfig config) {
        return config.serviceConfigs().stream().anyMatch(serviceConfig -> serviceConfig.service().as(WebSocketService.class) != null);
    }

    public CompletableFuture<Void> closeOnJvmShutdown() {
        return ShutdownHooks.addClosingTask(this);
    }

    public CompletableFuture<Void> closeOnJvmShutdown(Runnable whenClosing) {
        Objects.requireNonNull(whenClosing, "whenClosing");
        return ShutdownHooks.addClosingTask(this, whenClosing);
    }

    private static String bossThreadName(ServerPort port) {
        String protocolNames = port.protocols().stream().map(SessionProtocol::uriText).collect(Collectors.joining("+"));
        InetSocketAddress localAddr = port.localAddress();
        String localAddrText = !port.isDomainSocket() ? (localAddr.getAddress().isAnyLocalAddress() ? "*" : localAddr.getHostString()) + ':' + localAddr.getPort() : "unix:" + localAddr;
        return "armeria-boss-" + protocolNames + '-' + localAddrText;
    }

    private static boolean isLocalPort(ServerPort serverPort) {
        InetAddress address = serverPort.localAddress().getAddress();
        return address.isAnyLocalAddress() || address.isLoopbackAddress();
    }

    private final class ServerStartStopSupport
    extends StartStopSupport<Void, Void, Void, ServerListener> {
        @Nullable
        private volatile GracefulShutdownSupport gracefulShutdownSupport;

        ServerStartStopSupport(Executor startStopExecutor) {
            super(startStopExecutor);
        }

        @Override
        protected CompletionStage<Void> doStart(@Nullable Void arg) {
            this.gracefulShutdownSupport = Server.this.config().gracefulShutdownQuietPeriod().isZero() ? GracefulShutdownSupport.createDisabled() : GracefulShutdownSupport.create(Server.this.config().gracefulShutdownQuietPeriod(), Server.this.config().blockingTaskExecutor());
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            List<ServerPort> ports = Server.this.config().ports();
            Iterator<ServerPort> it = ports.iterator();
            assert (it.hasNext());
            ServerPort primary = it.next();
            try {
                this.doStart(primary).addListener((GenericFutureListener)new ServerPortStartListener(primary)).addListener((GenericFutureListener)new NextServerPortStartListener(this, it, future));
                this.setupServerMetrics();
            }
            catch (Throwable cause) {
                future.completeExceptionally(cause);
            }
            return future;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private ChannelFuture doStart(ServerPort port) {
            Class<? extends ServerChannel> channelType;
            InetSocketAddress localAddress;
            ServerBootstrap b;
            Server.this.serverBootstrap = b = new ServerBootstrap();
            Server.this.config.channelOptions().forEach((k, v) -> {
                ChannelOption castOption = k;
                b.option(castOption, v);
            });
            Server.this.config.childChannelOptions().forEach((k, v) -> {
                if (!port.isDomainSocket() || !ChannelUtil.isTcpOption(k)) {
                    ChannelOption castOption = k;
                    b.childOption(castOption, v);
                }
            });
            EventLoopGroup bossGroup = EventLoopGroups.newEventLoopGroup(1, r -> {
                FastThreadLocalThread thread = new FastThreadLocalThread(r, Server.bossThreadName(port));
                thread.setDaemon(false);
                return thread;
            });
            b.group(bossGroup, Server.this.config.workerGroup());
            b.handler((ChannelHandler)Server.this.connectionLimitingHandler);
            b.childHandler((ChannelHandler)new HttpServerPipelineConfigurator(Server.this.config, port, this.gracefulShutdownSupport, Server.this.hasWebSocketService));
            TransportType transportType = Flags.transportType();
            if (port.isDomainSocket()) {
                if (!transportType.supportsDomainSockets()) throw new IllegalStateException("Unix domains sockets not supported by the current transport type: " + transportType.name());
                localAddress = ((DomainSocketAddress)port.localAddress()).asNettyAddress();
                channelType = transportType.domainServerChannelType();
            } else {
                localAddress = port.localAddress();
                channelType = transportType.serverChannelType();
            }
            b.channel(channelType);
            return b.bind((SocketAddress)localAddress);
        }

        private void setupServerMetrics() {
            MeterRegistry meterRegistry = Server.this.config().meterRegistry();
            GracefulShutdownSupport gracefulShutdownSupport = this.gracefulShutdownSupport;
            assert (gracefulShutdownSupport != null);
            meterRegistry.gauge("armeria.server.pending.responses", (Object)gracefulShutdownSupport, GracefulShutdownSupport::pendingResponses);
            meterRegistry.gauge("armeria.server.connections", (Object)Server.this.connectionLimitingHandler, ConnectionLimitingHandler::numConnections);
        }

        @Override
        protected CompletionStage<Void> doStop(@Nullable Void arg) {
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            GracefulShutdownSupport gracefulShutdownSupport = this.gracefulShutdownSupport;
            if (gracefulShutdownSupport == null || gracefulShutdownSupport.completedQuietPeriod()) {
                this.doStop(future, null);
                return future;
            }
            ScheduledExecutorService gracefulShutdownExecutor = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, "armeria-shutdown-0x" + Integer.toHexString(this.hashCode())));
            ScheduledFuture<?> quietPeriodFuture = gracefulShutdownExecutor.scheduleAtFixedRate(() -> {
                if (gracefulShutdownSupport.completedQuietPeriod()) {
                    this.doStop(future, gracefulShutdownExecutor);
                }
            }, 0L, 100L, TimeUnit.MILLISECONDS);
            try {
                gracefulShutdownExecutor.schedule(() -> {
                    quietPeriodFuture.cancel(false);
                    this.doStop(future, gracefulShutdownExecutor);
                }, Server.this.config.gracefulShutdownTimeout().toMillis(), TimeUnit.MILLISECONDS);
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
            return future;
        }

        private void doStop(CompletableFuture<Void> future, @Nullable ExecutorService gracefulShutdownExecutor) {
            if (gracefulShutdownExecutor != null) {
                gracefulShutdownExecutor.shutdownNow();
            }
            ImmutableSet serverChannels = ImmutableSet.copyOf(Server.this.serverChannels);
            ChannelUtil.close(serverChannels).handle((unused1, unused2) -> {
                Server.this.lock.lock();
                try {
                    Server.this.activePorts.clear();
                }
                finally {
                    Server.this.lock.unlock();
                }
                ChannelUtil.close(Server.this.connectionLimitingHandler.children()).handle((unused3, unused4) -> {
                    Future workerShutdownFuture = Server.this.config.shutdownWorkerGroupOnStop() ? Server.this.config.workerGroup().shutdownGracefully() : ImmediateEventExecutor.INSTANCE.newSucceededFuture(null);
                    workerShutdownFuture.addListener(unused5 -> {
                        Set bossGroups = Server.this.serverChannels.stream().map(ch -> ch.eventLoop().parent()).collect(ImmutableSet.toImmutableSet());
                        if (bossGroups.isEmpty()) {
                            this.finishDoStop(future);
                            return;
                        }
                        AtomicInteger remainingBossGroups = new AtomicInteger(bossGroups.size());
                        bossGroups.forEach(bossGroup -> {
                            bossGroup.shutdownGracefully();
                            bossGroup.terminationFuture().addListener(unused6 -> {
                                if (remainingBossGroups.decrementAndGet() != 0) {
                                    return;
                                }
                                this.finishDoStop(future);
                            });
                        });
                    });
                    return null;
                });
                return null;
            });
        }

        private void finishDoStop(CompletableFuture<Void> future) {
            Server.this.serverChannels.clear();
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.addAll(Server.this.config.delegate().shutdownSupports());
            for (VirtualHost virtualHost : Server.this.config.virtualHosts()) {
                builder.addAll(virtualHost.shutdownSupports());
            }
            for (ServiceConfig serviceConfig : Server.this.config.serviceConfigs()) {
                builder.addAll(serviceConfig.shutdownSupports());
            }
            CompletableFuture.runAsync(() -> CompletableFutures.successfulAsList(builder.build().stream().map(ShutdownSupport::shutdown).collect(ImmutableList.toImmutableList()), cause -> null).thenRunAsync(() -> future.complete(null), Server.this.config.startStopExecutor()), Server.this.config.startStopExecutor());
        }

        @Override
        protected void notifyStarting(ServerListener listener, @Nullable Void arg) throws Exception {
            listener.serverStarting(Server.this);
        }

        @Override
        protected void notifyStarted(ServerListener listener, @Nullable Void arg, @Nullable Void result) throws Exception {
            listener.serverStarted(Server.this);
        }

        @Override
        protected void notifyStopping(ServerListener listener, @Nullable Void arg) throws Exception {
            listener.serverStopping(Server.this);
        }

        @Override
        protected void notifyStopped(ServerListener listener, @Nullable Void arg) throws Exception {
            listener.serverStopped(Server.this);
        }

        @Override
        protected void rollbackFailed(Throwable cause) {
            this.logStopFailure(cause);
        }

        @Override
        protected void notificationFailed(ServerListener listener, Throwable cause) {
            logger.warn("Failed to notify a server listener: {}", (Object)listener, (Object)cause);
        }

        @Override
        protected void closeFailed(Throwable cause) {
            this.logStopFailure(cause);
        }

        private void logStopFailure(Throwable cause) {
            logger.warn("Failed to stop a server: {}", (Object)cause.getMessage(), (Object)cause);
        }
    }

    private final class NextServerPortStartListener
    implements ChannelFutureListener {
        private final ServerStartStopSupport startStopSupport;
        private final Iterator<ServerPort> it;
        private final CompletableFuture<Void> future;

        NextServerPortStartListener(ServerStartStopSupport startStopSupport, Iterator<ServerPort> it, CompletableFuture<Void> future) {
            this.startStopSupport = startStopSupport;
            this.it = it;
            this.future = future;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void operationComplete(ChannelFuture f) throws Exception {
            ServerPort actualNext;
            if (!f.isSuccess()) {
                this.future.completeExceptionally(f.cause());
                return;
            }
            if (!this.it.hasNext()) {
                this.future.complete(null);
                return;
            }
            ServerPort next = this.it.next();
            long portGroup = next.portGroup();
            if (portGroup != 0L) {
                int previousPort = 0;
                Server.this.lock.lock();
                try {
                    for (ServerPort activePort : Server.this.activePorts.values()) {
                        if (activePort.portGroup() != portGroup) continue;
                        previousPort = activePort.localAddress().getPort();
                        break;
                    }
                }
                finally {
                    Server.this.lock.unlock();
                }
                actualNext = previousPort > 0 ? new ServerPort(new InetSocketAddress(next.localAddress().getAddress(), previousPort), next.protocols(), portGroup) : next;
            } else {
                actualNext = next;
            }
            this.startStopSupport.doStart(actualNext).addListener((GenericFutureListener)new ServerPortStartListener(actualNext)).addListener((GenericFutureListener)this);
        }
    }

    private final class ServerPortStartListener
    implements ChannelFutureListener {
        private final ServerPort port;

        ServerPortStartListener(ServerPort port) {
            this.port = Objects.requireNonNull(port, "port");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void operationComplete(ChannelFuture f) {
            ServerChannel ch = (ServerChannel)f.channel();
            assert (ch.eventLoop().inEventLoop());
            Server.this.serverChannels.add(ch);
            if (f.isSuccess()) {
                ServerPort actualPort;
                SocketAddress localAddress = ch.localAddress();
                if (localAddress instanceof InetSocketAddress) {
                    actualPort = new ServerPort((InetSocketAddress)localAddress, this.port.protocols(), this.port.portGroup());
                } else if (localAddress instanceof io.netty.channel.unix.DomainSocketAddress) {
                    DomainSocketAddress converted = DomainSocketAddress.of((io.netty.channel.unix.DomainSocketAddress)localAddress);
                    actualPort = new ServerPort((InetSocketAddress)converted, this.port.protocols(), this.port.portGroup());
                } else {
                    logger.warn("Unexpected local address type: {}", (Object)localAddress.getClass().getName());
                    return;
                }
                Thread.currentThread().setName(Server.bossThreadName(actualPort));
                Server.this.lock.lock();
                try {
                    Server.this.activePorts.put(actualPort.localAddress(), actualPort);
                }
                finally {
                    Server.this.lock.unlock();
                }
                if (logger.isInfoEnabled()) {
                    if (Server.isLocalPort(actualPort)) {
                        this.port.protocols().forEach(p -> logger.info("Serving {} at {} - {}://127.0.0.1:{}/", new Object[]{p.name(), localAddress, p.uriText(), actualPort.localAddress().getPort()}));
                    } else {
                        logger.info("Serving {} at {}", (Object)Joiner.on('+').join(this.port.protocols()), (Object)localAddress);
                    }
                }
            }
        }
    }
}

