/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.AggregatedHttpRequest;
import com.linecorp.armeria.common.AggregationOptions;
import com.linecorp.armeria.common.ExchangeType;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpObject;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.common.stream.AggregatingStreamMessage;
import com.linecorp.armeria.server.DecodedHttpRequestWriter;
import com.linecorp.armeria.server.Routed;
import com.linecorp.armeria.server.RoutingContext;
import com.linecorp.armeria.server.ServiceConfig;
import com.linecorp.armeria.server.ServiceRequestContext;
import io.netty.channel.EventLoop;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

final class AggregatingDecodedHttpRequest
extends AggregatingStreamMessage<HttpObject>
implements DecodedHttpRequestWriter {
    private final EventLoop eventLoop;
    private final int id;
    private final int streamId;
    private final boolean keepAlive;
    private final long maxRequestLength;
    private final RequestHeaders headers;
    private final RoutingContext routingCtx;
    private final ExchangeType exchangeType;
    private final long requestStartTimeNanos;
    private final long requestStartTimeMicros;
    @Nullable
    private ServiceRequestContext ctx;
    @Nullable
    private HttpHeaders trailers;
    private long transferredBytes;
    @Nullable
    private HttpResponse response;
    private boolean isResponseAborted;

    AggregatingDecodedHttpRequest(EventLoop eventLoop, int id, int streamId, RequestHeaders headers, boolean keepAlive, long maxRequestLength, RoutingContext routingCtx, ExchangeType exchangeType, long requestStartTimeNanos, long requestStartTimeMicros) {
        super(4);
        this.headers = headers;
        this.eventLoop = eventLoop;
        this.id = id;
        this.streamId = streamId;
        this.keepAlive = keepAlive;
        this.maxRequestLength = maxRequestLength;
        assert (routingCtx.hasResult());
        this.routingCtx = routingCtx;
        this.exchangeType = exchangeType;
        this.requestStartTimeNanos = requestStartTimeNanos;
        this.requestStartTimeMicros = requestStartTimeMicros;
    }

    @Override
    public void init(ServiceRequestContext ctx) {
        this.ctx = ctx;
        ctx.logBuilder().increaseRequestLength(this.transferredBytes);
        if (this.trailers != null) {
            ctx.logBuilder().requestTrailers(this.trailers);
        }
    }

    @Override
    public CompletableFuture<AggregatedHttpRequest> aggregate(AggregationOptions options) {
        return super.aggregate(options);
    }

    @Override
    public RoutingContext routingContext() {
        return this.routingCtx;
    }

    @Override
    @Nonnull
    public Routed<ServiceConfig> route() {
        return this.routingCtx.result();
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public int streamId() {
        return this.streamId;
    }

    @Override
    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    @Override
    public long maxRequestLength() {
        return this.ctx != null ? this.ctx.maxRequestLength() : this.maxRequestLength;
    }

    @Override
    public long transferredBytes() {
        return this.transferredBytes;
    }

    @Override
    public void increaseTransferredBytes(long delta) {
        this.transferredBytes = this.transferredBytes > Long.MAX_VALUE - delta ? Long.MAX_VALUE : (this.transferredBytes += delta);
    }

    public EventLoop defaultSubscriberExecutor() {
        return this.eventLoop;
    }

    @Override
    public boolean tryWrite(HttpObject obj) {
        boolean published = super.tryWrite(obj);
        if (obj instanceof HttpData) {
            ((HttpData)obj).touch(this.routingCtx);
            if (obj.isEndOfStream()) {
                this.close();
            }
        }
        if (obj instanceof HttpHeaders) {
            this.trailers = (HttpHeaders)obj;
            this.close();
        }
        return published;
    }

    @Override
    public void setResponse(HttpResponse response) {
        if (this.isResponseAborted) {
            if (!response.isComplete()) {
                response.abort();
            }
        } else {
            this.response = response;
        }
    }

    @Override
    public void abortResponse(Throwable cause, boolean cancel) {
        this.isResponseAborted = true;
        if (cancel && this.ctx != null) {
            this.ctx.cancel(cause);
        }
        if (this.response != null && !this.response.isComplete()) {
            this.response.abort(cause);
        }
    }

    @Override
    public boolean needsAggregation() {
        return true;
    }

    @Override
    public ExchangeType exchangeType() {
        return this.exchangeType;
    }

    @Override
    public long requestStartTimeNanos() {
        return this.requestStartTimeNanos;
    }

    @Override
    public long requestStartTimeMicros() {
        return this.requestStartTimeMicros;
    }

    @Override
    public RequestHeaders headers() {
        return this.headers;
    }
}

