/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common.websocket;

import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.websocket.CloseWebSocketFrame;
import com.linecorp.armeria.common.websocket.WebSocketCloseStatus;
import com.linecorp.armeria.common.websocket.WebSocketFrame;
import com.linecorp.armeria.server.websocket.WebSocketProtocolViolationException;
import io.netty.handler.codec.http.HttpHeaderValues;
import java.util.Objects;

public final class WebSocketUtil {
    public static boolean isHttp1WebSocketUpgradeRequest(RequestHeaders headers) {
        Objects.requireNonNull(headers, "headers");
        return headers.method() == HttpMethod.GET && HttpHeaderValues.UPGRADE.contentEqualsIgnoreCase((CharSequence)headers.get((CharSequence)HttpHeaderNames.CONNECTION)) && HttpHeaderValues.WEBSOCKET.contentEqualsIgnoreCase((CharSequence)headers.get((CharSequence)HttpHeaderNames.UPGRADE));
    }

    public static boolean isHttp2WebSocketUpgradeRequest(RequestHeaders headers) {
        Objects.requireNonNull(headers, "headers");
        return headers.method() == HttpMethod.CONNECT && HttpHeaderValues.WEBSOCKET.contentEqualsIgnoreCase((CharSequence)headers.get((CharSequence)HttpHeaderNames.PROTOCOL));
    }

    static int byteAtIndex(int mask, int index) {
        return mask >> 8 * (3 - index) & 0xFF;
    }

    public static CloseWebSocketFrame newCloseWebSocketFrame(Throwable cause) {
        WebSocketCloseStatus closeStatus = cause instanceof WebSocketProtocolViolationException ? ((WebSocketProtocolViolationException)cause).closeStatus() : WebSocketCloseStatus.INTERNAL_SERVER_ERROR;
        String reasonPhrase = cause.getMessage();
        if (reasonPhrase == null) {
            reasonPhrase = closeStatus.reasonPhrase();
        }
        return WebSocketFrame.ofClose(closeStatus, reasonPhrase);
    }

    private WebSocketUtil() {
    }
}

