/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.client;

import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.common.ClosedSessionException;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.client.DecodedHttpResponse;
import com.linecorp.armeria.internal.client.PooledChannel;
import com.linecorp.armeria.internal.common.InboundTrafficController;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;

public interface HttpSession {
    public static final int MAX_NUM_REQUESTS_SENT = 0x20000000;
    public static final HttpSession INACTIVE = new HttpSession(){

        @Override
        @Nullable
        public SessionProtocol protocol() {
            return null;
        }

        @Override
        public boolean canSendRequest() {
            return false;
        }

        @Override
        public InboundTrafficController inboundTrafficController() {
            return InboundTrafficController.disabled();
        }

        @Override
        public boolean hasUnfinishedResponses() {
            return false;
        }

        @Override
        public boolean incrementNumUnfinishedResponses() {
            return false;
        }

        @Override
        public void invoke(PooledChannel pooledChannel, ClientRequestContext ctx, HttpRequest req, DecodedHttpResponse res) {
            res.close(ClosedSessionException.get());
        }

        @Override
        public void retryWith(SessionProtocol protocol) {
            throw new IllegalStateException();
        }

        @Override
        public boolean isAcquirable() {
            return false;
        }

        @Override
        public void deactivate() {
        }

        @Override
        public int incrementAndGetNumRequestsSent() {
            return 0x20000000;
        }
    };

    public static HttpSession get(Channel ch) {
        ChannelHandler lastHandler = ch.pipeline().last();
        if (lastHandler instanceof HttpSession) {
            return (HttpSession)lastHandler;
        }
        return INACTIVE;
    }

    @Nullable
    public SessionProtocol protocol();

    public boolean isAcquirable();

    public void deactivate();

    public boolean canSendRequest();

    public InboundTrafficController inboundTrafficController();

    public boolean hasUnfinishedResponses();

    public boolean incrementNumUnfinishedResponses();

    public void invoke(PooledChannel var1, ClientRequestContext var2, HttpRequest var3, DecodedHttpResponse var4);

    public void retryWith(SessionProtocol var1);

    public int incrementAndGetNumRequestsSent();
}

