/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.logging;

import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.HttpStatusClass;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.logging.LogLevel;
import com.linecorp.armeria.common.logging.RequestLog;
import java.util.Objects;
import java.util.function.Function;

@FunctionalInterface
public interface ResponseLogLevelMapper
extends Function<RequestLog, LogLevel> {
    public static ResponseLogLevelMapper of(LogLevel successfulResponseLogLevel, LogLevel failureResponseLogLevel) {
        return log -> log.responseCause() == null ? successfulResponseLogLevel : failureResponseLogLevel;
    }

    public static ResponseLogLevelMapper of(HttpStatus status, LogLevel logLevel) {
        Objects.requireNonNull(status, "status");
        Objects.requireNonNull(logLevel, "logLevel");
        return log -> log.responseStatus() == status ? logLevel : null;
    }

    public static ResponseLogLevelMapper of(HttpStatusClass statusClass, LogLevel logLevel) {
        Objects.requireNonNull(statusClass, "statusClass");
        Objects.requireNonNull(logLevel, "logLevel");
        return log -> log.responseStatus().codeClass() == statusClass ? logLevel : null;
    }

    public static ResponseLogLevelMapper of(Class<? extends Throwable> clazz, LogLevel logLevel) {
        Objects.requireNonNull(clazz, "clazz");
        Objects.requireNonNull(logLevel, "logLevel");
        return log -> {
            Throwable t = log.responseCause();
            if (t == null) {
                return null;
            }
            Class<?> throwableClass = t.getClass();
            if (clazz.isAssignableFrom(throwableClass)) {
                return logLevel;
            }
            return null;
        };
    }

    @Override
    @Nullable
    public LogLevel apply(RequestLog var1);

    default public ResponseLogLevelMapper orElse(ResponseLogLevelMapper other) {
        Objects.requireNonNull(other, "other");
        if (this == other) {
            return this;
        }
        return log -> {
            LogLevel logLevel = this.apply(log);
            if (logLevel != null) {
                return logLevel;
            }
            return other.apply(log);
        };
    }

    @Override
    @Deprecated
    default public <V> Function<V, LogLevel> compose(Function<? super V, ? extends RequestLog> before) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    default public <V> Function<RequestLog, V> andThen(Function<? super LogLevel, ? extends V> after) {
        throw new UnsupportedOperationException();
    }
}

