/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.logging;

import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.HttpStatusClass;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.logging.LogFormatter;
import com.linecorp.armeria.common.logging.LogLevel;
import com.linecorp.armeria.common.logging.LogWriter;
import com.linecorp.armeria.common.logging.LogWriterBuilder;
import com.linecorp.armeria.common.logging.RequestLog;
import com.linecorp.armeria.common.logging.RequestLogLevelMapper;
import com.linecorp.armeria.common.logging.RequestOnlyLog;
import com.linecorp.armeria.common.logging.ResponseLogLevelMapper;
import com.linecorp.armeria.common.logging.TextLogFormatterBuilder;
import com.linecorp.armeria.common.util.Functions;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LoggingDecoratorBuilder {
    private static final BiFunction<RequestContext, HttpHeaders, HttpHeaders> DEFAULT_HEADERS_SANITIZER = Functions.second();
    private static final BiFunction<RequestContext, Object, Object> DEFAULT_CONTENT_SANITIZER = Functions.second();
    private static final BiFunction<RequestContext, Throwable, Throwable> DEFAULT_CAUSE_SANITIZER = Functions.second();
    @Nullable
    private Logger logger;
    @Nullable
    private RequestLogLevelMapper requestLogLevelMapper;
    @Nullable
    private ResponseLogLevelMapper responseLogLevelMapper;
    private BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable Object> requestHeadersSanitizer = DEFAULT_HEADERS_SANITIZER;
    private BiFunction<? super RequestContext, Object, ? extends @Nullable Object> requestContentSanitizer = DEFAULT_CONTENT_SANITIZER;
    private BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable Object> requestTrailersSanitizer = DEFAULT_HEADERS_SANITIZER;
    private BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable Object> responseHeadersSanitizer = DEFAULT_HEADERS_SANITIZER;
    private BiFunction<? super RequestContext, Object, ? extends @Nullable Object> responseContentSanitizer = DEFAULT_CONTENT_SANITIZER;
    private BiFunction<? super RequestContext, ? super Throwable, ? extends @Nullable Object> responseCauseSanitizer = DEFAULT_CAUSE_SANITIZER;
    private BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable Object> responseTrailersSanitizer = DEFAULT_HEADERS_SANITIZER;
    private Predicate<Throwable> responseCauseFilter = throwable -> false;
    @Nullable
    private LogWriter logWriter;
    private boolean buildLogWriter;

    private static <T, U> BiFunction<T, U, @Nullable String> convertToStringSanitizer(BiFunction<T, U, ? extends @Nullable Object> originalSanitizer) {
        return (first, second) -> {
            Object sanitized = originalSanitizer.apply(first, second);
            return sanitized != null ? sanitized.toString() : null;
        };
    }

    protected LoggingDecoratorBuilder defaultLogger(Logger logger) {
        Objects.requireNonNull(logger, "logger");
        if (this.logger == null) {
            this.logger = logger;
        }
        return this;
    }

    @Deprecated
    public LoggingDecoratorBuilder logger(Logger logger) {
        this.setBuildLogWriter();
        this.logger = Objects.requireNonNull(logger, "logger");
        return this;
    }

    @Deprecated
    public LoggingDecoratorBuilder logger(String loggerName) {
        this.setBuildLogWriter();
        Objects.requireNonNull(loggerName, "loggerName");
        this.logger = LoggerFactory.getLogger((String)loggerName);
        return this;
    }

    @Nullable
    protected final Logger logger() {
        return this.logger;
    }

    @Deprecated
    public LoggingDecoratorBuilder requestLogLevel(LogLevel requestLogLevel) {
        Objects.requireNonNull(requestLogLevel, "requestLogLevel");
        return this.requestLogLevelMapper(RequestLogLevelMapper.of(requestLogLevel));
    }

    @Deprecated
    public LoggingDecoratorBuilder requestLogLevel(Class<? extends Throwable> clazz, LogLevel requestLogLevel) {
        Objects.requireNonNull(clazz, "clazz");
        Objects.requireNonNull(requestLogLevel, "requestLogLevel");
        return this.requestLogLevelMapper(RequestLogLevelMapper.of(clazz, requestLogLevel));
    }

    @Deprecated
    public LoggingDecoratorBuilder requestLogLevelMapper(Function<? super RequestOnlyLog, LogLevel> requestLogLevelMapper) {
        Objects.requireNonNull(requestLogLevelMapper, "requestLogLevelMapper");
        return this.requestLogLevelMapper(requestLogLevelMapper::apply);
    }

    @Deprecated
    public LoggingDecoratorBuilder requestLogLevelMapper(RequestLogLevelMapper requestLogLevelMapper) {
        this.setBuildLogWriter();
        Objects.requireNonNull(requestLogLevelMapper, "requestLogLevelMapper");
        this.requestLogLevelMapper = this.requestLogLevelMapper == null ? requestLogLevelMapper : this.requestLogLevelMapper.orElse(requestLogLevelMapper);
        return this;
    }

    protected final RequestLogLevelMapper requestLogLevelMapper() {
        if (this.requestLogLevelMapper == null) {
            return RequestLogLevelMapper.of(LogLevel.DEBUG);
        }
        return this.requestLogLevelMapper.orElse(RequestLogLevelMapper.of(LogLevel.DEBUG));
    }

    @Deprecated
    public LoggingDecoratorBuilder responseLogLevel(HttpStatus status, LogLevel logLevel) {
        return this.responseLogLevelMapper(ResponseLogLevelMapper.of(status, logLevel));
    }

    @Deprecated
    public LoggingDecoratorBuilder responseLogLevel(HttpStatusClass statusClass, LogLevel logLevel) {
        return this.responseLogLevelMapper(ResponseLogLevelMapper.of(statusClass, logLevel));
    }

    @Deprecated
    public LoggingDecoratorBuilder responseLogLevel(Class<? extends Throwable> clazz, LogLevel logLevel) {
        Objects.requireNonNull(clazz, "clazz");
        Objects.requireNonNull(logLevel, "logLevel");
        return this.responseLogLevelMapper(ResponseLogLevelMapper.of(clazz, logLevel));
    }

    @Deprecated
    public LoggingDecoratorBuilder successfulResponseLogLevel(LogLevel successfulResponseLogLevel) {
        Objects.requireNonNull(successfulResponseLogLevel, "successfulResponseLogLevel");
        return this.responseLogLevelMapper((RequestLog log) -> log.responseCause() == null ? successfulResponseLogLevel : null);
    }

    @Deprecated
    public LoggingDecoratorBuilder failureResponseLogLevel(LogLevel failedResponseLogLevel) {
        Objects.requireNonNull(failedResponseLogLevel, "failedResponseLogLevel");
        return this.responseLogLevelMapper((RequestLog log) -> log.responseCause() != null ? failedResponseLogLevel : null);
    }

    @Deprecated
    public LoggingDecoratorBuilder responseLogLevelMapper(Function<? super RequestLog, LogLevel> responseLogLevelMapper) {
        Objects.requireNonNull(responseLogLevelMapper, "responseLogLevelMapper");
        return this.responseLogLevelMapper(responseLogLevelMapper::apply);
    }

    @Deprecated
    public LoggingDecoratorBuilder responseLogLevelMapper(ResponseLogLevelMapper responseLogLevelMapper) {
        this.setBuildLogWriter();
        Objects.requireNonNull(responseLogLevelMapper, "responseLogLevelMapper");
        this.responseLogLevelMapper = this.responseLogLevelMapper == null ? responseLogLevelMapper : this.responseLogLevelMapper.orElse(responseLogLevelMapper);
        return this;
    }

    protected final ResponseLogLevelMapper responseLogLevelMapper() {
        if (this.responseLogLevelMapper == null) {
            return ResponseLogLevelMapper.of(LogLevel.DEBUG, LogLevel.WARN);
        }
        return this.responseLogLevelMapper.orElse(ResponseLogLevelMapper.of(LogLevel.DEBUG, LogLevel.WARN));
    }

    @Deprecated
    public LoggingDecoratorBuilder requestHeadersSanitizer(BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable Object> requestHeadersSanitizer) {
        this.setBuildLogWriter();
        this.requestHeadersSanitizer = Objects.requireNonNull(requestHeadersSanitizer, "requestHeadersSanitizer");
        return this;
    }

    protected final BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable Object> requestHeadersSanitizer() {
        return this.requestHeadersSanitizer;
    }

    @Deprecated
    public LoggingDecoratorBuilder responseHeadersSanitizer(BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable Object> responseHeadersSanitizer) {
        this.setBuildLogWriter();
        this.responseHeadersSanitizer = Objects.requireNonNull(responseHeadersSanitizer, "responseHeadersSanitizer");
        return this;
    }

    protected final BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable Object> responseHeadersSanitizer() {
        return this.responseHeadersSanitizer;
    }

    @Deprecated
    public LoggingDecoratorBuilder requestTrailersSanitizer(BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable Object> requestTrailersSanitizer) {
        this.setBuildLogWriter();
        this.requestTrailersSanitizer = Objects.requireNonNull(requestTrailersSanitizer, "requestTrailersSanitizer");
        return this;
    }

    protected final BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable Object> requestTrailersSanitizer() {
        return this.requestTrailersSanitizer;
    }

    @Deprecated
    public LoggingDecoratorBuilder responseTrailersSanitizer(BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable Object> responseTrailersSanitizer) {
        this.setBuildLogWriter();
        this.responseTrailersSanitizer = Objects.requireNonNull(responseTrailersSanitizer, "responseTrailersSanitizer");
        return this;
    }

    protected final BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable Object> responseTrailersSanitizer() {
        return this.responseTrailersSanitizer;
    }

    @Deprecated
    public LoggingDecoratorBuilder headersSanitizer(BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable Object> headersSanitizer) {
        Objects.requireNonNull(headersSanitizer, "headersSanitizer");
        this.requestHeadersSanitizer(headersSanitizer);
        this.requestTrailersSanitizer(headersSanitizer);
        this.responseHeadersSanitizer(headersSanitizer);
        this.responseTrailersSanitizer(headersSanitizer);
        return this;
    }

    @Deprecated
    public LoggingDecoratorBuilder requestContentSanitizer(BiFunction<? super RequestContext, Object, ? extends @Nullable Object> requestContentSanitizer) {
        this.setBuildLogWriter();
        this.requestContentSanitizer = Objects.requireNonNull(requestContentSanitizer, "requestContentSanitizer");
        return this;
    }

    protected final BiFunction<? super RequestContext, Object, ? extends @Nullable Object> requestContentSanitizer() {
        return this.requestContentSanitizer;
    }

    @Deprecated
    public LoggingDecoratorBuilder responseContentSanitizer(BiFunction<? super RequestContext, Object, ? extends @Nullable Object> responseContentSanitizer) {
        this.setBuildLogWriter();
        this.responseContentSanitizer = Objects.requireNonNull(responseContentSanitizer, "responseContentSanitizer");
        return this;
    }

    protected final BiFunction<? super RequestContext, Object, ? extends @Nullable Object> responseContentSanitizer() {
        return this.responseContentSanitizer;
    }

    @Deprecated
    public LoggingDecoratorBuilder contentSanitizer(BiFunction<? super RequestContext, Object, ? extends @Nullable Object> contentSanitizer) {
        Objects.requireNonNull(contentSanitizer, "contentSanitizer");
        this.requestContentSanitizer(contentSanitizer);
        this.responseContentSanitizer(contentSanitizer);
        return this;
    }

    @Deprecated
    public LoggingDecoratorBuilder responseCauseSanitizer(BiFunction<? super RequestContext, ? super Throwable, ? extends @Nullable Object> responseCauseSanitizer) {
        this.setBuildLogWriter();
        this.responseCauseSanitizer = Objects.requireNonNull(responseCauseSanitizer, "responseCauseSanitizer");
        return this;
    }

    protected final BiFunction<? super RequestContext, ? super Throwable, ? extends @Nullable Object> responseCauseSanitizer() {
        return this.responseCauseSanitizer;
    }

    @Deprecated
    public LoggingDecoratorBuilder responseCauseFilter(Predicate<Throwable> responseCauseFilter) {
        this.setBuildLogWriter();
        this.responseCauseFilter = Objects.requireNonNull(responseCauseFilter, "responseCauseFilter");
        return this;
    }

    public LoggingDecoratorBuilder logWriter(LogWriter logWriter) {
        if (this.buildLogWriter) {
            throw new IllegalStateException("The logWriter and the log properties cannot be set together.");
        }
        this.logWriter = Objects.requireNonNull(logWriter, "logWriter");
        return this;
    }

    protected final LogWriter logWriter() {
        if (this.logWriter != null) {
            return this.logWriter;
        }
        if (!this.buildLogWriter) {
            if (this.logger != null) {
                return LogWriter.of(this.logger);
            }
            return LogWriter.of();
        }
        LogFormatter logFormatter = ((TextLogFormatterBuilder)((TextLogFormatterBuilder)((TextLogFormatterBuilder)((TextLogFormatterBuilder)((TextLogFormatterBuilder)((TextLogFormatterBuilder)LogFormatter.builderForText().requestHeadersSanitizer(LoggingDecoratorBuilder.convertToStringSanitizer(this.requestHeadersSanitizer))).responseHeadersSanitizer(LoggingDecoratorBuilder.convertToStringSanitizer(this.responseHeadersSanitizer))).requestTrailersSanitizer(LoggingDecoratorBuilder.convertToStringSanitizer(this.requestTrailersSanitizer))).responseTrailersSanitizer(LoggingDecoratorBuilder.convertToStringSanitizer(this.responseTrailersSanitizer))).requestContentSanitizer(LoggingDecoratorBuilder.convertToStringSanitizer(this.requestContentSanitizer))).responseContentSanitizer(LoggingDecoratorBuilder.convertToStringSanitizer(this.responseContentSanitizer))).build();
        LogWriterBuilder builder = LogWriter.builder();
        builder.logFormatter(logFormatter);
        if (this.logger != null) {
            builder.logger(this.logger);
        }
        if (this.requestLogLevelMapper != null) {
            builder.requestLogLevelMapper(this.requestLogLevelMapper);
        }
        if (this.responseLogLevelMapper != null) {
            builder.responseLogLevelMapper(this.responseLogLevelMapper);
        }
        builder.responseCauseFilter(this.responseCauseFilter);
        return builder.build();
    }

    private void setBuildLogWriter() {
        if (this.logWriter != null) {
            throw new IllegalStateException("The logWriter and the log properties cannot be set together.");
        }
        this.buildLogWriter = true;
    }

    public String toString() {
        return LoggingDecoratorBuilder.toString(this, this.logger, this.requestLogLevelMapper(), this.responseLogLevelMapper(), this.requestHeadersSanitizer, this.requestContentSanitizer, this.requestTrailersSanitizer, this.responseHeadersSanitizer, this.responseContentSanitizer, this.responseTrailersSanitizer, this.responseCauseSanitizer, this.logWriter);
    }

    private static String toString(LoggingDecoratorBuilder self, @Nullable Logger logger, Function<? super RequestOnlyLog, LogLevel> requestLogLevelMapper, Function<? super RequestLog, LogLevel> responseLogLevelMapper, BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable Object> requestHeadersSanitizer, BiFunction<? super RequestContext, ?, ? extends @Nullable Object> requestContentSanitizer, BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable Object> requestTrailersSanitizer, BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable Object> responseHeadersSanitizer, BiFunction<? super RequestContext, Object, ? extends @Nullable Object> responseContentSanitizer, BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable Object> responseTrailersSanitizer, BiFunction<? super RequestContext, ? super Throwable, ? extends @Nullable Object> responseCauseSanitizer, @Nullable LogWriter logWriter) {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(self).omitNullValues().add("logger", logger).add("logWriter", logWriter);
        helper.add("requestLogLevelMapper", requestLogLevelMapper);
        helper.add("responseLogLevelMapper", responseLogLevelMapper);
        if (requestHeadersSanitizer != DEFAULT_HEADERS_SANITIZER) {
            helper.add("requestHeadersSanitizer", requestHeadersSanitizer);
        }
        if (requestContentSanitizer != DEFAULT_CONTENT_SANITIZER) {
            helper.add("requestContentSanitizer", requestContentSanitizer);
        }
        if (requestTrailersSanitizer != DEFAULT_HEADERS_SANITIZER) {
            helper.add("requestTrailersSanitizer", requestTrailersSanitizer);
        }
        if (responseHeadersSanitizer != DEFAULT_HEADERS_SANITIZER) {
            helper.add("responseHeadersSanitizer", responseHeadersSanitizer);
        }
        if (responseContentSanitizer != DEFAULT_CONTENT_SANITIZER) {
            helper.add("responseContentSanitizer", responseContentSanitizer);
        }
        if (responseTrailersSanitizer != DEFAULT_HEADERS_SANITIZER) {
            helper.add("responseTrailersSanitizer", responseTrailersSanitizer);
        }
        if (responseCauseSanitizer != DEFAULT_CAUSE_SANITIZER) {
            helper.add("responseCauseSanitizer", responseCauseSanitizer);
        }
        return helper.toString();
    }
}

