/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.linecorp.armeria.common.DefaultRequestEntity;
import com.linecorp.armeria.common.HttpEntity;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.annotation.Nullable;
import java.util.Objects;

public interface RequestEntity<T>
extends HttpEntity<T> {
    public static RequestEntity<Void> of(RequestHeaders headers) {
        return RequestEntity.of(headers, null, HttpHeaders.of());
    }

    public static <T> RequestEntity<T> of(RequestHeaders headers, T content) {
        Objects.requireNonNull(content, "content");
        return RequestEntity.of(headers, content, HttpHeaders.of());
    }

    public static <T> RequestEntity<T> of(RequestHeaders headers, @Nullable T content, HttpHeaders trailers) {
        Objects.requireNonNull(headers, "headers");
        Objects.requireNonNull(trailers, "trailers");
        return new DefaultRequestEntity<T>(headers, content, trailers);
    }

    @Override
    public RequestHeaders headers();

    default public HttpMethod method() {
        return this.headers().method();
    }
}

