/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.linecorp.armeria.common.ContentDisposition;
import com.linecorp.armeria.common.Cookie;
import com.linecorp.armeria.common.Cookies;
import com.linecorp.armeria.common.Flags;
import com.linecorp.armeria.common.HttpHeaderGetters;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.StringMultimap;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.common.ArmeriaHttpUtil;
import com.linecorp.armeria.internal.common.util.StringUtil;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.base.Splitter;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.Iterables;
import com.linecorp.armeria.internal.shaded.guava.math.IntMath;
import io.netty.util.AsciiString;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.Function;

class HttpHeadersBase
extends StringMultimap<CharSequence, AsciiString>
implements HttpHeaderGetters {
    private static final Splitter ACCEPT_SPLITTER = Splitter.on(',').trimResults();
    private static final BitSet PROHIBITED_VALUE_CHARS = new BitSet();
    private static final String[] PROHIBITED_VALUE_CHAR_NAMES;
    private static final char LAST_PROHIBITED_VALUE_CHAR;
    private final Map<AsciiString, Object> cache;
    private boolean endOfStream;

    HttpHeadersBase(int sizeHint) {
        super(sizeHint);
        this.cache = new HashMap<AsciiString, Object>(4);
    }

    HttpHeadersBase(HttpHeadersBase parent, boolean shallowCopy) {
        super(parent, shallowCopy);
        this.endOfStream = parent.endOfStream;
        this.cache = new HashMap<AsciiString, Object>(parent.cache);
    }

    HttpHeadersBase(HttpHeaderGetters parent) {
        super(parent);
        assert (!(parent instanceof HttpHeadersBase));
        this.endOfStream = parent.isEndOfStream();
        this.cache = new HashMap<AsciiString, Object>(4);
    }

    @Override
    void onChange(@Nullable AsciiString name) {
        if (this.cache == null || this.cache.isEmpty()) {
            return;
        }
        this.cache.remove(name);
    }

    @Override
    void onClear() {
        if (this.cache == null || this.cache.isEmpty()) {
            return;
        }
        this.cache.clear();
    }

    @Override
    final int hashName(CharSequence name) {
        return AsciiString.hashCode((CharSequence)name);
    }

    @Override
    final boolean nameEquals(AsciiString a, CharSequence b) {
        return a.contentEqualsIgnoreCase(b);
    }

    @Override
    final AsciiString normalizeName(CharSequence name) {
        return HttpHeaderNames.of(name);
    }

    @Override
    final boolean isFirstGroup(AsciiString name) {
        return !name.isEmpty() && name.byteAt(0) == 58;
    }

    @Override
    final void validateValue(String value) {
        if (!Flags.validateHeaders()) {
            return;
        }
        int valueLength = value.length();
        for (int i = 0; i < valueLength; ++i) {
            char ch = value.charAt(i);
            if (ch > LAST_PROHIBITED_VALUE_CHAR || !PROHIBITED_VALUE_CHARS.get(ch)) continue;
            throw new IllegalArgumentException(HttpHeadersBase.malformedHeaderValueMessage(value));
        }
    }

    private static String malformedHeaderValueMessage(String value) {
        StringBuilder buf = new StringBuilder(IntMath.saturatedAdd(value.length(), 64));
        buf.append("malformed header value: ");
        int valueLength = value.length();
        for (int i = 0; i < valueLength; ++i) {
            char ch = value.charAt(i);
            if (PROHIBITED_VALUE_CHARS.get(ch)) {
                buf.append(PROHIBITED_VALUE_CHAR_NAMES[ch]);
                continue;
            }
            buf.append(ch);
        }
        return buf.toString();
    }

    URI uri() {
        String uri;
        String path = this.path();
        if (ArmeriaHttpUtil.isAbsoluteUri(path)) {
            uri = path;
        } else {
            String scheme = this.scheme();
            Preconditions.checkState(scheme != null, ":scheme header does not exist.");
            String authority = this.authority();
            StringBuilder sb = new StringBuilder(scheme.length() + 1 + (authority != null ? authority.length() + 2 : 0) + path.length());
            sb.append(scheme);
            sb.append(':');
            if (authority != null) {
                sb.append("//");
                sb.append(authority);
            }
            sb.append(path);
            uri = sb.toString();
        }
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("not a valid URI: " + uri, e);
        }
    }

    final void cookie(Iterable<? extends Cookie> cookies) {
        this.addCookies(cookies, HttpHeaderNames.COOKIE, Cookie::toCookieHeader);
    }

    Cookies cookie() {
        return this.getCookie(HttpHeaderNames.COOKIE, Cookie::fromCookieHeaders);
    }

    final void setCookie(Iterable<? extends Cookie> setCookie) {
        this.addCookies(setCookie, HttpHeaderNames.SET_COOKIE, Cookie::toSetCookieHeaders);
    }

    Cookies setCookie() {
        return this.getCookie(HttpHeaderNames.SET_COOKIE, Cookie::fromSetCookieHeaders);
    }

    private Cookies getCookie(AsciiString cookieHeaderName, Function<List<String>, Cookies> cookiesParser) {
        Iterable cookies = (Iterable)this.cache.get(cookieHeaderName);
        if (cookies == null) {
            List<String> cookiesString = this.getAll(cookieHeaderName);
            if (cookiesString.isEmpty()) {
                Cookies emptyCookies = Cookies.of();
                this.cache.put(cookieHeaderName, emptyCookies);
                return emptyCookies;
            }
            Cookies parsedCookies = cookiesParser.apply(cookiesString);
            this.cache.put(cookieHeaderName, parsedCookies);
            return parsedCookies;
        }
        if (cookies instanceof Cookies) {
            return (Cookies)cookies;
        }
        Cookies immutableCookies = Cookies.of(cookies);
        this.cache.put(cookieHeaderName, immutableCookies);
        return immutableCookies;
    }

    private void addCookies(Iterable<Cookie> newCookies, AsciiString cookieHeaderName, Function<Iterable<? extends Cookie>, Object> toCookiesString) {
        Object cookiesString;
        Iterable<Cookie> cachedCookies = (Iterable<Cookie>)this.cache.get(cookieHeaderName);
        if (cachedCookies == null) {
            if (newCookies instanceof Cookies) {
                cachedCookies = newCookies;
            } else {
                ArrayList<Cookie> copied = new ArrayList<Cookie>(4);
                for (Cookie cookie : newCookies) {
                    copied.add(cookie);
                }
                cachedCookies = copied;
            }
        } else {
            if (cachedCookies instanceof Cookies) {
                cachedCookies = new ArrayList<Cookie>((Collection)cachedCookies);
            }
            assert (cachedCookies instanceof ArrayList);
            ArrayList cookieList = (ArrayList)cachedCookies;
            for (Cookie cookie : newCookies) {
                if (cookieList.contains(cookie)) continue;
                cookieList.add(cookie);
            }
        }
        this.cache.put(cookieHeaderName, cachedCookies);
        if (HttpHeaderNames.COOKIE.equals((Object)cookieHeaderName)) {
            cookiesString = toCookiesString.apply(cachedCookies);
            assert (cookiesString instanceof String);
            assert (cookieHeaderName.equals((Object)HttpHeaderNames.COOKIE));
            this.setWithoutNotifying(cookieHeaderName, (String)cookiesString);
        } else if (HttpHeaderNames.SET_COOKIE.equals((Object)cookieHeaderName)) {
            cookiesString = toCookiesString.apply(newCookies);
            assert (cookiesString instanceof Iterable);
            this.addWithoutNotifying(cookieHeaderName, (Iterable)cookiesString);
        } else {
            throw new Error();
        }
    }

    final void acceptLanguages(Iterable<Locale.LanguageRange> acceptLanguages) {
        StringJoiner joiner = new StringJoiner(", ");
        for (Locale.LanguageRange range : acceptLanguages) {
            if (range.getWeight() == 1.0) {
                joiner.add(range.getRange());
                continue;
            }
            joiner.add(range.getRange() + ";q=" + range.getWeight());
        }
        this.set(HttpHeaderNames.ACCEPT_LANGUAGE, joiner.toString());
    }

    @Nullable
    List<Locale.LanguageRange> acceptLanguages() {
        List<String> acceptLanguageHeaders = this.getAll(HttpHeaderNames.ACCEPT_LANGUAGE);
        if (acceptLanguageHeaders.isEmpty()) {
            return null;
        }
        try {
            ArrayList<Locale.LanguageRange> acceptLanguages = new ArrayList<Locale.LanguageRange>(4);
            for (String acceptLanguage : acceptLanguageHeaders) {
                acceptLanguages.addAll(Locale.LanguageRange.parse(acceptLanguage));
            }
            acceptLanguages.sort(Comparator.comparingDouble(Locale.LanguageRange::getWeight).reversed());
            return Collections.unmodifiableList(acceptLanguages);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Nullable
    Locale selectLocale(Iterable<Locale> supportedLocales) {
        Objects.requireNonNull(supportedLocales, "supportedLocales");
        ImmutableList<Locale> localeCollection = supportedLocales instanceof Collection ? (ImmutableList<Locale>)supportedLocales : ImmutableList.copyOf(supportedLocales);
        if (localeCollection.isEmpty()) {
            return null;
        }
        List<Locale.LanguageRange> languageRanges = this.acceptLanguages();
        if (languageRanges == null) {
            return null;
        }
        return languageRanges.stream().flatMap(it -> Locale.filter(ImmutableList.of(it), localeCollection).stream()).findFirst().orElse(null);
    }

    HttpMethod method() {
        HttpMethod method = (HttpMethod)((Object)this.cache.get(HttpHeaderNames.METHOD));
        if (method != null) {
            return method;
        }
        String methodStr = this.get(HttpHeaderNames.METHOD);
        Preconditions.checkState(methodStr != null, ":method header does not exist.");
        HttpMethod parsed = HttpMethod.isSupported(methodStr) ? HttpMethod.valueOf(methodStr) : HttpMethod.UNKNOWN;
        this.cache.put(HttpHeaderNames.METHOD, (Object)parsed);
        return parsed;
    }

    final void method(HttpMethod method) {
        Objects.requireNonNull(method, "method");
        this.cache.put(HttpHeaderNames.METHOD, (Object)method);
        this.setWithoutNotifying(HttpHeaderNames.METHOD, method.name());
    }

    @Nullable
    String scheme() {
        return this.get(HttpHeaderNames.SCHEME);
    }

    final void scheme(String scheme) {
        Objects.requireNonNull(scheme, "scheme");
        this.set(HttpHeaderNames.SCHEME, scheme);
    }

    @Nullable
    String authority() {
        String authority = this.get(HttpHeaderNames.AUTHORITY);
        return authority != null ? authority : this.get(HttpHeaderNames.HOST);
    }

    final void authority(String authority) {
        Objects.requireNonNull(authority, "authority");
        this.set(HttpHeaderNames.AUTHORITY, authority);
    }

    String path() {
        String path = this.get(HttpHeaderNames.PATH);
        Preconditions.checkState(path != null, ":path header does not exist.");
        return path;
    }

    final void path(String path) {
        Objects.requireNonNull(path, "path");
        this.set(HttpHeaderNames.PATH, path);
    }

    HttpStatus status() {
        HttpStatus status = (HttpStatus)this.cache.get(HttpHeaderNames.STATUS);
        if (status != null) {
            return status;
        }
        String statusStr = this.get(HttpHeaderNames.STATUS);
        Preconditions.checkState(statusStr != null, ":status header does not exist.");
        HttpStatus parsed = HttpStatus.valueOf(statusStr);
        this.cache.put(HttpHeaderNames.STATUS, parsed);
        return parsed;
    }

    final void status(int statusCode) {
        this.status(HttpStatus.valueOf(statusCode));
    }

    final void status(HttpStatus status) {
        Objects.requireNonNull(status, "status");
        this.cache.put(HttpHeaderNames.STATUS, status);
        this.setWithoutNotifying(HttpHeaderNames.STATUS, status.codeAsText());
    }

    final void contentLength(long contentLength) {
        Preconditions.checkArgument(contentLength >= 0L, "contentLength: %s (expected: >= 0)", contentLength);
        this.cache.put(HttpHeaderNames.CONTENT_LENGTH, contentLength);
        String contentLengthString = StringUtil.toString(contentLength);
        this.setWithoutNotifying(HttpHeaderNames.CONTENT_LENGTH, contentLengthString);
    }

    @Override
    public long contentLength() {
        Long contentLength = (Long)this.cache.get(HttpHeaderNames.CONTENT_LENGTH);
        if (contentLength != null) {
            return contentLength;
        }
        String contentLengthString = this.get(HttpHeaderNames.CONTENT_LENGTH);
        if (contentLengthString != null) {
            long parsed = Long.parseLong(contentLengthString);
            this.cache.put(HttpHeaderNames.CONTENT_LENGTH, parsed);
            return parsed;
        }
        this.cache.put(HttpHeaderNames.CONTENT_LENGTH, -1L);
        return -1L;
    }

    List<MediaType> accept() {
        List cached = (List)this.cache.get(HttpHeaderNames.ACCEPT);
        if (cached != null) {
            if (cached instanceof ImmutableList) {
                return cached;
            }
            ImmutableList<MediaType> immutableCache = ImmutableList.copyOf(cached);
            this.cache.put(HttpHeaderNames.ACCEPT, immutableCache);
            return immutableCache;
        }
        List<String> acceptHeaders = this.getAll(HttpHeaderNames.ACCEPT);
        if (acceptHeaders.isEmpty()) {
            this.cache.put(HttpHeaderNames.ACCEPT, ImmutableList.of());
            return ImmutableList.of();
        }
        ArrayList<MediaType> acceptTypes = new ArrayList<MediaType>(4);
        for (String acceptHeader : acceptHeaders) {
            for (String accept : ACCEPT_SPLITTER.split(acceptHeader)) {
                try {
                    acceptTypes.add(MediaType.parse(accept));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        if (acceptTypes.size() > 1) {
            acceptTypes.sort(HttpHeadersBase::compareMediaType);
        }
        ImmutableList<MediaType> parsed = ImmutableList.copyOf(acceptTypes);
        this.cache.put(HttpHeaderNames.ACCEPT, parsed);
        return parsed;
    }

    final void accept(Iterable<MediaType> newAcceptTypes) {
        Objects.requireNonNull(newAcceptTypes, "newAcceptTypes");
        int size = Iterables.size(newAcceptTypes);
        Preconditions.checkArgument(size > 0, "newAcceptTypes is empty");
        ArrayList cachedAcceptTypes = (ArrayList)this.cache.get(HttpHeaderNames.ACCEPT);
        if (cachedAcceptTypes == null) {
            ArrayList<MediaType> copied = new ArrayList<MediaType>(size + 2);
            for (MediaType mediaType : newAcceptTypes) {
                copied.add(mediaType);
            }
            cachedAcceptTypes = copied;
        } else {
            if (cachedAcceptTypes instanceof ImmutableList) {
                cachedAcceptTypes = new ArrayList(cachedAcceptTypes);
            }
            assert (cachedAcceptTypes instanceof ArrayList);
            ArrayList mediaTypeList = cachedAcceptTypes;
            for (MediaType newAcceptType : newAcceptTypes) {
                mediaTypeList.add(newAcceptType);
            }
        }
        if (cachedAcceptTypes.size() > 1) {
            cachedAcceptTypes.sort(HttpHeadersBase::compareMediaType);
        }
        this.cache.put(HttpHeaderNames.ACCEPT, cachedAcceptTypes);
        this.addObjectWithoutNotifying(HttpHeaderNames.ACCEPT, newAcceptTypes);
    }

    static int compareMediaType(MediaType m1, MediaType m2) {
        int qCompare = Float.compare(m2.qualityFactor(), m1.qualityFactor());
        if (qCompare != 0) {
            return qCompare;
        }
        int wildcardCompare = Integer.compare(m1.numWildcards(), m2.numWildcards());
        if (wildcardCompare != 0) {
            return wildcardCompare;
        }
        return 0;
    }

    @Override
    @Nullable
    public MediaType contentType() {
        MediaType contentType = (MediaType)this.cache.get(HttpHeaderNames.CONTENT_TYPE);
        if (contentType != null) {
            return contentType;
        }
        String contentTypeString = this.get(HttpHeaderNames.CONTENT_TYPE);
        if (contentTypeString == null) {
            return null;
        }
        try {
            MediaType parsed = MediaType.parse(contentTypeString);
            this.cache.put(HttpHeaderNames.CONTENT_TYPE, parsed);
            return parsed;
        }
        catch (IllegalArgumentException unused) {
            return null;
        }
    }

    final void contentType(MediaType contentType) {
        Objects.requireNonNull(contentType, "contentType");
        this.cache.put(HttpHeaderNames.CONTENT_TYPE, contentType);
        this.setWithoutNotifying(HttpHeaderNames.CONTENT_TYPE, contentType.toString());
    }

    @Override
    @Nullable
    public ContentDisposition contentDisposition() {
        String contentDispositionString = this.get(HttpHeaderNames.CONTENT_DISPOSITION);
        if (contentDispositionString == null) {
            return null;
        }
        try {
            return ContentDisposition.parse(contentDispositionString);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    final void contentDisposition(ContentDisposition contentDisposition) {
        Objects.requireNonNull(contentDisposition, "contentDisposition");
        this.set(HttpHeaderNames.CONTENT_DISPOSITION, contentDisposition.asHeaderValue());
    }

    @Override
    public final boolean isEndOfStream() {
        return this.endOfStream;
    }

    final void endOfStream(boolean endOfStream) {
        this.endOfStream = endOfStream;
    }

    @Override
    public final int hashCode() {
        int hashCode = super.hashCode();
        return this.endOfStream ? ~hashCode : hashCode;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HttpHeaderGetters)) {
            return false;
        }
        return this.endOfStream == ((HttpHeaderGetters)o).isEndOfStream() && super.equals(o);
    }

    @Override
    public final String toString() {
        if (this.size == 0) {
            return this.endOfStream ? "[EOS]" : "[]";
        }
        StringBuilder sb = new StringBuilder(7 + this.size * 20);
        if (this.endOfStream) {
            sb.append("[EOS, ");
        } else {
            sb.append('[');
        }
        for (Map.Entry e : this) {
            sb.append((CharSequence)e.getKey()).append('=').append(e.getValue()).append(", ");
        }
        int length = sb.length();
        sb.setCharAt(length - 2, ']');
        return sb.substring(0, length - 1);
    }

    static {
        PROHIBITED_VALUE_CHARS.set(0);
        PROHIBITED_VALUE_CHARS.set(10);
        PROHIBITED_VALUE_CHARS.set(11);
        PROHIBITED_VALUE_CHARS.set(12);
        PROHIBITED_VALUE_CHARS.set(13);
        LAST_PROHIBITED_VALUE_CHAR = (char)(PROHIBITED_VALUE_CHARS.size() - 1);
        PROHIBITED_VALUE_CHAR_NAMES = new String[PROHIBITED_VALUE_CHARS.size()];
        HttpHeadersBase.PROHIBITED_VALUE_CHAR_NAMES[0] = "<NUL>";
        HttpHeadersBase.PROHIBITED_VALUE_CHAR_NAMES[10] = "<LF>";
        HttpHeadersBase.PROHIBITED_VALUE_CHAR_NAMES[11] = "<VT>";
        HttpHeadersBase.PROHIBITED_VALUE_CHAR_NAMES[12] = "<FF>";
        HttpHeadersBase.PROHIBITED_VALUE_CHAR_NAMES[13] = "<CR>";
    }
}

