/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.circuitbreaker;

import com.linecorp.armeria.client.circuitbreaker.EventCount;
import com.linecorp.armeria.client.circuitbreaker.EventCounter;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.Ticker;
import java.time.Duration;
import java.util.Iterator;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;

final class SlidingWindowCounter
implements EventCounter {
    private final Ticker ticker;
    private final long slidingWindowNanos;
    private final long updateIntervalNanos;
    private final AtomicReference<Bucket> current;
    private final AtomicReference<EventCount> snapshot = new AtomicReference<EventCount>(EventCount.ZERO);
    private final Queue<Bucket> reservoir = new ConcurrentLinkedQueue<Bucket>();

    SlidingWindowCounter(Ticker ticker, Duration slidingWindow, Duration updateInterval) {
        this.ticker = Objects.requireNonNull(ticker, "ticker");
        this.slidingWindowNanos = Objects.requireNonNull(slidingWindow, "slidingWindow").toNanos();
        this.updateIntervalNanos = Objects.requireNonNull(updateInterval, "updateInterval").toNanos();
        this.current = new AtomicReference<Bucket>(new Bucket(ticker.read()));
    }

    @Override
    public EventCount count() {
        return this.snapshot.get();
    }

    @Override
    public EventCount onSuccess() {
        return this.onEvent(Event.SUCCESS);
    }

    @Override
    public EventCount onFailure() {
        return this.onEvent(Event.FAILURE);
    }

    @Nullable
    private EventCount onEvent(Event event) {
        Bucket currentBucket;
        long tickerNanos = this.ticker.read();
        if (tickerNanos < (currentBucket = this.current.get()).timestamp()) {
            Bucket bucket = new Bucket(tickerNanos);
            event.increment(bucket);
            this.reservoir.offer(bucket);
            return null;
        }
        if (tickerNanos < currentBucket.timestamp() + this.updateIntervalNanos) {
            event.increment(currentBucket);
            return null;
        }
        Bucket nextBucket = new Bucket(tickerNanos);
        event.increment(nextBucket);
        if (this.current.compareAndSet(currentBucket, nextBucket)) {
            this.reservoir.offer(currentBucket);
            EventCount eventCount = this.trimAndSum(tickerNanos);
            this.snapshot.set(eventCount);
            return eventCount;
        }
        this.reservoir.offer(nextBucket);
        return null;
    }

    private EventCount trimAndSum(long tickerNanos) {
        long oldLimit = tickerNanos - this.slidingWindowNanos;
        Iterator iterator = this.reservoir.iterator();
        long success = 0L;
        long failure = 0L;
        while (iterator.hasNext()) {
            Bucket bucket = (Bucket)iterator.next();
            if (bucket.timestamp < oldLimit) {
                iterator.remove();
                continue;
            }
            success += bucket.success();
            failure += bucket.failure();
        }
        return EventCount.of(success, failure);
    }

    private static final class Bucket {
        private final long timestamp;
        private final LongAdder success = new LongAdder();
        private final LongAdder failure = new LongAdder();

        private Bucket(long timestamp) {
            this.timestamp = timestamp;
        }

        private long timestamp() {
            return this.timestamp;
        }

        private long success() {
            return this.success.sum();
        }

        private long failure() {
            return this.failure.sum();
        }

        public String toString() {
            return "Bucket{timestamp=" + this.timestamp + ", success=" + this.success + ", failure=" + this.failure + '}';
        }
    }

    private static enum Event {
        SUCCESS{

            @Override
            void increment(Bucket bucket) {
                bucket.success.increment();
            }
        }
        ,
        FAILURE{

            @Override
            void increment(Bucket bucket) {
                bucket.failure.increment();
            }
        };


        abstract void increment(Bucket var1);
    }
}

