/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.errorprone.annotations.FormatMethod;
import com.google.errorprone.annotations.FormatString;
import com.linecorp.armeria.client.RequestOptions;
import com.linecorp.armeria.client.RequestPreparationSetters;
import com.linecorp.armeria.client.ResponseAs;
import com.linecorp.armeria.client.WebClient;
import com.linecorp.armeria.client.WebClientRequestPreparation;
import com.linecorp.armeria.common.Cookie;
import com.linecorp.armeria.common.ExchangeType;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.ResponseEntity;
import com.linecorp.armeria.common.annotation.Nullable;
import io.netty.util.AttributeKey;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Publisher;

public final class RestClientPreparation
implements RequestPreparationSetters {
    private final WebClientRequestPreparation delegate;

    RestClientPreparation(WebClient client, HttpMethod method, String path) {
        this.delegate = client.prepare();
        this.delegate.method(method);
        this.delegate.path(path);
    }

    public <T> CompletableFuture<ResponseEntity<T>> execute(Class<? extends T> clazz) {
        Objects.requireNonNull(clazz, "clazz");
        Object response = this.delegate.asJson(clazz).execute();
        return (CompletableFuture)RestClientPreparation.cast(response);
    }

    public <T> CompletableFuture<ResponseEntity<T>> execute(Class<? extends T> clazz, ObjectMapper mapper) {
        Objects.requireNonNull(clazz, "clazz");
        Objects.requireNonNull(mapper, "mapper");
        Object response = this.delegate.asJson(clazz, mapper).execute();
        return (CompletableFuture)RestClientPreparation.cast(response);
    }

    public <T> CompletableFuture<ResponseEntity<T>> execute(TypeReference<? extends T> typeRef) {
        Objects.requireNonNull(typeRef, "typeRef");
        Object response = this.delegate.asJson(typeRef).execute();
        return (CompletableFuture)RestClientPreparation.cast(response);
    }

    public <T> CompletableFuture<ResponseEntity<T>> execute(TypeReference<? extends T> typeRef, ObjectMapper mapper) {
        Objects.requireNonNull(typeRef, "typeRef");
        Objects.requireNonNull(mapper, "mapper");
        Object response = this.delegate.asJson(typeRef, mapper).execute();
        return (CompletableFuture)RestClientPreparation.cast(response);
    }

    public <T> T execute(ResponseAs<HttpResponse, T> responseAs) {
        Objects.requireNonNull(responseAs, "responseAs");
        return this.delegate.as(responseAs).execute();
    }

    private static <T> T cast(Object any) {
        return (T)any;
    }

    @Override
    public RestClientPreparation pathParam(String name, Object value) {
        this.delegate.pathParam(name, value);
        return this;
    }

    @Override
    public RestClientPreparation pathParams(Map<String, ?> pathParams) {
        this.delegate.pathParams((Map)pathParams);
        return this;
    }

    @Override
    public RestClientPreparation disablePathParams() {
        this.delegate.disablePathParams();
        return this;
    }

    @Override
    public RestClientPreparation queryParam(String name, Object value) {
        this.delegate.queryParam(name, value);
        return this;
    }

    @Override
    public RestClientPreparation queryParams(Iterable<? extends Map.Entry<? extends String, String>> queryParams) {
        this.delegate.queryParams((Iterable)queryParams);
        return this;
    }

    @Override
    public RestClientPreparation content(String content) {
        this.delegate.content(content);
        return this;
    }

    @Override
    public RestClientPreparation content(MediaType contentType, CharSequence content) {
        this.delegate.content(contentType, content);
        return this;
    }

    @Override
    public RestClientPreparation content(MediaType contentType, String content) {
        this.delegate.content(contentType, content);
        return this;
    }

    @Override
    @FormatMethod
    public RestClientPreparation content(@FormatString String format, Object ... content) {
        this.delegate.content(format, content);
        return this;
    }

    @Override
    @FormatMethod
    public RestClientPreparation content(MediaType contentType, @FormatString String format, Object ... content) {
        this.delegate.content(contentType, format, content);
        return this;
    }

    @Override
    public RestClientPreparation content(MediaType contentType, byte[] content) {
        this.delegate.content(contentType, content);
        return this;
    }

    @Override
    public RestClientPreparation content(MediaType contentType, HttpData content) {
        this.delegate.content(contentType, content);
        return this;
    }

    @Override
    public RestClientPreparation content(MediaType contentType, Publisher<? extends HttpData> content) {
        this.delegate.content(contentType, (Publisher)content);
        return this;
    }

    @Override
    public RestClientPreparation contentJson(Object content) {
        this.delegate.contentJson(content);
        return this;
    }

    @Override
    public RestClientPreparation header(CharSequence name, Object value) {
        this.delegate.header(name, value);
        return this;
    }

    @Override
    public RestClientPreparation headers(Iterable<? extends Map.Entry<? extends CharSequence, String>> headers) {
        this.delegate.headers((Iterable)headers);
        return this;
    }

    @Override
    public RestClientPreparation trailer(CharSequence name, Object value) {
        this.delegate.trailer(name, value);
        return this;
    }

    @Override
    public RestClientPreparation trailers(Iterable<? extends Map.Entry<? extends CharSequence, String>> trailers) {
        this.delegate.trailers((Iterable)trailers);
        return this;
    }

    @Override
    public RestClientPreparation cookie(Cookie cookie) {
        this.delegate.cookie(cookie);
        return this;
    }

    @Override
    public RestClientPreparation cookies(Iterable<? extends Cookie> cookies) {
        this.delegate.cookies((Iterable)cookies);
        return this;
    }

    @Override
    public RestClientPreparation responseTimeout(Duration responseTimeout) {
        this.delegate.responseTimeout(responseTimeout);
        return this;
    }

    @Override
    public RestClientPreparation responseTimeoutMillis(long responseTimeoutMillis) {
        this.delegate.responseTimeoutMillis(responseTimeoutMillis);
        return this;
    }

    @Override
    public RestClientPreparation writeTimeout(Duration writeTimeout) {
        this.delegate.writeTimeout(writeTimeout);
        return this;
    }

    @Override
    public RestClientPreparation writeTimeoutMillis(long writeTimeoutMillis) {
        this.delegate.writeTimeoutMillis(writeTimeoutMillis);
        return this;
    }

    @Override
    public RestClientPreparation maxResponseLength(long maxResponseLength) {
        this.delegate.maxResponseLength(maxResponseLength);
        return this;
    }

    @Override
    public RestClientPreparation requestAutoAbortDelay(Duration delay) {
        this.delegate.requestAutoAbortDelay(delay);
        return this;
    }

    @Override
    public RestClientPreparation requestAutoAbortDelayMillis(long delayMillis) {
        this.delegate.requestAutoAbortDelayMillis(delayMillis);
        return this;
    }

    @Override
    public <V> RestClientPreparation attr(AttributeKey<V> key, @Nullable V value) {
        this.delegate.attr((AttributeKey)key, (Object)value);
        return this;
    }

    @Override
    public RestClientPreparation exchangeType(ExchangeType exchangeType) {
        this.delegate.exchangeType(exchangeType);
        return this;
    }

    @Override
    public RestClientPreparation requestOptions(RequestOptions requestOptions) {
        this.delegate.requestOptions(requestOptions);
        return this;
    }
}

