/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.AbstractHttpRequestHandler;
import com.linecorp.armeria.client.ClientHttpObjectEncoder;
import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.HttpResponseDecoder;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpObject;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.client.DecodedHttpResponse;
import com.linecorp.armeria.unsafe.PooledObjects;
import io.netty.channel.Channel;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class HttpRequestSubscriber
extends AbstractHttpRequestHandler
implements Subscriber<HttpObject> {
    private static final HttpData EMPTY_EOS = HttpData.empty().withEndOfStream();
    private final HttpRequest request;
    @Nullable
    private Subscription subscription;
    private boolean isSubscriptionCompleted;

    HttpRequestSubscriber(Channel ch, ClientHttpObjectEncoder encoder, HttpResponseDecoder responseDecoder, HttpRequest request, DecodedHttpResponse originalRes, ClientRequestContext ctx, long timeoutMillis) {
        super(ch, encoder, responseDecoder, originalRes, ctx, timeoutMillis, request.isEmpty());
        this.request = request;
    }

    public void onSubscribe(Subscription subscription) {
        assert (this.subscription == null);
        this.subscription = subscription;
        if (this.state() == AbstractHttpRequestHandler.State.DONE) {
            this.cancel();
            return;
        }
        if (!this.tryInitialize()) {
            return;
        }
        this.writeHeaders(this.request.headers());
        this.channel().flush();
    }

    public void onNext(HttpObject o) {
        if (!(o instanceof HttpData) && !(o instanceof HttpHeaders)) {
            this.failAndReset(new IllegalArgumentException("published an HttpObject that's neither Http2Headers nor Http2Data: " + o));
            return;
        }
        switch (this.state()) {
            case NEEDS_DATA_OR_TRAILERS: {
                if (o instanceof HttpHeaders) {
                    HttpHeaders trailers = (HttpHeaders)o;
                    if (trailers.contains((CharSequence)HttpHeaderNames.STATUS)) {
                        this.failAndReset(new IllegalArgumentException("published a trailers with status: " + o));
                        return;
                    }
                    this.writeTrailers(trailers);
                } else {
                    this.writeData((HttpData)o);
                }
                this.channel().flush();
                break;
            }
            case DONE: {
                this.cancel();
                PooledObjects.close(o);
            }
        }
    }

    public void onError(Throwable cause) {
        this.isSubscriptionCompleted = true;
        this.failRequest(cause);
    }

    public void onComplete() {
        this.isSubscriptionCompleted = true;
        if (this.state() != AbstractHttpRequestHandler.State.DONE) {
            this.writeData(EMPTY_EOS);
            this.channel().flush();
        }
    }

    @Override
    void onWriteSuccess() {
        if (!this.isSubscriptionCompleted) {
            assert (this.subscription != null);
            this.subscription.request(1L);
        }
    }

    @Override
    void cancel() {
        this.isSubscriptionCompleted = true;
        assert (this.subscription != null);
        this.subscription.cancel();
    }
}

