/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.query.promql.rt;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.skywalking.oap.query.graphql.resolver.MetricsQuery;
import org.apache.skywalking.oap.query.graphql.resolver.RecordsQuery;
import org.apache.skywalking.oap.query.promql.entity.ErrorType;
import org.apache.skywalking.oap.query.promql.entity.LabelName;
import org.apache.skywalking.oap.query.promql.entity.LabelValuePair;
import org.apache.skywalking.oap.query.promql.entity.MetricInfo;
import org.apache.skywalking.oap.query.promql.entity.MetricRangeData;
import org.apache.skywalking.oap.query.promql.handler.PromQLApiHandler;
import org.apache.skywalking.oap.query.promql.rt.PromOpUtils;
import org.apache.skywalking.oap.query.promql.rt.exception.IllegalExpressionException;
import org.apache.skywalking.oap.query.promql.rt.result.MetricsRangeResult;
import org.apache.skywalking.oap.query.promql.rt.result.ParseResult;
import org.apache.skywalking.oap.query.promql.rt.result.ParseResultType;
import org.apache.skywalking.oap.query.promql.rt.result.ScalarResult;
import org.apache.skywalking.oap.server.core.analysis.Layer;
import org.apache.skywalking.oap.server.core.query.DurationUtils;
import org.apache.skywalking.oap.server.core.query.enumeration.Order;
import org.apache.skywalking.oap.server.core.query.enumeration.Scope;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.input.Entity;
import org.apache.skywalking.oap.server.core.query.input.MetricsCondition;
import org.apache.skywalking.oap.server.core.query.input.RecordCondition;
import org.apache.skywalking.oap.server.core.query.input.TopNCondition;
import org.apache.skywalking.oap.server.core.query.type.MetricsValues;
import org.apache.skywalking.oap.server.core.query.type.Record;
import org.apache.skywalking.oap.server.core.query.type.SelectedRecord;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.annotation.ValueColumnMetadata;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.promql.rt.grammar.PromQLParser;
import org.apache.skywalking.promql.rt.grammar.PromQLParserBaseVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PromQLExprQueryVisitor
extends PromQLParserBaseVisitor<ParseResult> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PromQLExprQueryVisitor.class);
    private final MetricsQuery metricsQuery;
    private final RecordsQuery recordsQuery;
    private final PromQLApiHandler.QueryType queryType;
    private Duration duration;

    public PromQLExprQueryVisitor(MetricsQuery metricsQuery, RecordsQuery recordsQuery, Duration duration, PromQLApiHandler.QueryType queryType) {
        this.metricsQuery = metricsQuery;
        this.recordsQuery = recordsQuery;
        this.duration = duration;
        this.queryType = queryType;
    }

    @Override
    public ParseResult visitAddSubOp(PromQLParser.AddSubOpContext ctx) {
        ParseResult left = (ParseResult)this.visit((ParseTree)ctx.expression(0));
        if (StringUtil.isNotBlank((String)left.getErrorInfo())) {
            return left;
        }
        ParseResult right = (ParseResult)this.visit((ParseTree)ctx.expression(1));
        if (StringUtil.isNotBlank((String)right.getErrorInfo())) {
            return right;
        }
        int opType = ctx.addSub().getStart().getType();
        return this.binaryOp(left, right, opType);
    }

    @Override
    public ParseResult visitMulDivModOp(PromQLParser.MulDivModOpContext ctx) {
        ParseResult left = (ParseResult)this.visit((ParseTree)ctx.expression(0));
        if (StringUtil.isNotBlank((String)left.getErrorInfo())) {
            return left;
        }
        ParseResult right = (ParseResult)this.visit((ParseTree)ctx.expression(1));
        if (StringUtil.isNotBlank((String)right.getErrorInfo())) {
            return right;
        }
        int opType = ctx.mulDivMod().getStart().getType();
        return this.binaryOp(left, right, opType);
    }

    @Override
    public ParseResult visitCompareOp(PromQLParser.CompareOpContext ctx) {
        ParseResult left = (ParseResult)this.visit((ParseTree)ctx.expression(0));
        if (StringUtil.isNotBlank((String)left.getErrorInfo())) {
            return left;
        }
        ParseResult right = (ParseResult)this.visit((ParseTree)ctx.expression(1));
        if (StringUtil.isNotBlank((String)right.getErrorInfo())) {
            return right;
        }
        boolean boolModifier = ctx.compare().BOOL() != null;
        int opType = ctx.compare().getStart().getType();
        return this.compareOp(left, right, opType, boolModifier);
    }

    private ParseResult compareOp(ParseResult left, ParseResult right, int opType, boolean boolModifier) {
        try {
            if (left.getResultType() == ParseResultType.SCALAR && right.getResultType() == ParseResultType.SCALAR) {
                if (!boolModifier) {
                    throw new IllegalExpressionException("Comparisons between scalars must use BOOL modifier.");
                }
                ScalarResult scalarLeft = (ScalarResult)left;
                ScalarResult scalarRight = (ScalarResult)right;
                int value = PromOpUtils.scalarCompareOp(scalarLeft.getValue(), scalarRight.getValue(), opType);
                ScalarResult scalarResult = new ScalarResult();
                scalarResult.setValue(value);
                scalarResult.setResultType(ParseResultType.SCALAR);
                return scalarResult;
            }
            if (left.getResultType() == ParseResultType.METRICS_RANGE && right.getResultType() == ParseResultType.SCALAR) {
                return PromOpUtils.matrixScalarCompareOp((MetricsRangeResult)left, (ScalarResult)right, opType);
            }
            if (left.getResultType() == ParseResultType.SCALAR && right.getResultType() == ParseResultType.METRICS_RANGE) {
                return PromOpUtils.matrixScalarCompareOp((MetricsRangeResult)right, (ScalarResult)left, opType);
            }
            if (left.getResultType() == ParseResultType.METRICS_RANGE && right.getResultType() == ParseResultType.METRICS_RANGE) {
                try {
                    return PromOpUtils.matrixCompareOp((MetricsRangeResult)left, (MetricsRangeResult)right, opType);
                }
                catch (IllegalExpressionException e) {
                    MetricsRangeResult result = new MetricsRangeResult();
                    result.setErrorType(ErrorType.BAD_DATA);
                    result.setErrorInfo(e.getMessage());
                    return result;
                }
            }
        }
        catch (IllegalExpressionException e) {
            MetricsRangeResult result = new MetricsRangeResult();
            result.setErrorType(ErrorType.BAD_DATA);
            result.setErrorInfo(e.getMessage());
            return result;
        }
        return new ParseResult();
    }

    @Override
    public ParseResult visitNumberLiteral(PromQLParser.NumberLiteralContext ctx) {
        ScalarResult result = new ScalarResult();
        double value = Double.parseDouble(ctx.NUMBER().getText());
        result.setValue(value);
        result.setResultType(ParseResultType.SCALAR);
        return result;
    }

    @Override
    public ParseResult visitMetricInstant(PromQLParser.MetricInstantContext ctx) {
        ParseResult result = new ParseResult();
        try {
            Layer layer;
            String metricName = ctx.metricName().getText();
            Optional<ValueColumnMetadata.ValueColumn> valueColumn = this.getValueColumn(metricName);
            if (valueColumn.isEmpty()) {
                result.setErrorType(ErrorType.BAD_DATA);
                result.setErrorInfo("Metric: [" + metricName + "] dose not exist.");
                return result;
            }
            if (ctx.labelList() == null) {
                result.setErrorType(ErrorType.BAD_DATA);
                result.setErrorInfo("No labels found in the expression.");
                return result;
            }
            HashMap<LabelName, String> labelMap = new HashMap<LabelName, String>();
            for (PromQLParser.LabelContext labelCtx : ctx.labelList().label()) {
                String labelName = labelCtx.labelName().getText();
                String labelValue = labelCtx.labelValue().getText();
                String labelValueTrim = labelValue.substring(1, labelValue.length() - 1);
                try {
                    labelMap.put(LabelName.labelOf(labelName), labelValueTrim);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalExpressionException("Label:[" + labelName + "] is illegal.");
                }
            }
            this.checkLabels(labelMap, LabelName.LAYER);
            try {
                layer = Layer.valueOf((String)((String)labelMap.get((Object)LabelName.LAYER)));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalExpressionException("Layer:[" + (String)labelMap.get((Object)LabelName.LAYER) + "] is missing or illegal.");
            }
            ValueColumnMetadata.ValueColumn metaData = valueColumn.get();
            Scope scope = Scope.Finder.valueOf((int)metaData.getScopeId());
            Column.ValueDataType dataType = metaData.getDataType();
            MetricsRangeResult matrixResult = new MetricsRangeResult();
            matrixResult.setResultType(ParseResultType.METRICS_RANGE);
            if (StringUtil.isNotBlank((String)((String)labelMap.get((Object)LabelName.TOP_N)))) {
                if (Column.ValueDataType.SAMPLED_RECORD == dataType) {
                    this.queryRecords(metricName, layer, scope, labelMap, matrixResult);
                } else {
                    this.queryTopN(metricName, layer, scope, labelMap, matrixResult);
                }
            } else if (Column.ValueDataType.COMMON_VALUE == dataType) {
                this.metricsValuesQuery(metricName, layer, scope, labelMap, matrixResult);
            } else if (Column.ValueDataType.LABELED_VALUE == dataType) {
                this.labeledMetricsValuesQuery(metricName, layer, scope, labelMap, matrixResult);
            }
            return matrixResult;
        }
        catch (IllegalExpressionException e) {
            result.setErrorType(ErrorType.BAD_DATA);
            result.setErrorInfo(e.getMessage());
            return result;
        }
        catch (IOException e) {
            result.setErrorType(ErrorType.INTERNAL);
            result.setErrorInfo("Internal IO exception.");
            log.error("Query metrics error.", (Throwable)e);
            return result;
        }
    }

    @Override
    public ParseResult visitMetricRange(PromQLParser.MetricRangeContext ctx) {
        if (PromQLApiHandler.QueryType.RANGE == this.queryType) {
            ParseResult result = new ParseResult();
            result.setErrorType(ErrorType.BAD_DATA);
            result.setErrorInfo("Range expression should use instant query.");
            return result;
        }
        String timeRange = ctx.DURATION().getText().toUpperCase();
        long endTS = System.currentTimeMillis();
        long startTS = endTS - PromOpUtils.formatDuration(timeRange).getMillis();
        this.duration = DurationUtils.timestamp2Duration((long)startTS, (long)endTS);
        ParseResult result = (ParseResult)this.visit((ParseTree)ctx.metricInstant());
        result.setRangeExpression(true);
        return result;
    }

    private void checkLabels(Map<LabelName, String> labelMap, LabelName ... labelNames) throws IllegalExpressionException {
        StringBuilder missLabels = new StringBuilder();
        int j = 0;
        for (LabelName name : labelNames) {
            String labelName = name.toString();
            if (labelMap.get((Object)name) != null) continue;
            missLabels.append(j++ > 0 ? "," : "").append(labelName);
        }
        String result = missLabels.toString();
        if (StringUtil.isNotBlank((String)result)) {
            throw new IllegalExpressionException("Metrics expression missing label: " + result);
        }
    }

    private void queryTopN(String metricName, Layer layer, Scope scope, Map<LabelName, String> labelMap, MetricsRangeResult matrixResult) throws IOException, IllegalExpressionException {
        TopNCondition topNCondition = this.buildTopNCondition(metricName, layer, scope, labelMap);
        List selectedRecords = this.metricsQuery.sortMetrics(topNCondition, this.duration);
        for (SelectedRecord selectedRecord : selectedRecords) {
            MetricRangeData metricData = new MetricRangeData();
            MetricInfo metricInfo = this.buildMetricInfo(metricName, layer, scope, labelMap, Optional.empty(), Optional.ofNullable(selectedRecord.getName()), Optional.empty());
            metricData.setMetric(metricInfo);
            metricData.setValues(PromOpUtils.buildMatrixValues(this.duration, String.valueOf(selectedRecord.getValue())));
            matrixResult.getMetricDataList().add(metricData);
        }
    }

    private void queryRecords(String metricName, Layer layer, Scope scope, Map<LabelName, String> labelMap, MetricsRangeResult matrixResult) throws IOException, IllegalExpressionException {
        RecordCondition recordCondition = this.buildRecordCondition(metricName, layer, scope, labelMap);
        List records = this.recordsQuery.readRecords(recordCondition, this.duration);
        for (Record record : records) {
            MetricRangeData metricData = new MetricRangeData();
            MetricInfo metricInfo = this.buildMetricInfo(metricName, layer, scope, labelMap, Optional.empty(), Optional.empty(), Optional.ofNullable(record.getName()));
            metricData.setMetric(metricInfo);
            metricData.setValues(PromOpUtils.buildMatrixValues(this.duration, String.valueOf(record.getValue())));
            matrixResult.getMetricDataList().add(metricData);
        }
    }

    private void metricsValuesQuery(String metricName, Layer layer, Scope scope, Map<LabelName, String> labelMap, MetricsRangeResult matrixResult) throws IOException, IllegalExpressionException {
        MetricsCondition metricsCondition = this.buildMetricsCondition(metricName, layer, scope, labelMap);
        MetricsValues metricsValues = this.metricsQuery.readMetricsValues(metricsCondition, this.duration);
        MetricRangeData metricData = new MetricRangeData();
        MetricInfo metricInfo = this.buildMetricInfo(metricName, layer, scope, labelMap, Optional.empty(), Optional.empty(), Optional.empty());
        metricData.setMetric(metricInfo);
        metricData.setValues(PromOpUtils.buildMatrixValues(this.duration, metricsValues));
        matrixResult.getMetricDataList().add(metricData);
    }

    private void labeledMetricsValuesQuery(String metricName, Layer layer, Scope scope, Map<LabelName, String> labelMap, MetricsRangeResult matrixResult) throws IOException, IllegalExpressionException {
        MetricsCondition metricsCondition = this.buildMetricsCondition(metricName, layer, scope, labelMap);
        HashMap<String, String> relabelMap = new HashMap<String, String>();
        String queryLabels = labelMap.get((Object)LabelName.LABELS);
        List<Object> queryLabelList = Collections.emptyList();
        if (StringUtil.isNotBlank((String)queryLabels)) {
            queryLabelList = Arrays.asList(queryLabels.split(","));
            String relabels = labelMap.get((Object)LabelName.RELABELS);
            List<Object> relabelList = Collections.emptyList();
            if (StringUtil.isNotBlank((String)relabels)) {
                relabelList = Arrays.asList(relabels.split(","));
            }
            for (int i = 0; i < queryLabelList.size(); ++i) {
                if (relabelList.size() > i) {
                    relabelMap.put((String)queryLabelList.get(i), (String)relabelList.get(i));
                    continue;
                }
                relabelMap.put((String)queryLabelList.get(i), (String)queryLabelList.get(i));
            }
        }
        List metricsValuesList = this.metricsQuery.readLabeledMetricsValues(metricsCondition, queryLabelList, this.duration);
        for (MetricsValues metricsValues : metricsValuesList) {
            MetricRangeData metricData = new MetricRangeData();
            MetricInfo metricInfo = this.buildMetricInfo(metricName, layer, scope, labelMap, Optional.ofNullable(relabelMap.getOrDefault(metricsValues.getLabel(), metricsValues.getLabel())), Optional.empty(), Optional.empty());
            metricData.setMetric(metricInfo);
            metricData.setValues(PromOpUtils.buildMatrixValues(this.duration, metricsValues));
            matrixResult.getMetricDataList().add(metricData);
        }
    }

    private ParseResult binaryOp(ParseResult left, ParseResult right, int opType) {
        if (left.getResultType() == ParseResultType.SCALAR && right.getResultType() == ParseResultType.SCALAR) {
            ScalarResult scalarLeft = (ScalarResult)left;
            ScalarResult scalarRight = (ScalarResult)right;
            double value = PromOpUtils.scalarBinaryOp(scalarLeft.getValue(), scalarRight.getValue(), opType);
            ScalarResult scalarResult = new ScalarResult();
            scalarResult.setValue(value);
            scalarResult.setResultType(ParseResultType.SCALAR);
            return scalarResult;
        }
        if (left.getResultType() == ParseResultType.METRICS_RANGE && right.getResultType() == ParseResultType.SCALAR) {
            return PromOpUtils.matrixScalarBinaryOp((MetricsRangeResult)left, (ScalarResult)right, opType);
        }
        if (left.getResultType() == ParseResultType.SCALAR && right.getResultType() == ParseResultType.METRICS_RANGE) {
            return PromOpUtils.matrixScalarBinaryOp((MetricsRangeResult)right, (ScalarResult)left, opType);
        }
        if (left.getResultType() == ParseResultType.METRICS_RANGE && right.getResultType() == ParseResultType.METRICS_RANGE) {
            try {
                return PromOpUtils.matrixBinaryOp((MetricsRangeResult)left, (MetricsRangeResult)right, opType);
            }
            catch (IllegalExpressionException e) {
                MetricsRangeResult result = new MetricsRangeResult();
                result.setErrorType(ErrorType.BAD_DATA);
                result.setErrorInfo(e.getMessage());
                return result;
            }
        }
        return new ParseResult();
    }

    private Entity buildEntity(Layer layer, Scope scope, String serviceName, Map<LabelName, String> labelMap) throws IllegalExpressionException {
        Entity entity = new Entity();
        entity.setScope(scope);
        entity.setNormal(Boolean.valueOf(layer.isNormal()));
        entity.setServiceName(serviceName);
        switch (scope) {
            case ServiceInstance: {
                this.checkLabels(labelMap, LabelName.SERVICE_INSTANCE);
                entity.setServiceInstanceName(labelMap.get((Object)LabelName.SERVICE_INSTANCE));
                break;
            }
            case Endpoint: {
                this.checkLabels(labelMap, LabelName.ENDPOINT);
                entity.setEndpointName(labelMap.get((Object)LabelName.ENDPOINT));
            }
        }
        return entity;
    }

    private TopNCondition buildTopNCondition(String metricName, Layer layer, Scope scope, Map<LabelName, String> labelMap) throws IllegalExpressionException {
        this.checkLabels(labelMap, LabelName.TOP_N, LabelName.ORDER);
        TopNCondition topNCondition = new TopNCondition();
        topNCondition.setName(metricName);
        topNCondition.setParentService(labelMap.get((Object)LabelName.PARENT_SERVICE));
        topNCondition.setTopN(Integer.parseInt(labelMap.get((Object)LabelName.TOP_N)));
        topNCondition.setOrder(Order.valueOf((String)labelMap.get((Object)LabelName.ORDER)));
        topNCondition.setNormal(layer.isNormal());
        topNCondition.setScope(scope);
        return topNCondition;
    }

    private RecordCondition buildRecordCondition(String metricName, Layer layer, Scope scope, Map<LabelName, String> labelMap) throws IllegalExpressionException {
        this.checkLabels(labelMap, LabelName.TOP_N, LabelName.PARENT_SERVICE, LabelName.ORDER);
        String parentServiceName = labelMap.get((Object)LabelName.PARENT_SERVICE);
        RecordCondition recordCondition = new RecordCondition();
        recordCondition.setName(metricName);
        recordCondition.setParentEntity(this.buildEntity(layer, scope, parentServiceName, labelMap));
        recordCondition.setTopN(Integer.parseInt(labelMap.get((Object)LabelName.TOP_N)));
        recordCondition.setOrder(Order.valueOf((String)labelMap.get((Object)LabelName.ORDER)));
        return recordCondition;
    }

    private MetricsCondition buildMetricsCondition(String metricName, Layer layer, Scope scope, Map<LabelName, String> labelMap) throws IllegalExpressionException {
        this.checkLabels(labelMap, LabelName.SERVICE);
        String serviceName = labelMap.get((Object)LabelName.SERVICE);
        MetricsCondition metricsCondition = new MetricsCondition();
        metricsCondition.setEntity(this.buildEntity(layer, scope, serviceName, labelMap));
        metricsCondition.setName(metricName);
        return metricsCondition;
    }

    private MetricInfo buildMetricInfo(String metricName, Layer layer, Scope scope, Map<LabelName, String> labelMap, Optional<String> valueLabel, Optional<String> topNEntityName, Optional<String> recordName) throws IllegalExpressionException {
        MetricInfo metricInfo = new MetricInfo(metricName);
        valueLabel.ifPresent(s -> metricInfo.getLabels().add(new LabelValuePair(LabelName.LABEL, (String)s)));
        metricInfo.getLabels().add(new LabelValuePair(LabelName.LAYER, layer.name()));
        switch (scope) {
            case Service: {
                metricInfo.getLabels().add(new LabelValuePair(LabelName.SCOPE, Scope.Service.name()));
                if (topNEntityName.isPresent()) {
                    metricInfo.getLabels().add(new LabelValuePair(LabelName.SERVICE, topNEntityName.get()));
                    break;
                }
                if (recordName.isPresent()) {
                    metricInfo.getLabels().add(new LabelValuePair(LabelName.RECORD, recordName.get()));
                    break;
                }
                this.checkLabels(labelMap, LabelName.SERVICE);
                metricInfo.getLabels().add(new LabelValuePair(LabelName.SERVICE, labelMap.get((Object)LabelName.SERVICE)));
                break;
            }
            case ServiceInstance: {
                metricInfo.getLabels().add(new LabelValuePair(LabelName.SCOPE, Scope.ServiceInstance.name()));
                if (topNEntityName.isPresent()) {
                    metricInfo.getLabels().add(new LabelValuePair(LabelName.SERVICE_INSTANCE, topNEntityName.get()));
                    break;
                }
                if (recordName.isPresent()) {
                    metricInfo.getLabels().add(new LabelValuePair(LabelName.RECORD, recordName.get()));
                    break;
                }
                this.checkLabels(labelMap, LabelName.SERVICE, LabelName.SERVICE_INSTANCE);
                metricInfo.getLabels().add(new LabelValuePair(LabelName.SERVICE, labelMap.get((Object)LabelName.SERVICE)));
                metricInfo.getLabels().add(new LabelValuePair(LabelName.SERVICE_INSTANCE, labelMap.get((Object)LabelName.SERVICE_INSTANCE)));
                break;
            }
            case Endpoint: {
                metricInfo.getLabels().add(new LabelValuePair(LabelName.SCOPE, Scope.Endpoint.name()));
                if (topNEntityName.isPresent()) {
                    metricInfo.getLabels().add(new LabelValuePair(LabelName.ENDPOINT, topNEntityName.get()));
                    break;
                }
                if (recordName.isPresent()) {
                    metricInfo.getLabels().add(new LabelValuePair(LabelName.RECORD, recordName.get()));
                    break;
                }
                this.checkLabels(labelMap, LabelName.SERVICE, LabelName.ENDPOINT);
                metricInfo.getLabels().add(new LabelValuePair(LabelName.SERVICE, labelMap.get((Object)LabelName.SERVICE)));
                metricInfo.getLabels().add(new LabelValuePair(LabelName.ENDPOINT, labelMap.get((Object)LabelName.ENDPOINT)));
            }
        }
        return metricInfo;
    }

    private Optional<ValueColumnMetadata.ValueColumn> getValueColumn(String metricName) {
        return ValueColumnMetadata.INSTANCE.readValueColumnDefinition(metricName);
    }
}

