/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.istio.api.internal.protobuf.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.HashMap;
import java.util.Map;

public enum NullValue {
    NULL_VALUE(0);

    private final Integer value;
    private static final Map<Integer, NullValue> CONSTANTS;
    private static final Map<String, NullValue> NAME_CONSTANTS;

    private NullValue(Integer value) {
        this.value = value;
    }

    @JsonCreator
    public static NullValue fromValue(Object value) {
        if (value instanceof String) {
            NullValue constant = NAME_CONSTANTS.get(((String)value).toLowerCase());
            if (constant == null) {
                throw new IllegalArgumentException(value + "");
            }
            return constant;
        }
        NullValue constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value + "");
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<Integer, NullValue>();
        NAME_CONSTANTS = new HashMap<String, NullValue>();
        for (NullValue c : NullValue.values()) {
            CONSTANTS.put(c.value, c);
        }
        for (NullValue c : NullValue.values()) {
            NAME_CONSTANTS.put(c.name().toLowerCase(), c);
        }
    }
}

