/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.docs;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.RequestTarget;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSortedSet;
import com.linecorp.armeria.internal.shaded.guava.collect.Iterables;
import com.linecorp.armeria.server.docs.DescriptionInfo;
import com.linecorp.armeria.server.docs.EndpointInfo;
import com.linecorp.armeria.server.docs.FieldInfo;
import com.linecorp.armeria.server.docs.TypeSignature;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public final class MethodInfo {
    private final String id;
    private final String name;
    private final TypeSignature returnTypeSignature;
    private final List<FieldInfo> parameters;
    private final boolean useParameterAsRoot;
    private final Set<TypeSignature> exceptionTypeSignatures;
    private final Set<EndpointInfo> endpoints;
    private final List<HttpHeaders> exampleHeaders;
    private final List<String> exampleRequests;
    private final List<String> examplePaths;
    private final List<String> exampleQueries;
    private final HttpMethod httpMethod;
    private final DescriptionInfo descriptionInfo;

    public MethodInfo(String serviceName, String name, int overloadId, TypeSignature returnTypeSignature, Iterable<FieldInfo> parameters, Iterable<TypeSignature> exceptionTypeSignatures, Iterable<EndpointInfo> endpoints, HttpMethod httpMethod, DescriptionInfo descriptionInfo) {
        this(name, returnTypeSignature, parameters, false, exceptionTypeSignatures, endpoints, ImmutableList.of(), ImmutableList.of(), ImmutableList.of(), ImmutableList.of(), httpMethod, descriptionInfo, MethodInfo.createId(serviceName, name, overloadId, httpMethod));
    }

    public MethodInfo(String serviceName, String name, int overloadId, TypeSignature returnTypeSignature, Iterable<FieldInfo> parameters, Iterable<EndpointInfo> endpoints, Iterable<String> examplePaths, Iterable<String> exampleQueries, HttpMethod httpMethod, DescriptionInfo descriptionInfo) {
        this(name, returnTypeSignature, parameters, false, ImmutableList.of(), endpoints, ImmutableList.of(), ImmutableList.of(), examplePaths, exampleQueries, httpMethod, descriptionInfo, MethodInfo.createId(serviceName, name, overloadId, httpMethod));
    }

    public MethodInfo(String serviceName, String name, TypeSignature returnTypeSignature, Iterable<FieldInfo> parameters, boolean useParameterAsRoot, Iterable<TypeSignature> exceptionTypeSignatures, Iterable<EndpointInfo> endpoints, Iterable<HttpHeaders> exampleHeaders, Iterable<String> exampleRequests, Iterable<String> examplePaths, Iterable<String> exampleQueries, HttpMethod httpMethod, DescriptionInfo descriptionInfo) {
        this(name, returnTypeSignature, parameters, useParameterAsRoot, exceptionTypeSignatures, endpoints, exampleHeaders, exampleRequests, examplePaths, exampleQueries, httpMethod, descriptionInfo, MethodInfo.createId(serviceName, name, 0, httpMethod));
    }

    MethodInfo(String name, TypeSignature returnTypeSignature, Iterable<FieldInfo> parameters, boolean useParameterAsRoot, Iterable<TypeSignature> exceptionTypeSignatures, Iterable<EndpointInfo> endpoints, Iterable<HttpHeaders> exampleHeaders, Iterable<String> exampleRequests, Iterable<String> examplePaths, Iterable<String> exampleQueries, HttpMethod httpMethod, DescriptionInfo descriptionInfo, String id) {
        this.id = Objects.requireNonNull(id, "id");
        this.name = Objects.requireNonNull(name, "name");
        this.returnTypeSignature = Objects.requireNonNull(returnTypeSignature, "returnTypeSignature");
        this.parameters = ImmutableList.copyOf(Objects.requireNonNull(parameters, "parameters"));
        assert (!useParameterAsRoot || this.parameters.size() == 1);
        this.useParameterAsRoot = useParameterAsRoot;
        this.exceptionTypeSignatures = ImmutableSortedSet.copyOf(Comparator.comparing(TypeSignature::signature), Objects.requireNonNull(exceptionTypeSignatures, "exceptionTypeSignatures"));
        this.endpoints = ImmutableSortedSet.copyOf(Comparator.comparing(e -> e.hostnamePattern() + ':' + e.pathMapping()), Objects.requireNonNull(endpoints, "endpoints"));
        this.exampleHeaders = ImmutableList.copyOf(Objects.requireNonNull(exampleHeaders, "exampleHeaders"));
        this.exampleRequests = ImmutableList.copyOf(Objects.requireNonNull(exampleRequests, "exampleRequests"));
        Objects.requireNonNull(examplePaths, "examplePaths");
        ImmutableList.Builder examplePathsBuilder = ImmutableList.builderWithExpectedSize(Iterables.size(examplePaths));
        for (String path : examplePaths) {
            RequestTarget reqTarget = RequestTarget.forServer(path);
            Preconditions.checkArgument(reqTarget != null, "examplePaths contains an invalid path: %s", (Object)path);
            examplePathsBuilder.add(reqTarget.path());
        }
        this.examplePaths = examplePathsBuilder.build();
        Objects.requireNonNull(exampleQueries, "exampleQueries");
        ImmutableList.Builder exampleQueriesBuilder = ImmutableList.builderWithExpectedSize(Iterables.size(exampleQueries));
        for (String query : exampleQueries) {
            RequestTarget reqTarget = RequestTarget.forServer("/?" + query);
            Preconditions.checkArgument(reqTarget != null, "exampleQueries contains an invalid query string: %s", (Object)query);
            exampleQueriesBuilder.add(reqTarget.query());
        }
        this.exampleQueries = exampleQueriesBuilder.build();
        this.httpMethod = Objects.requireNonNull(httpMethod, "httpMethod");
        this.descriptionInfo = Objects.requireNonNull(descriptionInfo, "descriptionInfo");
    }

    @JsonProperty
    public String id() {
        return this.id;
    }

    @JsonProperty
    public String name() {
        return this.name;
    }

    @JsonProperty
    public TypeSignature returnTypeSignature() {
        return this.returnTypeSignature;
    }

    @JsonProperty
    public Set<EndpointInfo> endpoints() {
        return this.endpoints;
    }

    @JsonProperty
    public List<FieldInfo> parameters() {
        return this.parameters;
    }

    @JsonIgnore
    public boolean useParameterAsRoot() {
        return this.useParameterAsRoot;
    }

    public MethodInfo withParameters(Iterable<FieldInfo> parameters) {
        Objects.requireNonNull(parameters, "parameters");
        if (parameters.equals(this.parameters)) {
            return this;
        }
        return new MethodInfo(this.name, this.returnTypeSignature, parameters, this.useParameterAsRoot, this.exceptionTypeSignatures, this.endpoints, this.exampleHeaders, this.exampleRequests, this.examplePaths, this.exampleQueries, this.httpMethod, this.descriptionInfo, this.id);
    }

    @JsonProperty
    public Set<TypeSignature> exceptionTypeSignatures() {
        return this.exceptionTypeSignatures;
    }

    @JsonProperty
    public List<HttpHeaders> exampleHeaders() {
        return this.exampleHeaders;
    }

    @JsonProperty
    public List<String> exampleRequests() {
        return this.exampleRequests;
    }

    @JsonProperty
    public List<String> examplePaths() {
        return this.examplePaths;
    }

    @JsonProperty
    public List<String> exampleQueries() {
        return this.exampleQueries;
    }

    @JsonProperty
    public HttpMethod httpMethod() {
        return this.httpMethod;
    }

    @JsonProperty
    public DescriptionInfo descriptionInfo() {
        return this.descriptionInfo;
    }

    public MethodInfo withDescriptionInfo(DescriptionInfo descriptionInfo) {
        Objects.requireNonNull(descriptionInfo, "descriptionInfo");
        if (descriptionInfo.equals(this.descriptionInfo)) {
            return this;
        }
        return new MethodInfo(this.name, this.returnTypeSignature, this.parameters, this.useParameterAsRoot, this.exceptionTypeSignatures, this.endpoints, this.exampleHeaders, this.exampleRequests, this.examplePaths, this.exampleQueries, this.httpMethod, descriptionInfo, this.id);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MethodInfo)) {
            return false;
        }
        MethodInfo that = (MethodInfo)o;
        return this.id().equals(that.id()) && this.name().equals(that.name()) && this.returnTypeSignature().equals(that.returnTypeSignature()) && this.parameters().equals(that.parameters()) && this.useParameterAsRoot() == that.useParameterAsRoot() && this.exceptionTypeSignatures().equals(that.exceptionTypeSignatures()) && this.endpoints().equals(that.endpoints()) && this.httpMethod() == that.httpMethod() && this.descriptionInfo().equals(that.descriptionInfo());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id(), this.name(), this.returnTypeSignature(), this.parameters(), this.useParameterAsRoot(), this.exceptionTypeSignatures(), this.endpoints(), this.httpMethod(), this.descriptionInfo()});
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("id", this.id()).add("name", this.name()).add("returnTypeSignature", this.returnTypeSignature()).add("parameters", this.parameters()).add("useParameterAsRoot", this.useParameterAsRoot()).add("exceptionTypeSignatures", this.exceptionTypeSignatures()).add("endpoints", this.endpoints()).add("httpMethod", (Object)this.httpMethod()).add("descriptionInfo", this.descriptionInfo()).toString();
    }

    private static String createId(String serviceName, String name, int overloadId, HttpMethod httpMethod) {
        String methodName = overloadId > 0 ? name + '-' + overloadId : name;
        return serviceName + '/' + methodName + '/' + httpMethod.name();
    }
}

