/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.DomainSocketAddress;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.armeria.internal.shaded.guava.collect.Sets;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

public final class ServerPort
implements Comparable<ServerPort> {
    private static final AtomicLong nextPortGroup = new AtomicLong();
    private final InetSocketAddress localAddress;
    private final String comparisonStr;
    private final Set<SessionProtocol> protocols;
    private final long portGroup;
    private int hashCode;
    @Nullable
    private String strVal;

    static long nextPortGroup() {
        long portGroup;
        while ((portGroup = nextPortGroup.incrementAndGet()) <= 0L) {
        }
        return portGroup;
    }

    public ServerPort(int port, SessionProtocol ... protocols) {
        this(new InetSocketAddress(port), ImmutableSet.copyOf(Objects.requireNonNull(protocols, "protocols")));
    }

    public ServerPort(InetSocketAddress localAddress, SessionProtocol ... protocols) {
        this(localAddress, ImmutableSet.copyOf(Objects.requireNonNull(protocols, "protocols")));
    }

    public ServerPort(int port, Iterable<SessionProtocol> protocols) {
        this(new InetSocketAddress(port), protocols);
    }

    public ServerPort(InetSocketAddress localAddress, Iterable<SessionProtocol> protocols) {
        this(localAddress, protocols, 0L);
    }

    ServerPort(InetSocketAddress localAddress, Iterable<SessionProtocol> protocols, long portGroup) {
        if (Objects.requireNonNull(localAddress, "localAddress").isUnresolved()) {
            try {
                localAddress = new InetSocketAddress(InetAddress.getByName(localAddress.getHostString()), localAddress.getPort());
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException("unresolved localAddress: " + localAddress, e);
            }
        }
        this.localAddress = localAddress;
        this.protocols = ServerPort.checkProtocols(protocols);
        this.portGroup = portGroup;
        this.comparisonStr = localAddress instanceof DomainSocketAddress ? ((DomainSocketAddress)localAddress).authority() + '/' + protocols : localAddress.getAddress().getHostAddress() + '/' + localAddress.getPort() + '/' + protocols;
    }

    private static Set<SessionProtocol> checkProtocols(Iterable<SessionProtocol> protocols) {
        ImmutableSet<SessionProtocol> copy = Sets.immutableEnumSet(Objects.requireNonNull(protocols, "protocols"));
        Preconditions.checkArgument(!copy.isEmpty(), "protocols: %s (must not be empty)", copy);
        Preconditions.checkArgument(copy.contains((Object)SessionProtocol.HTTP) || copy.contains((Object)SessionProtocol.HTTPS), "protocols: %s (must contain HTTP or HTTPS)", copy);
        Preconditions.checkArgument(copy.stream().allMatch(p -> p == SessionProtocol.HTTP || p == SessionProtocol.HTTPS || p == SessionProtocol.PROXY), "protocols: %s (must not contain other than %s, %s or %s)", copy, (Object)SessionProtocol.HTTP, (Object)SessionProtocol.HTTPS, (Object)SessionProtocol.PROXY);
        return copy;
    }

    public InetSocketAddress localAddress() {
        return this.localAddress;
    }

    public boolean isDomainSocket() {
        return this.localAddress instanceof DomainSocketAddress;
    }

    public Set<SessionProtocol> protocols() {
        return this.protocols;
    }

    public boolean hasTls() {
        return this.protocols.stream().anyMatch(SessionProtocol::isTls);
    }

    public boolean hasHttp() {
        return this.hasExactProtocol(SessionProtocol.HTTP);
    }

    public boolean hasHttps() {
        return this.hasExactProtocol(SessionProtocol.HTTPS);
    }

    public boolean hasProxyProtocol() {
        return this.hasExactProtocol(SessionProtocol.PROXY);
    }

    public boolean hasProtocol(SessionProtocol protocol) {
        Objects.requireNonNull(protocol, "protocol");
        if (SessionProtocol.httpValues().contains((Object)protocol)) {
            return this.hasHttp();
        }
        if (SessionProtocol.httpsValues().contains((Object)protocol)) {
            return this.hasHttps();
        }
        return this.hasExactProtocol(protocol);
    }

    private boolean hasExactProtocol(SessionProtocol protocol) {
        return this.protocols.contains((Object)Objects.requireNonNull(protocol, "protocol"));
    }

    long portGroup() {
        return this.portGroup;
    }

    public int hashCode() {
        int hashCode = this.hashCode;
        if (hashCode == 0) {
            hashCode = this.comparisonStr.hashCode();
            if (hashCode == 0) {
                hashCode = 1;
            }
            this.hashCode = hashCode;
        }
        return hashCode;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ServerPort)) {
            return false;
        }
        ServerPort that = (ServerPort)obj;
        int hashCode = this.hashCode;
        if (hashCode != 0 && that.hashCode != 0 && hashCode != that.hashCode) {
            return false;
        }
        return this.comparisonStr.equals(that.comparisonStr);
    }

    @Override
    public int compareTo(ServerPort o) {
        return this.comparisonStr.compareTo(o.comparisonStr);
    }

    public String toString() {
        String strVal = this.strVal;
        if (strVal == null) {
            this.strVal = strVal = ServerPort.toString(this.getClass(), this.localAddress(), this.protocols(), this.portGroup());
        }
        return strVal;
    }

    static String toString(@Nullable Class<?> type, InetSocketAddress localAddress, Set<SessionProtocol> protocols, long portGroup) {
        StringBuilder buf = new StringBuilder();
        if (type != null) {
            buf.append(type.getSimpleName());
        }
        buf.append('(');
        buf.append(localAddress);
        buf.append(", ");
        buf.append(protocols);
        if (portGroup != 0L) {
            buf.append(", group: ").append(portGroup);
        }
        buf.append(')');
        return buf.toString();
    }
}

