/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.base.Splitter;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.util.AsciiString;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ReferenceCounted;
import io.netty.util.internal.ObjectUtil;
import java.nio.charset.StandardCharsets;
import java.util.List;

final class HttpServerUpgradeHandler
extends ChannelInboundHandlerAdapter {
    private static final FullHttpResponse UPGRADE_RESPONSE = HttpServerUpgradeHandler.newUpgradeResponse();
    private static final Splitter COMMA_SPLITTER = Splitter.on(',').omitEmptyStrings().trimResults();
    private static final FullHttpResponse invalidSettingsHeaderResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_REQUEST, Unpooled.unreleasableBuffer(Unpooled.directBuffer().writeBytes("Invalid HTTP2-Settings header\n".getBytes(StandardCharsets.UTF_8))));
    private final HttpServerCodec sourceCodec;
    private final UpgradeCodecFactory upgradeCodecFactory;
    @Nullable
    private UpgradeCodec upgradeCodec;
    private boolean handlingUpgrade;
    private boolean handlingInvalidSettingsHeader;

    HttpServerUpgradeHandler(HttpServerCodec sourceCodec, UpgradeCodecFactory upgradeCodecFactory) {
        this.sourceCodec = ObjectUtil.checkNotNull(sourceCodec, "sourceCodec");
        this.upgradeCodecFactory = ObjectUtil.checkNotNull(upgradeCodecFactory, "upgradeCodecFactory");
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HttpRequest) {
            HttpRequest req = (HttpRequest)msg;
            if (req.headers().contains(HttpHeaderNames.UPGRADE) && this.upgrade(ctx, req)) {
                this.handlingUpgrade = true;
                return;
            }
            if (this.handlingInvalidSettingsHeader) {
                return;
            }
        }
        ctx.fireChannelRead(msg);
        if (this.handlingUpgrade && msg instanceof LastHttpContent) {
            this.sourceCodec.upgradeFrom(ctx);
            ctx.fireChannelReadComplete();
            ctx.pipeline().remove(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean upgrade(ChannelHandlerContext ctx, HttpRequest request) {
        List<String> requestedProtocols = COMMA_SPLITTER.splitToList(request.headers().get(HttpHeaderNames.UPGRADE));
        int numRequestedProtocols = requestedProtocols.size();
        for (int i = 0; i < numRequestedProtocols; ++i) {
            CharSequence protocol = requestedProtocols.get(i);
            if (!AsciiString.contentEquals(Http2CodecUtil.HTTP_UPGRADE_PROTOCOL_NAME, protocol)) continue;
            this.upgradeCodec = this.upgradeCodecFactory.newUpgradeCodec();
            break;
        }
        if (this.upgradeCodec == null) {
            return false;
        }
        List<String> connectionHeaderValues = request.headers().getAll(HttpHeaderNames.CONNECTION);
        if (connectionHeaderValues == null || connectionHeaderValues.isEmpty()) {
            return false;
        }
        List values = connectionHeaderValues.stream().flatMap(COMMA_SPLITTER::splitToStream).collect(ImmutableList.toImmutableList());
        if (!AsciiString.containsContentEqualsIgnoreCase(values, HttpHeaderNames.UPGRADE) || !AsciiString.containsContentEqualsIgnoreCase(values, Http2CodecUtil.HTTP_UPGRADE_SETTINGS_HEADER)) {
            return false;
        }
        if (!request.headers().contains(Http2CodecUtil.HTTP_UPGRADE_SETTINGS_HEADER)) {
            return false;
        }
        if (!this.upgradeCodec.prepareUpgradeResponse(ctx, request)) {
            ctx.writeAndFlush(invalidSettingsHeaderResponse.duplicate()).addListener(ChannelFutureListener.CLOSE);
            this.handlingInvalidSettingsHeader = true;
            return false;
        }
        UpgradeEvent event = new UpgradeEvent(request);
        try {
            ChannelFuture writeComplete = ctx.writeAndFlush(UPGRADE_RESPONSE.retain());
            this.sourceCodec.removeOutboundHandler();
            assert (this.upgradeCodec != null);
            this.upgradeCodec.upgradeTo(ctx);
            ctx.fireUserEventTriggered(event.retain());
            writeComplete.addListener(ChannelFutureListener.CLOSE_ON_FAILURE);
        }
        finally {
            event.release();
        }
        return true;
    }

    private static FullHttpResponse newUpgradeResponse() {
        DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.SWITCHING_PROTOCOLS, Unpooled.EMPTY_BUFFER, true);
        res.headers().add((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.UPGRADE);
        res.headers().add((CharSequence)HttpHeaderNames.UPGRADE, (Object)Http2CodecUtil.HTTP_UPGRADE_PROTOCOL_NAME);
        return res;
    }

    @FunctionalInterface
    static interface UpgradeCodecFactory {
        public UpgradeCodec newUpgradeCodec();
    }

    static interface UpgradeCodec {
        public boolean prepareUpgradeResponse(ChannelHandlerContext var1, HttpRequest var2);

        public void upgradeTo(ChannelHandlerContext var1);
    }

    static final class UpgradeEvent
    implements ReferenceCounted {
        private final HttpRequest upgradeRequest;

        UpgradeEvent(HttpRequest upgradeRequest) {
            this.upgradeRequest = upgradeRequest;
        }

        public CharSequence protocol() {
            return Http2CodecUtil.HTTP_UPGRADE_PROTOCOL_NAME;
        }

        public HttpRequest upgradeRequest() {
            return this.upgradeRequest;
        }

        @Override
        public int refCnt() {
            return ReferenceCountUtil.refCnt(this.upgradeRequest);
        }

        @Override
        public UpgradeEvent retain() {
            ReferenceCountUtil.retain(this.upgradeRequest);
            return this;
        }

        @Override
        public UpgradeEvent retain(int increment) {
            ReferenceCountUtil.retain(this.upgradeRequest);
            return this;
        }

        @Override
        public UpgradeEvent touch() {
            ReferenceCountUtil.touch(this.upgradeRequest);
            return this;
        }

        @Override
        public UpgradeEvent touch(Object hint) {
            ReferenceCountUtil.touch(this.upgradeRequest, hint);
            return this;
        }

        @Override
        public boolean release() {
            return ReferenceCountUtil.release(this.upgradeRequest);
        }

        @Override
        public boolean release(int decrement) {
            return ReferenceCountUtil.release(this.upgradeRequest, decrement);
        }

        public String toString() {
            return "UpgradeEvent [protocol=" + this.protocol() + ", upgradeRequest=" + this.upgradeRequest + ']';
        }
    }
}

