/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.server;

import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.Route;
import com.linecorp.armeria.server.Router;
import com.linecorp.armeria.server.Service;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.SimpleDecoratingHttpService;
import io.netty.util.AttributeKey;
import java.util.ArrayDeque;
import java.util.Objects;
import java.util.Queue;
import java.util.function.Function;

public final class RouteDecoratingService
implements HttpService {
    private static final AttributeKey<Queue<HttpService>> DECORATOR_KEY = AttributeKey.valueOf(RouteDecoratingService.class, "SERVICE_CHAIN");
    private final Route route;
    private final HttpService decorator;

    public static Function<? super HttpService, InitialDispatcherService> newDecorator(Router<RouteDecoratingService> router) {
        return delegate -> new InitialDispatcherService((HttpService)delegate, router);
    }

    public RouteDecoratingService(Route route, Function<? super HttpService, ? extends HttpService> decoratorFunction) {
        this.route = Objects.requireNonNull(route, "route");
        this.decorator = Objects.requireNonNull(decoratorFunction, "decoratorFunction").apply(this);
    }

    @Override
    public HttpResponse serve(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        Queue<HttpService> delegates = ctx.attr(DECORATOR_KEY);
        assert (delegates != null);
        HttpService delegate = delegates.poll();
        assert (delegate != null);
        return delegate.serve(ctx, req);
    }

    public Route route() {
        return this.route;
    }

    private HttpService decorator() {
        return this.decorator;
    }

    @Nullable
    public <T extends HttpService> T as(ServiceRequestContext ctx, Class<T> serviceClass) {
        Queue<HttpService> delegates = ctx.attr(DECORATOR_KEY);
        if (delegates == null) {
            return null;
        }
        for (HttpService delegate : delegates) {
            HttpService service = (HttpService)delegate.as(serviceClass);
            if (service == null) continue;
            return (T)service;
        }
        return null;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("route", this.route).toString();
    }

    private static class InitialDispatcherService
    extends SimpleDecoratingHttpService {
        private final Router<RouteDecoratingService> router;

        InitialDispatcherService(HttpService delegate, Router<RouteDecoratingService> router) {
            super(delegate);
            this.router = router;
        }

        @Override
        public HttpResponse serve(ServiceRequestContext ctx, HttpRequest req) throws Exception {
            ArrayDeque<HttpService> serviceChain = new ArrayDeque<HttpService>(4);
            this.router.findAll(ctx.routingContext()).forEach(routed -> {
                if (routed.isPresent()) {
                    serviceChain.add(((RouteDecoratingService)routed.value()).decorator());
                }
            });
            if (serviceChain.isEmpty()) {
                return (HttpResponse)((Service)this.unwrap()).serve(ctx, req);
            }
            serviceChain.add((HttpService)this.unwrap());
            HttpService service = (HttpService)serviceChain.poll();
            ctx.setAttr(DECORATOR_KEY, serviceChain);
            assert (service != null);
            return service.serve(ctx, req);
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper(this).add("router", this.router).add("delegate", this.unwrap()).toString();
        }
    }
}

