/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common.util;

import com.linecorp.armeria.common.Flags;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.internal.common.util.ChannelUtil;
import com.linecorp.armeria.internal.shaded.guava.base.Ascii;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoop;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.channel.unix.DomainSocketChannel;
import io.netty.channel.unix.ServerDomainSocketChannel;
import io.netty.util.NetUtil;
import io.netty.util.Version;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadFactory;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TransportTypeProvider {
    private static final Logger logger = LoggerFactory.getLogger(TransportTypeProvider.class);
    public static final TransportTypeProvider NIO;
    public static final TransportTypeProvider EPOLL;
    public static final TransportTypeProvider KQUEUE;
    public static final TransportTypeProvider IO_URING;
    private final String name;
    @Nullable
    private final Class<? extends ServerSocketChannel> serverChannelType;
    @Nullable
    private final Class<? extends SocketChannel> socketChannelType;
    @Nullable
    private final Class<? extends ServerDomainSocketChannel> domainServerChannelType;
    @Nullable
    private final Class<? extends DomainSocketChannel> domainSocketChannelType;
    @Nullable
    private final Class<? extends DatagramChannel> datagramChannelType;
    @Nullable
    private final Class<? extends EventLoopGroup> eventLoopGroupType;
    @Nullable
    private final Class<? extends EventLoop> eventLoopType;
    @Nullable
    private final BiFunction<Integer, ThreadFactory, ? extends EventLoopGroup> eventLoopGroupConstructor;
    @Nullable
    private final Throwable unavailabilityCause;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static TransportTypeProvider of(String name, @Nullable String channelPackageName, String entryPointTypeName, String serverSocketChannelTypeName, String socketChannelTypeName, @Nullable String domainServerSocketChannelTypeName, @Nullable String domainSocketChannelTypeName, String datagramChannelTypeName, String eventLoopGroupTypeName, String eventLoopTypeName) {
        TransportTypeProvider transportTypeProvider;
        block13: {
            if (channelPackageName == null) {
                return new TransportTypeProvider(name, null, null, null, null, null, null, null, null, new IllegalStateException("Failed to determine the shaded package name"));
            }
            if ("IO_URING".equals(name) && !"io_uring".equals(Ascii.toLowerCase(System.getProperty("com.linecorp.armeria.transportType", "")))) {
                return new TransportTypeProvider(name, null, null, null, null, null, null, null, null, new IllegalStateException("io_uring not enabled explicitly"));
            }
            Throwable unavailabilityCause = (Throwable)TransportTypeProvider.findClass(channelPackageName, entryPointTypeName).getMethod("unavailabilityCause", new Class[0]).invoke(null, new Object[0]);
            if (unavailabilityCause != null) {
                throw unavailabilityCause;
            }
            Class ssc = TransportTypeProvider.findClass(channelPackageName, serverSocketChannelTypeName);
            Class sc = TransportTypeProvider.findClass(channelPackageName, socketChannelTypeName);
            Class sdsc = TransportTypeProvider.findClass(channelPackageName, domainServerSocketChannelTypeName);
            Class dsc = TransportTypeProvider.findClass(channelPackageName, domainSocketChannelTypeName);
            Class dc = TransportTypeProvider.findClass(channelPackageName, datagramChannelTypeName);
            Class elg = TransportTypeProvider.findClass(channelPackageName, eventLoopGroupTypeName);
            Class el = TransportTypeProvider.findClass(channelPackageName, eventLoopTypeName);
            BiFunction<Integer, ThreadFactory, ? extends EventLoopGroup> elgc = TransportTypeProvider.findEventLoopGroupConstructor(elg);
            transportTypeProvider = new TransportTypeProvider(name, ssc, sc, sdsc, dsc, dc, elg, el, elgc, null);
            String unixSocketClassName = ChannelUtil.channelPackageName() + ".unix.Socket";
            try {
                Method initializeMethod = TransportTypeProvider.findClass(ChannelUtil.channelPackageName(), unixSocketClassName).getDeclaredMethod("initialize", Boolean.TYPE);
                initializeMethod.setAccessible(true);
                initializeMethod.invoke(null, NetUtil.isIpV4StackPreferred());
            }
            catch (Throwable cause) {
                Throwable peeledCause = Exceptions.peel(cause);
                if (peeledCause instanceof UnsatisfiedLinkError || peeledCause instanceof ClassNotFoundException) break block13;
                logger.debug("Failed to force-initialize '" + ChannelUtil.channelPackageName() + ".unix.Socket':", cause);
            }
        }
        return transportTypeProvider;
        catch (Throwable cause) {
            TransportTypeProvider transportTypeProvider2;
            block14: {
                String unixSocketClassName2;
                try {
                    transportTypeProvider2 = new TransportTypeProvider(name, null, null, null, null, null, null, null, null, Exceptions.peel(cause));
                    unixSocketClassName2 = ChannelUtil.channelPackageName() + ".unix.Socket";
                }
                catch (Throwable throwable) {
                    block15: {
                        String unixSocketClassName22 = ChannelUtil.channelPackageName() + ".unix.Socket";
                        try {
                            Method initializeMethod = TransportTypeProvider.findClass(ChannelUtil.channelPackageName(), unixSocketClassName22).getDeclaredMethod("initialize", Boolean.TYPE);
                            initializeMethod.setAccessible(true);
                            initializeMethod.invoke(null, NetUtil.isIpV4StackPreferred());
                        }
                        catch (Throwable cause2) {
                            Throwable peeledCause = Exceptions.peel(cause2);
                            if (peeledCause instanceof UnsatisfiedLinkError || peeledCause instanceof ClassNotFoundException) break block15;
                            logger.debug("Failed to force-initialize '" + ChannelUtil.channelPackageName() + ".unix.Socket':", cause2);
                        }
                    }
                    throw throwable;
                }
                try {
                    Method initializeMethod = TransportTypeProvider.findClass(ChannelUtil.channelPackageName(), unixSocketClassName2).getDeclaredMethod("initialize", Boolean.TYPE);
                    initializeMethod.setAccessible(true);
                    initializeMethod.invoke(null, NetUtil.isIpV4StackPreferred());
                }
                catch (Throwable cause3) {
                    Throwable peeledCause = Exceptions.peel(cause3);
                    if (peeledCause instanceof UnsatisfiedLinkError || peeledCause instanceof ClassNotFoundException) break block14;
                    logger.debug("Failed to force-initialize '" + ChannelUtil.channelPackageName() + ".unix.Socket':", cause3);
                }
            }
            return transportTypeProvider2;
        }
    }

    @Nullable
    private static <T> Class<T> findClass(String channelPackageName, @Nullable String className) throws Exception {
        if (className == null) {
            return null;
        }
        return Class.forName(channelPackageName + className, false, TransportTypeProvider.class.getClassLoader());
    }

    private static BiFunction<Integer, ThreadFactory, ? extends EventLoopGroup> findEventLoopGroupConstructor(Class<? extends EventLoopGroup> eventLoopGroupType) throws Exception {
        MethodHandle constructor = MethodHandles.lookup().unreflectConstructor(eventLoopGroupType.getConstructor(Integer.TYPE, ThreadFactory.class));
        return (nThreads, threadFactory) -> {
            try {
                return constructor.invoke((Integer)nThreads, (ThreadFactory)threadFactory);
            }
            catch (Throwable t) {
                return (EventLoopGroup)Exceptions.throwUnsafely(Exceptions.peel(t));
            }
        };
    }

    private TransportTypeProvider(String name, @Nullable Class<? extends ServerSocketChannel> serverChannelType, @Nullable Class<? extends SocketChannel> socketChannelType, @Nullable Class<? extends ServerDomainSocketChannel> domainServerChannelType, @Nullable Class<? extends DomainSocketChannel> domainSocketChannelType, @Nullable Class<? extends DatagramChannel> datagramChannelType, @Nullable Class<? extends EventLoopGroup> eventLoopGroupType, @Nullable Class<? extends EventLoop> eventLoopType, @Nullable BiFunction<Integer, ThreadFactory, ? extends EventLoopGroup> eventLoopGroupConstructor, @Nullable Throwable unavailabilityCause) {
        assert (serverChannelType == null && socketChannelType == null && domainServerChannelType == null && domainSocketChannelType == null && datagramChannelType == null && eventLoopGroupType == null && eventLoopType == null && eventLoopGroupConstructor == null && unavailabilityCause != null || serverChannelType != null && socketChannelType != null && datagramChannelType != null && eventLoopGroupType != null && eventLoopType != null && eventLoopGroupConstructor != null && unavailabilityCause == null);
        assert (domainServerChannelType != null && domainSocketChannelType != null || domainServerChannelType == null && domainSocketChannelType == null) : domainServerChannelType + ", " + domainSocketChannelType;
        this.name = name;
        this.serverChannelType = serverChannelType;
        this.socketChannelType = socketChannelType;
        this.domainServerChannelType = domainServerChannelType;
        this.domainSocketChannelType = domainSocketChannelType;
        this.datagramChannelType = datagramChannelType;
        this.eventLoopGroupType = eventLoopGroupType;
        this.eventLoopType = eventLoopType;
        this.eventLoopGroupConstructor = eventLoopGroupConstructor;
        this.unavailabilityCause = unavailabilityCause;
    }

    public Class<? extends ServerSocketChannel> serverChannelType() {
        return this.ensureSupported(this.serverChannelType);
    }

    public Class<? extends SocketChannel> socketChannelType() {
        return this.ensureSupported(this.socketChannelType);
    }

    public boolean supportsDomainSockets() {
        return this.domainSocketChannelType != null;
    }

    public Class<? extends ServerDomainSocketChannel> domainServerChannelType() {
        return this.ensureSupported(this.domainServerChannelType);
    }

    public Class<? extends DomainSocketChannel> domainSocketChannelType() {
        return this.ensureSupported(this.domainSocketChannelType);
    }

    public Class<? extends DatagramChannel> datagramChannelType() {
        return this.ensureSupported(this.datagramChannelType);
    }

    public Class<? extends EventLoopGroup> eventLoopGroupType() {
        return this.ensureSupported(this.eventLoopGroupType);
    }

    public Class<? extends EventLoop> eventLoopType() {
        return this.ensureSupported(this.eventLoopType);
    }

    public BiFunction<Integer, ThreadFactory, ? extends EventLoopGroup> eventLoopGroupConstructor() {
        return this.ensureSupported(this.eventLoopGroupConstructor);
    }

    @Nullable
    public Throwable unavailabilityCause() {
        return this.unavailabilityCause;
    }

    private <T> T ensureSupported(@Nullable T value) {
        if (value == null) {
            throw new IllegalStateException("transport '" + this.name + "' not available: " + this.unavailabilityCause, this.unavailabilityCause);
        }
        return value;
    }

    static {
        if (Flags.warnNettyVersions()) {
            String howToDisableWarning = "This means 1) you specified Netty versions inconsistently in your build or 2) the Netty JARs in the classpath were repackaged or shaded incorrectly. Specify the '-Dcom.linecorp.armeria.warnNettyVersions=false' JVM option to disable this warning at the risk of unexpected Netty behavior, if you think it is a false positive.";
            Map<String, Version> nettyVersions = Version.identify(TransportTypeProvider.class.getClassLoader());
            Set distinctNettyVersions = nettyVersions.values().stream().filter(v -> {
                String artifactId = v.artifactId();
                return artifactId != null && artifactId.startsWith("netty") && !artifactId.startsWith("netty-incubator") && !artifactId.startsWith("netty-tcnative");
            }).map(Version::artifactVersion).collect(ImmutableSet.toImmutableSet());
            switch (distinctNettyVersions.size()) {
                case 0: {
                    logger.warn("Using Netty with unknown version. {}", (Object)"This means 1) you specified Netty versions inconsistently in your build or 2) the Netty JARs in the classpath were repackaged or shaded incorrectly. Specify the '-Dcom.linecorp.armeria.warnNettyVersions=false' JVM option to disable this warning at the risk of unexpected Netty behavior, if you think it is a false positive.");
                    break;
                }
                case 1: {
                    if (!logger.isDebugEnabled()) break;
                    logger.debug("Using Netty {}", distinctNettyVersions.iterator().next());
                    break;
                }
                default: {
                    logger.warn("Inconsistent Netty versions detected: {} {}", (Object)nettyVersions, (Object)"This means 1) you specified Netty versions inconsistently in your build or 2) the Netty JARs in the classpath were repackaged or shaded incorrectly. Specify the '-Dcom.linecorp.armeria.warnNettyVersions=false' JVM option to disable this warning at the risk of unexpected Netty behavior, if you think it is a false positive.");
                }
            }
        }
        NIO = new TransportTypeProvider("NIO", NioServerSocketChannel.class, NioSocketChannel.class, null, null, NioDatagramChannel.class, NioEventLoopGroup.class, NioEventLoop.class, NioEventLoopGroup::new, null);
        EPOLL = TransportTypeProvider.of("EPOLL", ChannelUtil.channelPackageName(), ".epoll.Epoll", ".epoll.EpollServerSocketChannel", ".epoll.EpollSocketChannel", ".epoll.EpollServerDomainSocketChannel", ".epoll.EpollDomainSocketChannel", ".epoll.EpollDatagramChannel", ".epoll.EpollEventLoopGroup", ".epoll.EpollEventLoop");
        KQUEUE = TransportTypeProvider.of("KQUEUE", ChannelUtil.channelPackageName(), ".kqueue.KQueue", ".kqueue.KQueueServerSocketChannel", ".kqueue.KQueueSocketChannel", ".kqueue.KQueueServerDomainSocketChannel", ".kqueue.KQueueDomainSocketChannel", ".kqueue.KQueueDatagramChannel", ".kqueue.KQueueEventLoopGroup", ".kqueue.KQueueEventLoop");
        IO_URING = TransportTypeProvider.of("IO_URING", ChannelUtil.incubatorChannelPackageName(), ".uring.IOUring", ".uring.IOUringServerSocketChannel", ".uring.IOUringSocketChannel", null, null, ".uring.IOUringDatagramChannel", ".uring.IOUringEventLoopGroup", ".uring.IOUringEventLoop");
    }
}

