/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common.stream;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.stream.NoopSubscriber;
import com.linecorp.armeria.internal.shaded.guava.math.LongMath;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class PrependingPublisher<T>
implements Publisher<T> {
    private final T first;
    private final Publisher<? extends T> rest;

    public PrependingPublisher(T first, Publisher<? extends T> rest) {
        this.first = first;
        this.rest = rest;
    }

    @Override
    public void subscribe(Subscriber<? super T> subscriber) {
        Objects.requireNonNull(subscriber, "subscriber");
        RestSubscriber<? super T> restSubscriber = new RestSubscriber<T>(this.first, this.rest, subscriber);
        subscriber.onSubscribe(restSubscriber);
    }

    static final class RestSubscriber<T>
    implements Subscriber<T>,
    Subscription {
        private static final AtomicLongFieldUpdater<RestSubscriber> demandUpdater = AtomicLongFieldUpdater.newUpdater(RestSubscriber.class, "demand");
        private final T first;
        private final Publisher<? extends T> rest;
        private Subscriber<? super T> downstream;
        @Nullable
        private volatile Subscription upstream;
        private volatile long demand;
        private boolean firstSent;
        private boolean subscribed;
        private volatile boolean cancelled;

        RestSubscriber(T first, Publisher<? extends T> rest, Subscriber<? super T> downstream) {
            this.first = first;
            this.rest = rest;
            this.downstream = downstream;
        }

        @Override
        public void request(long n) {
            long demand;
            long newDemand;
            long demand2;
            if (n <= 0L) {
                this.downstream.onError(new IllegalArgumentException("non-positive request signals are illegal"));
                return;
            }
            if (this.cancelled) {
                return;
            }
            while (!demandUpdater.compareAndSet(this, demand2 = this.demand, newDemand = LongMath.saturatedAdd(demand2, n))) {
            }
            if (demand2 > 0L) {
                return;
            }
            if (!this.firstSent) {
                this.firstSent = true;
                this.downstream.onNext(this.first);
                if (this.demand != Long.MAX_VALUE) {
                    demandUpdater.decrementAndGet(this);
                }
            }
            if (!this.subscribed) {
                this.subscribed = true;
                this.rest.subscribe(this);
            }
            if (this.demand == 0L) {
                return;
            }
            Subscription upstream = this.upstream;
            if (upstream != null && (demand = this.demand) > 0L && demandUpdater.compareAndSet(this, demand, 0L)) {
                upstream.request(demand);
            }
        }

        @Override
        public void cancel() {
            if (this.cancelled) {
                return;
            }
            this.cancelled = true;
            this.downstream = NoopSubscriber.get();
            Subscription upstream = this.upstream;
            if (upstream != null) {
                upstream.cancel();
            }
        }

        @Override
        public void onSubscribe(Subscription subscription) {
            long demand;
            if (this.cancelled) {
                subscription.cancel();
                return;
            }
            this.upstream = subscription;
            while ((demand = this.demand) != 0L) {
                if (!demandUpdater.compareAndSet(this, demand, 0L)) continue;
                subscription.request(demand);
            }
        }

        @Override
        public void onNext(T t) {
            Objects.requireNonNull(t, "element");
            this.downstream.onNext(t);
        }

        @Override
        public void onError(Throwable t) {
            Objects.requireNonNull(t, "throwable");
            this.downstream.onError(t);
        }

        @Override
        public void onComplete() {
            this.downstream.onComplete();
        }
    }
}

