/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common.stream;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.stream.AbortedStreamException;
import com.linecorp.armeria.common.stream.AggregationSupport;
import com.linecorp.armeria.common.stream.CancelledSubscriptionException;
import com.linecorp.armeria.common.stream.StreamMessage;
import com.linecorp.armeria.common.stream.SubscriptionOption;
import com.linecorp.armeria.common.util.CompositeException;
import com.linecorp.armeria.common.util.EventLoopCheckingFuture;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.internal.common.stream.InternalStreamMessageUtil;
import com.linecorp.armeria.internal.common.stream.NeverInvokedSubscriber;
import com.linecorp.armeria.internal.common.stream.NoopSubscription;
import com.linecorp.armeria.internal.common.stream.StreamMessageUtil;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.ImmediateEventExecutor;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FixedStreamMessage<T>
extends AggregationSupport
implements StreamMessage<T>,
Subscription {
    private static final Logger logger = LoggerFactory.getLogger(FixedStreamMessage.class);
    private static final AtomicReferenceFieldUpdater<FixedStreamMessage, EventExecutor> executorUpdater = AtomicReferenceFieldUpdater.newUpdater(FixedStreamMessage.class, EventExecutor.class, "executor");
    private static final AtomicReferenceFieldUpdater<FixedStreamMessage, Throwable> abortCauseUpdater = AtomicReferenceFieldUpdater.newUpdater(FixedStreamMessage.class, Throwable.class, "abortCause");
    private final CompletableFuture<Void> completionFuture = new EventLoopCheckingFuture<Void>();
    @Nullable
    private Subscriber<T> subscriber;
    private boolean withPooledObjects;
    private boolean notifyCancellation;
    private boolean completed;
    @Nullable
    private volatile EventExecutor executor;
    @Nullable
    private volatile Throwable abortCause;

    abstract void cleanupObjects(@Nullable Throwable var1);

    abstract List<T> drainAll(boolean var1);

    EventExecutor executor() {
        return MoreObjects.firstNonNull(this.executor, ImmediateEventExecutor.INSTANCE);
    }

    @Override
    public boolean isOpen() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean isComplete() {
        return this.completed || this.completionFuture.isDone();
    }

    @Override
    public CompletableFuture<Void> whenComplete() {
        return this.completionFuture;
    }

    @Override
    public void subscribe(Subscriber<? super T> subscriber, EventExecutor executor, SubscriptionOption ... options) {
        Objects.requireNonNull(subscriber, "subscriber");
        Objects.requireNonNull(executor, "executor");
        Objects.requireNonNull(options, "options");
        if (this.isOpen()) {
            this.abortSubscriber(executor, subscriber, new IllegalStateException("a fixed stream is not closed yet"));
            return;
        }
        if (!executorUpdater.compareAndSet(this, null, executor)) {
            Throwable abortCause = this.abortCause;
            if (abortCause == null) {
                this.abortSubscriber(executor, subscriber, new IllegalStateException("subscribed by other subscriber already"));
            } else {
                this.abortSubscriber(executor, subscriber, abortCause);
            }
            return;
        }
        if (executor.inEventLoop()) {
            this.subscribe0(subscriber, executor, options);
        } else {
            executor.execute(() -> this.subscribe0(subscriber, executor, options));
        }
    }

    private void subscribe0(Subscriber<? super T> subscriber, EventExecutor executor, SubscriptionOption[] options) {
        this.subscriber = subscriber;
        for (SubscriptionOption option : options) {
            if (option == SubscriptionOption.WITH_POOLED_OBJECTS) {
                this.withPooledObjects = true;
                continue;
            }
            if (option != SubscriptionOption.NOTIFY_CANCELLATION) continue;
            this.notifyCancellation = true;
        }
        if (this.completed) {
            Throwable abortCause = this.abortCause;
            assert (abortCause != null);
            this.abortSubscriber(executor, subscriber, abortCause);
            return;
        }
        try {
            subscriber.onSubscribe(this);
            if (this.isEmpty()) {
                this.onComplete();
            }
        }
        catch (Throwable t) {
            this.cleanupObjects(t);
            this.onError(t);
            Exceptions.throwIfFatal(t);
            logger.warn("Subscriber.onSubscribe() should not raise an exception. subscriber: {}", (Object)subscriber, (Object)t);
        }
    }

    private void abortSubscriber(EventExecutor executor, Subscriber<? super T> subscriber, Throwable cause) {
        if (executor.inEventLoop()) {
            this.abortSubscriber0(subscriber, cause);
        } else {
            executor.execute(() -> this.abortSubscriber0(subscriber, cause));
        }
    }

    private void abortSubscriber0(Subscriber<? super T> subscriber, Throwable cause) {
        subscriber.onSubscribe(NoopSubscription.get());
        subscriber.onError(cause);
    }

    @Override
    public CompletableFuture<List<T>> collect(EventExecutor executor, SubscriptionOption ... options) {
        Objects.requireNonNull(executor, "executor");
        Objects.requireNonNull(options, "options");
        CompletableFuture<List<T>> collectingFuture = new CompletableFuture<List<T>>();
        if (executorUpdater.compareAndSet(this, null, executor)) {
            Throwable abortCause = this.abortCause;
            if (abortCause != null) {
                collectingFuture.completeExceptionally(abortCause);
                return collectingFuture;
            }
            if (executor.inEventLoop()) {
                this.collect(collectingFuture, executor, options, true);
            } else {
                executor.execute(() -> this.collect(collectingFuture, executor, options, false));
            }
        } else {
            Throwable abortCause = this.abortCause;
            if (abortCause != null) {
                collectingFuture.completeExceptionally(abortCause);
            } else {
                collectingFuture.completeExceptionally(new IllegalStateException("subscribed by other subscriber already"));
            }
        }
        return collectingFuture;
    }

    private void collect(CompletableFuture<List<T>> collectingFuture, EventExecutor executor, SubscriptionOption[] options, boolean directExecution) {
        if (this.completed) {
            Throwable abortCause = this.abortCause;
            assert (abortCause != null);
            if (directExecution) {
                collectingFuture.completeExceptionally(abortCause);
            } else {
                executor.execute(() -> collectingFuture.completeExceptionally(abortCause));
            }
            return;
        }
        this.completed = true;
        boolean withPooledObjects = InternalStreamMessageUtil.containsWithPooledObjects(options);
        collectingFuture.complete(this.drainAll(withPooledObjects));
        if (directExecution) {
            executor.execute(() -> this.whenComplete().complete(null));
        } else {
            this.whenComplete().complete(null);
        }
    }

    void onNext(T item) {
        assert (this.subscriber != null);
        try {
            this.subscriber.onNext(StreamMessageUtil.touchOrCopyAndClose(item, this.withPooledObjects));
        }
        catch (Throwable t) {
            this.abort1(t, true);
            Exceptions.throwIfFatal(t);
            logger.warn("Subscriber.onNext({}) should not raise an exception. subscriber: {}", item, this.subscriber, t);
        }
    }

    void onError(Throwable cause) {
        if (this.completed) {
            return;
        }
        this.completed = true;
        this.onError0(cause);
    }

    private void onError0(Throwable cause) {
        try {
            this.subscriber.onError(cause);
            if (!this.completionFuture.isDone()) {
                this.completionFuture.completeExceptionally(cause);
            }
        }
        catch (Throwable t) {
            CompositeException composite = new CompositeException(t, cause);
            this.completionFuture.completeExceptionally(composite);
            Exceptions.throwIfFatal(t);
            logger.warn("Subscriber.onError() should not raise an exception. subscriber: {}", (Object)this.subscriber, (Object)composite);
        }
    }

    void onComplete() {
        if (this.completed) {
            return;
        }
        this.completed = true;
        assert (this.subscriber != null);
        try {
            this.subscriber.onComplete();
            this.completionFuture.complete(null);
        }
        catch (Throwable t) {
            this.completionFuture.completeExceptionally(t);
            Exceptions.throwIfFatal(t);
            logger.warn("Subscriber.onComplete() should not raise an exception. subscriber: {}", (Object)this.subscriber, (Object)t);
        }
    }

    @Override
    public void cancel() {
        EventExecutor executor = this.executor();
        if (executor.inEventLoop()) {
            this.cancel0();
        } else {
            executor.execute(this::cancel0);
        }
    }

    private void cancel0() {
        if (this.completed) {
            return;
        }
        this.completed = true;
        CancelledSubscriptionException cause = CancelledSubscriptionException.get();
        this.cleanupObjects(cause);
        if (this.notifyCancellation) {
            this.onError0(cause);
        } else {
            this.completionFuture.completeExceptionally(cause);
        }
        this.subscriber = NeverInvokedSubscriber.get();
    }

    @Override
    public void abort() {
        this.abort0(null);
    }

    @Override
    public void abort(Throwable cause) {
        Objects.requireNonNull(cause, "cause");
        this.abort0(cause);
    }

    private void abort0(@Nullable Throwable cause) {
        Throwable finalCause;
        if (this.completed) {
            return;
        }
        Throwable throwable = finalCause = cause != null ? cause : AbortedStreamException.get();
        if (!abortCauseUpdater.compareAndSet(this, null, finalCause)) {
            return;
        }
        if (executorUpdater.compareAndSet(this, null, ImmediateEventExecutor.INSTANCE)) {
            this.abort1(finalCause, false);
        } else {
            EventExecutor executor = this.executor;
            assert (executor != null);
            if (executor.inEventLoop()) {
                this.abort1(finalCause, true);
            } else {
                executor.execute(() -> this.abort1(finalCause, true));
            }
        }
    }

    private void abort1(Throwable cause, boolean subscribed) {
        if (this.completed) {
            return;
        }
        this.completed = true;
        this.cleanupObjects(cause);
        if (subscribed) {
            Subscriber<T> subscriber = this.subscriber;
            if (subscriber != null) {
                this.onError0(cause);
            } else {
                this.completionFuture.completeExceptionally(cause);
            }
        } else {
            this.completionFuture.completeExceptionally(cause);
        }
    }
}

