/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.client.dns;

import com.linecorp.armeria.client.DnsCache;
import com.linecorp.armeria.common.util.AbstractUnwrappable;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.common.util.UnmodifiableFuture;
import com.linecorp.armeria.internal.client.dns.ByteArrayDnsRecord;
import com.linecorp.armeria.internal.client.dns.DnsQuestionContext;
import com.linecorp.armeria.internal.client.dns.DnsResolver;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import io.netty.handler.codec.dns.DnsQuestion;
import io.netty.handler.codec.dns.DnsRecord;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CachingDnsResolver
extends AbstractUnwrappable<DnsResolver>
implements DnsResolver {
    private static final Logger logger = LoggerFactory.getLogger(CachingDnsResolver.class);
    private final Map<DnsQuestion, CompletableFuture<List<DnsRecord>>> inflightRequests = new ConcurrentHashMap<DnsQuestion, CompletableFuture<List<DnsRecord>>>();
    private final DnsCache dnsCache;

    CachingDnsResolver(DnsResolver delegate, DnsCache dnsCache) {
        super(delegate);
        this.dnsCache = dnsCache;
    }

    @Override
    public CompletableFuture<List<DnsRecord>> resolve(DnsQuestionContext ctx, DnsQuestion question) {
        try {
            List<DnsRecord> dnsRecords = this.dnsCache.get(question);
            if (dnsRecords != null) {
                return UnmodifiableFuture.completedFuture(dnsRecords);
            }
            return this.resolve0(ctx, question);
        }
        catch (UnknownHostException e) {
            return UnmodifiableFuture.exceptionallyCompletedFuture(e);
        }
    }

    private CompletableFuture<List<DnsRecord>> resolve0(DnsQuestionContext ctx, DnsQuestion question) {
        CompletableFuture future = this.inflightRequests.computeIfAbsent(question, key -> {
            try {
                List<DnsRecord> dnsRecords = this.dnsCache.get((DnsQuestion)key);
                if (dnsRecords != null) {
                    return UnmodifiableFuture.completedFuture(dnsRecords);
                }
            }
            catch (UnknownHostException e) {
                return UnmodifiableFuture.exceptionallyCompletedFuture(e);
            }
            return ((DnsResolver)this.unwrap()).resolve(ctx, (DnsQuestion)key).handle((records, cause) -> {
                if (records != null) {
                    List copied = records.stream().map(ByteArrayDnsRecord::copyOf).collect(ImmutableList.toImmutableList());
                    logger.debug("[{}] Caching DNS records: {}", (Object)question.name(), (Object)copied);
                    this.dnsCache.cache((DnsQuestion)key, copied);
                    return copied;
                }
                if ((cause = Exceptions.peel(cause)) instanceof UnknownHostException) {
                    logger.debug("[{}] Caching a failed DNS query: {}, cause: {}", question.name(), question, cause.getMessage());
                    this.dnsCache.cache((DnsQuestion)key, (UnknownHostException)cause);
                }
                return (List)Exceptions.throwUnsafely(cause);
            });
        });
        future.handle((unused0, unused1) -> this.inflightRequests.remove(question));
        return future;
    }

    @Override
    public void close() {
        ((DnsResolver)this.unwrap()).close();
    }
}

