/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.util;

import com.google.errorprone.annotations.concurrent.GuardedBy;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.ThreadFactories;
import com.linecorp.armeria.internal.common.util.ReentrantShortLock;
import java.util.ArrayDeque;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ShutdownHooks {
    private static final Logger logger = LoggerFactory.getLogger(ShutdownHooks.class);
    @GuardedBy(value="reentrantLock")
    private static final Map<AutoCloseable, Queue<Runnable>> autoCloseableOnShutdownTasks = new LinkedHashMap<AutoCloseable, Queue<Runnable>>();
    private static final ReentrantLock reentrantLock = new ReentrantShortLock();
    private static final ThreadFactory THREAD_FACTORY = ThreadFactories.builder("armeria-shutdown-hook").build();
    private static boolean addedShutdownHook;

    public static CompletableFuture<Void> addClosingTask(AutoCloseable autoCloseable) {
        return ShutdownHooks.addClosingTask(autoCloseable, null, autoCloseable.getClass().getSimpleName());
    }

    public static CompletableFuture<Void> addClosingTask(AutoCloseable autoCloseable, Runnable whenClosing) {
        Objects.requireNonNull(whenClosing, "whenClosing");
        return ShutdownHooks.addClosingTask(autoCloseable, whenClosing, autoCloseable.getClass().getSimpleName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CompletableFuture<Void> addClosingTask(AutoCloseable autoCloseable, @Nullable Runnable whenClosing, String name) {
        CompletableFuture<Void> closeFuture = new CompletableFuture<Void>();
        Runnable task = () -> {
            if (whenClosing != null) {
                try {
                    whenClosing.run();
                }
                catch (Exception e) {
                    logger.warn("Unexpected exception while running a shutdown callback:", e);
                }
            }
            try {
                autoCloseable.close();
                logger.debug("{} has been closed.", (Object)name);
                closeFuture.complete(null);
            }
            catch (Throwable cause) {
                logger.warn("Unexpected exception while closing a {}.", (Object)name, (Object)cause);
                closeFuture.completeExceptionally(cause);
            }
        };
        reentrantLock.lock();
        try {
            Queue onShutdownTasks = autoCloseableOnShutdownTasks.computeIfAbsent(autoCloseable, key -> new ArrayDeque());
            onShutdownTasks.add(task);
            if (!addedShutdownHook) {
                Runtime.getRuntime().addShutdownHook(THREAD_FACTORY.newThread(() -> {
                    reentrantLock.lock();
                    try {
                        autoCloseableOnShutdownTasks.forEach((factory, queue) -> {
                            Runnable onShutdown;
                            while ((onShutdown = (Runnable)queue.poll()) != null) {
                                onShutdown.run();
                            }
                        });
                    }
                    finally {
                        reentrantLock.unlock();
                    }
                }));
                addedShutdownHook = true;
            }
        }
        finally {
            reentrantLock.unlock();
        }
        return closeFuture;
    }

    private ShutdownHooks() {
    }
}

