/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.stream;

import com.linecorp.armeria.common.CommonPools;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.stream.AsyncFileWriter;
import com.linecorp.armeria.common.stream.StreamMessage;
import com.linecorp.armeria.common.util.BlockingTaskExecutor;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.armeria.server.ServiceRequestContext;
import io.netty.channel.EventLoop;
import io.netty.util.concurrent.EventExecutor;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;

public final class StreamMessages {
    public static CompletableFuture<Void> writeTo(StreamMessage<? extends HttpData> publisher, Path destination, OpenOption ... options) {
        Objects.requireNonNull(publisher, "publisher");
        Objects.requireNonNull(destination, "destination");
        Objects.requireNonNull(options, "options");
        Object ctx = RequestContext.currentOrNull();
        EventLoop eventExecutor = null;
        BlockingTaskExecutor blockingTaskExecutor = null;
        if (ctx != null) {
            eventExecutor = ctx.eventLoop();
            if (ctx instanceof ServiceRequestContext) {
                blockingTaskExecutor = ((ServiceRequestContext)ctx).blockingTaskExecutor();
            }
        }
        if (eventExecutor == null) {
            eventExecutor = CommonPools.workerGroup().next();
        }
        if (blockingTaskExecutor == null) {
            blockingTaskExecutor = CommonPools.blockingTaskExecutor();
        }
        return StreamMessages.writeTo(publisher, destination, eventExecutor, blockingTaskExecutor, options);
    }

    public static CompletableFuture<Void> writeTo(StreamMessage<? extends HttpData> publisher, Path destination, EventExecutor eventExecutor, ExecutorService blockingTaskExecutor, OpenOption ... options) {
        Objects.requireNonNull(publisher, "publisher");
        Objects.requireNonNull(destination, "destination");
        Objects.requireNonNull(eventExecutor, "eventExecutor");
        Objects.requireNonNull(blockingTaskExecutor, "blockingTaskExecutor");
        Objects.requireNonNull(options, "options");
        Set<OpenOption> writeOptions = StreamMessages.checkWriteOptions(options);
        return new AsyncFileWriter(publisher, destination, writeOptions, eventExecutor, blockingTaskExecutor).whenComplete();
    }

    private static Set<OpenOption> checkWriteOptions(OpenOption[] options) {
        int length = options.length;
        ImmutableSet.Builder writeOptions = ImmutableSet.builderWithExpectedSize(length + 3);
        if (length == 0) {
            writeOptions.add(StandardOpenOption.CREATE);
            writeOptions.add(StandardOpenOption.TRUNCATE_EXISTING);
        } else {
            for (OpenOption opt : options) {
                if (opt == StandardOpenOption.READ) {
                    throw new IllegalArgumentException("READ not allowed");
                }
                writeOptions.add(opt);
            }
        }
        writeOptions.add(StandardOpenOption.WRITE);
        return writeOptions.build();
    }

    private StreamMessages() {
    }
}

