/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.stream;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.stream.AbortedStreamException;
import com.linecorp.armeria.common.stream.AbstractStreamWriter;
import com.linecorp.armeria.common.stream.CancellableStreamMessage;
import com.linecorp.armeria.common.stream.CancelledSubscriptionException;
import com.linecorp.armeria.common.stream.ClosedStreamException;
import com.linecorp.armeria.common.stream.SubscriptionOption;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.internal.common.stream.AbortingSubscriber;
import com.linecorp.armeria.internal.common.stream.InternalStreamMessageUtil;
import com.linecorp.armeria.internal.common.stream.StreamMessageUtil;
import com.linecorp.armeria.internal.shaded.jctools.queues.MpscChunkedArrayQueue;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.ImmediateEventExecutor;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.reactivestreams.Subscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultStreamMessage<T>
extends AbstractStreamWriter<T> {
    private static final Logger logger = LoggerFactory.getLogger(DefaultStreamMessage.class);
    private static final AtomicReferenceFieldUpdater<DefaultStreamMessage, CancellableStreamMessage.SubscriptionImpl> subscriptionUpdater = AtomicReferenceFieldUpdater.newUpdater(DefaultStreamMessage.class, CancellableStreamMessage.SubscriptionImpl.class, "subscription");
    private static final AtomicReferenceFieldUpdater<DefaultStreamMessage, AbstractStreamWriter.State> stateUpdater = AtomicReferenceFieldUpdater.newUpdater(DefaultStreamMessage.class, AbstractStreamWriter.State.class, "state");
    private static final int INITIAL_CAPACITY = 32;
    private final Queue<Object> queue;
    @Nullable
    private Throwable cleanupCause;
    @Nullable
    private volatile CancellableStreamMessage.SubscriptionImpl subscription;
    private long demand;
    private volatile AbstractStreamWriter.State state = AbstractStreamWriter.State.OPEN;
    private volatile boolean wroteAny;
    private boolean inOnNext;
    private boolean invokedOnSubscribe;

    @Deprecated
    public DefaultStreamMessage() {
        this.queue = new MpscChunkedArrayQueue<Object>(32, 0x40000000);
    }

    @Override
    public final boolean isOpen() {
        return this.state == AbstractStreamWriter.State.OPEN;
    }

    @Override
    public final boolean isEmpty() {
        return !this.isOpen() && !this.wroteAny;
    }

    @Override
    CancellableStreamMessage.SubscriptionImpl subscribe(CancellableStreamMessage.SubscriptionImpl subscription) {
        if (!subscriptionUpdater.compareAndSet(this, null, subscription)) {
            CancellableStreamMessage.SubscriptionImpl oldSubscription = this.subscription;
            assert (oldSubscription != null);
            return oldSubscription;
        }
        Subscriber<Object> subscriber = subscription.subscriber();
        if (subscription.needsDirectInvocation()) {
            this.subscribe(subscription, subscriber);
        } else {
            subscription.executor().execute(() -> this.subscribe(subscription, subscriber));
        }
        return subscription;
    }

    private void subscribe(CancellableStreamMessage.SubscriptionImpl subscription, Subscriber<Object> subscriber) {
        try {
            this.subscribe0(subscription.executor(), subscription.options());
            this.invokedOnSubscribe = true;
            subscriber.onSubscribe(subscription);
            if (!this.queue.isEmpty()) {
                this.notifySubscriber0();
            }
        }
        catch (Throwable t) {
            if (this.setState(AbstractStreamWriter.State.OPEN, AbstractStreamWriter.State.CLEANUP) || this.setState(AbstractStreamWriter.State.CLOSED, AbstractStreamWriter.State.CLEANUP)) {
                this.notifySubscriberOfCloseEvent(subscription, DefaultStreamMessage.newCloseEvent(t));
                Exceptions.throwIfFatal(t);
            }
            Exceptions.throwIfFatal(t);
            logger.warn("Subscriber.onSubscribe() should not raise an exception. subscriber: {}", (Object)subscriber, (Object)t);
        }
    }

    protected void subscribe0(EventExecutor executor, SubscriptionOption[] options) {
    }

    protected void onRequest(long n) {
    }

    @Override
    public final void abort() {
        this.abort0(null);
    }

    @Override
    public final void abort(Throwable cause) {
        Objects.requireNonNull(cause, "cause");
        this.abort0(cause);
    }

    private void abort0(@Nullable Throwable cause) {
        CancellableStreamMessage.SubscriptionImpl subscription;
        if (this.state == AbstractStreamWriter.State.CLEANUP) {
            return;
        }
        if (cause == null) {
            cause = AbortedStreamException.get();
        }
        if ((subscription = this.subscription) == null) {
            CancellableStreamMessage.SubscriptionImpl newSubscription = new CancellableStreamMessage.SubscriptionImpl(this, AbortingSubscriber.get(cause), ImmediateEventExecutor.INSTANCE, InternalStreamMessageUtil.EMPTY_OPTIONS);
            if (subscriptionUpdater.compareAndSet(this, null, newSubscription)) {
                this.invokedOnSubscribe = true;
                subscription = newSubscription;
            } else {
                subscription = this.subscription;
            }
        }
        assert (subscription != null);
        CancellableStreamMessage.SubscriptionImpl abortedSubscription = subscription;
        if (this.setState(AbstractStreamWriter.State.OPEN, AbstractStreamWriter.State.CLEANUP)) {
            this.notifySubscriberOfCloseEvent(abortedSubscription, DefaultStreamMessage.newCloseEvent(cause));
            return;
        }
        if (this.setState(AbstractStreamWriter.State.CLOSED, AbstractStreamWriter.State.CLEANUP)) {
            if (abortedSubscription.needsDirectInvocation()) {
                this.abort0(cause, abortedSubscription);
            } else {
                Throwable finalCause = cause;
                abortedSubscription.executor().execute(() -> this.abort0(finalCause, abortedSubscription));
            }
        }
    }

    private void abort0(Throwable cause, CancellableStreamMessage.SubscriptionImpl subscription) {
        Object o = this.queue.peek();
        if (!this.wroteAny && o instanceof CancellableStreamMessage.CloseEvent) {
            this.notifySubscriberOfCloseEvent(subscription, (CancellableStreamMessage.CloseEvent)this.queue.remove());
            return;
        }
        this.notifySubscriberOfCloseEvent(subscription, DefaultStreamMessage.newCloseEvent(cause));
    }

    @Override
    final void addObject(T obj) {
        this.wroteAny = true;
        this.addObjectOrEvent(obj);
    }

    @Override
    public final long demand() {
        return this.demand;
    }

    @Override
    final void request(long n) {
        CancellableStreamMessage.SubscriptionImpl subscription = this.subscription;
        assert (subscription != null);
        if (subscription.needsDirectInvocation()) {
            this.doRequest(n);
        } else {
            subscription.executor().execute(() -> this.doRequest(n));
        }
    }

    private void doRequest(long n) {
        long oldDemand = this.demand;
        this.demand = oldDemand >= Long.MAX_VALUE - n ? Long.MAX_VALUE : oldDemand + n;
        this.onRequest(n);
        if (oldDemand == 0L && !this.queue.isEmpty()) {
            this.notifySubscriber0();
        }
    }

    @Override
    final void cancel() {
        if (this.setState(AbstractStreamWriter.State.OPEN, AbstractStreamWriter.State.CLEANUP) || this.setState(AbstractStreamWriter.State.CLOSED, AbstractStreamWriter.State.CLEANUP)) {
            CancellableStreamMessage.SubscriptionImpl subscription = this.subscription;
            assert (subscription != null);
            this.notifySubscriberOfCloseEvent(subscription, CANCELLED_CLOSE);
        }
    }

    private void notifySubscriberOfCloseEvent(CancellableStreamMessage.SubscriptionImpl subscription, CancellableStreamMessage.CloseEvent event) {
        if (subscription.needsDirectInvocation()) {
            this.notifySubscriberOfCloseEvent0(subscription, event);
        } else {
            subscription.executor().execute(() -> this.notifySubscriberOfCloseEvent0(subscription, event));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifySubscriberOfCloseEvent0(CancellableStreamMessage.SubscriptionImpl subscription, CancellableStreamMessage.CloseEvent event) {
        try {
            event.notifySubscriber(subscription, this.whenComplete());
        }
        finally {
            subscription.clearSubscriber();
            Throwable cause = event.cause;
            if (this.state == AbstractStreamWriter.State.CLEANUP) {
                this.cleanupCause = cause;
            }
            this.cleanupObjects(cause);
        }
    }

    @Override
    final void addObjectOrEvent(Object obj) {
        this.queue.add(obj);
        this.notifySubscriber();
    }

    final void notifySubscriber() {
        CancellableStreamMessage.SubscriptionImpl subscription = this.subscription;
        if (subscription == null) {
            return;
        }
        if (this.queue.isEmpty()) {
            return;
        }
        if (subscription.needsDirectInvocation()) {
            this.notifySubscriber0();
        } else {
            subscription.executor().execute(this::notifySubscriber0);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void notifySubscriber0() {
        if (this.inOnNext) {
            return;
        }
        CancellableStreamMessage.SubscriptionImpl subscription = this.subscription;
        if (!this.invokedOnSubscribe) {
            return;
        }
        while (true) {
            if (this.state == AbstractStreamWriter.State.CLEANUP) {
                this.cleanupObjects(null);
                return;
            }
            Object o = this.queue.peek();
            if (o == null) return;
            if (o instanceof CancellableStreamMessage.CloseEvent) {
                this.handleCloseEvent(subscription, (CancellableStreamMessage.CloseEvent)this.queue.remove());
                return;
            }
            if (o instanceof AbstractStreamWriter.AwaitDemandFuture) {
                this.notifyAwaitDemandFuture();
                continue;
            }
            if (!this.notifySubscriberWithElements(subscription)) return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean notifySubscriberWithElements(CancellableStreamMessage.SubscriptionImpl subscription) {
        Subscriber<Object> subscriber = subscription.subscriber();
        if (this.demand == 0L) {
            return false;
        }
        if (this.demand != Long.MAX_VALUE) {
            --this.demand;
        }
        Object o = this.queue.remove();
        this.inOnNext = true;
        try {
            o = this.prepareObjectForNotification(o, subscription.withPooledObjects());
            subscriber.onNext(o);
        }
        catch (Throwable t) {
            if (this.setState(AbstractStreamWriter.State.OPEN, AbstractStreamWriter.State.CLEANUP) || this.setState(AbstractStreamWriter.State.CLOSED, AbstractStreamWriter.State.CLEANUP)) {
                this.notifySubscriberOfCloseEvent(subscription, DefaultStreamMessage.newCloseEvent(t));
                Exceptions.throwIfFatal(t);
            } else {
                Exceptions.throwIfFatal(t);
                logger.warn("Subscriber.onNext({}) should not raise an exception. subscriber: {}", o, subscriber, t);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.inOnNext = false;
        }
        return true;
    }

    private void notifyAwaitDemandFuture() {
        CompletableFuture f = (CompletableFuture)this.queue.remove();
        f.complete(null);
    }

    private void handleCloseEvent(CancellableStreamMessage.SubscriptionImpl subscription, CancellableStreamMessage.CloseEvent o) {
        if (this.setState(AbstractStreamWriter.State.CLOSED, AbstractStreamWriter.State.CLEANUP)) {
            this.notifySubscriberOfCloseEvent(subscription, o);
        }
    }

    @Override
    public void close() {
        if (this.setState(AbstractStreamWriter.State.OPEN, AbstractStreamWriter.State.CLOSED)) {
            this.addObjectOrEvent(SUCCESSFUL_CLOSE);
        }
    }

    @Override
    public final void close(Throwable cause) {
        Objects.requireNonNull(cause, "cause");
        if (cause instanceof CancelledSubscriptionException) {
            throw new IllegalArgumentException("cause: " + cause + " (must use Subscription.cancel())");
        }
        this.tryClose(cause);
    }

    public final boolean tryClose(Throwable cause) {
        if (this.setState(AbstractStreamWriter.State.OPEN, AbstractStreamWriter.State.CLOSED)) {
            this.addObjectOrEvent(new CancellableStreamMessage.CloseEvent(cause));
            return true;
        }
        return false;
    }

    private boolean setState(AbstractStreamWriter.State oldState, AbstractStreamWriter.State newState) {
        assert (newState != AbstractStreamWriter.State.OPEN) : "oldState: " + (Object)((Object)oldState) + ", newState: " + (Object)((Object)newState);
        return stateUpdater.compareAndSet(this, oldState, newState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupObjects(@Nullable Throwable cause) {
        Object e;
        while ((e = this.queue.poll()) != null) {
            if (e instanceof CancellableStreamMessage.CloseEvent) continue;
            if (e instanceof CompletableFuture) {
                if (cause == null) {
                    cause = ClosedStreamException.get();
                }
                ((CompletableFuture)e).completeExceptionally(cause);
                continue;
            }
            try {
                Object obj = e;
                this.onRemoval(obj);
            }
            finally {
                StreamMessageUtil.closeOrAbort(e, this.cleanupCause);
            }
        }
    }
}

