/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.logging;

import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.internal.shaded.fastutil.objects.Object2ObjectMap;
import com.linecorp.armeria.internal.shaded.fastutil.objects.Object2ObjectMaps;
import com.linecorp.armeria.internal.shaded.fastutil.objects.Object2ObjectOpenHashMap;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.server.ServiceRequestContext;
import io.netty.util.AttributeKey;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.slf4j.spi.MDCAdapter;

public final class RequestScopedMdc {
    private static final Logger logger;
    private static final AttributeKey<Object2ObjectMap<String, String>> MAP;
    private static final String ERROR_MESSAGE;
    @Nullable
    private static final MDCAdapter delegate;
    @Nullable
    private static final MethodHandle delegateGetPropertyMap;

    @Nullable
    public static String get(RequestContext ctx, String key) {
        Objects.requireNonNull(ctx, "ctx");
        Objects.requireNonNull(key, "key");
        String value = (String)RequestScopedMdc.getMap(ctx).get(key);
        if (value != null) {
            return value;
        }
        ServiceRequestContext rootCtx = ctx.root();
        if (rootCtx != null && rootCtx != ctx) {
            return (String)RequestScopedMdc.getMap(rootCtx).get(key);
        }
        return null;
    }

    public static Map<String, String> getAll(RequestContext ctx) {
        Objects.requireNonNull(ctx, "ctx");
        Object2ObjectMap<String, String> map = RequestScopedMdc.getMap(ctx);
        ServiceRequestContext rootCtx = ctx.root();
        if (rootCtx == null || rootCtx == ctx) {
            return map;
        }
        Object2ObjectMap<String, String> rootMap = RequestScopedMdc.getMap(rootCtx);
        if (rootMap.isEmpty()) {
            return map;
        }
        if (map.isEmpty()) {
            return rootMap;
        }
        Object2ObjectOpenHashMap<String, String> merged = new Object2ObjectOpenHashMap<String, String>(rootMap.size() + map.size());
        merged.putAll(rootMap);
        merged.putAll(map);
        return merged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void put(RequestContext ctx, String key, @Nullable String value) {
        Objects.requireNonNull(ctx, "ctx");
        Objects.requireNonNull(key, "key");
        RequestContext requestContext = ctx;
        synchronized (requestContext) {
            Object2ObjectMap<String, String> newMap;
            Object2ObjectMap<String, String> oldMap = RequestScopedMdc.getMap(ctx);
            if (oldMap.isEmpty()) {
                newMap = Object2ObjectMaps.singleton(key, value);
            } else {
                Object2ObjectOpenHashMap<String, String> tmp = new Object2ObjectOpenHashMap<String, String>(oldMap.size() + 1);
                tmp.putAll(oldMap);
                tmp.put(key, value);
                newMap = Object2ObjectMaps.unmodifiable(tmp);
            }
            ctx.setAttr(MAP, newMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putAll(RequestContext ctx, Map<String, String> map) {
        Objects.requireNonNull(ctx, "ctx");
        Objects.requireNonNull(map, "map");
        if (map.isEmpty()) {
            return;
        }
        RequestContext requestContext = ctx;
        synchronized (requestContext) {
            Object2ObjectOpenHashMap<String, String> newMap;
            Object2ObjectMap<String, String> oldMap = RequestScopedMdc.getMap(ctx);
            if (oldMap.isEmpty()) {
                newMap = new Object2ObjectOpenHashMap<String, String>(map);
            } else {
                newMap = new Object2ObjectOpenHashMap(oldMap.size() + map.size());
                newMap.putAll(oldMap);
                newMap.putAll(map);
            }
            ctx.setAttr(MAP, Object2ObjectMaps.unmodifiable(newMap));
        }
    }

    public static void copy(RequestContext ctx, String key) {
        Objects.requireNonNull(ctx, "ctx");
        Objects.requireNonNull(key, "key");
        Preconditions.checkState(delegate != null, ERROR_MESSAGE);
        RequestScopedMdc.put(ctx, key, delegate.get(key));
    }

    public static void copyAll(RequestContext ctx) {
        Objects.requireNonNull(ctx, "ctx");
        Preconditions.checkState(delegate != null, ERROR_MESSAGE);
        Map<String, String> map = RequestScopedMdc.getDelegateContextMap();
        if (map != null) {
            RequestScopedMdc.putAll(ctx, map);
        }
    }

    @Nullable
    private static Map<String, String> getDelegateContextMap() {
        assert (delegate != null);
        try {
            Map<String, String> map = delegateGetPropertyMap != null ? delegateGetPropertyMap.invokeExact() : delegate.getCopyOfContextMap();
            return map;
        }
        catch (Throwable t) {
            Exceptions.throwUnsafely(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(RequestContext ctx, String key) {
        Objects.requireNonNull(ctx, "ctx");
        Objects.requireNonNull(key, "key");
        RequestContext requestContext = ctx;
        synchronized (requestContext) {
            Object2ObjectMap<Object, Object> newMap;
            Object2ObjectMap<String, String> oldMap = RequestScopedMdc.getMap(ctx);
            if (!oldMap.containsKey(key)) {
                return;
            }
            if (oldMap.size() == 1) {
                newMap = Object2ObjectMaps.emptyMap();
            } else {
                Object2ObjectOpenHashMap<String, String> tmp = new Object2ObjectOpenHashMap<String, String>(oldMap);
                tmp.remove(key);
                newMap = Object2ObjectMaps.unmodifiable(tmp);
            }
            ctx.setAttr(MAP, newMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear(RequestContext ctx) {
        Objects.requireNonNull(ctx, "ctx");
        RequestContext requestContext = ctx;
        synchronized (requestContext) {
            Object2ObjectMap<String, String> oldMap = RequestScopedMdc.getMap(ctx);
            if (!oldMap.isEmpty()) {
                ctx.setAttr(MAP, Object2ObjectMaps.emptyMap());
            }
        }
    }

    private static Object2ObjectMap<String, String> getMap(RequestContext ctx) {
        Object2ObjectMap<String, String> map = ctx.ownAttr(MAP);
        return MoreObjects.firstNonNull(map, Object2ObjectMaps.emptyMap());
    }

    private RequestScopedMdc() {
    }

    static {
        MDCAdapter oldAdapter;
        logger = LoggerFactory.getLogger(RequestScopedMdc.class);
        MAP = AttributeKey.valueOf(RequestScopedMdc.class, "map");
        ERROR_MESSAGE = "Failed to replace the " + MDCAdapter.class.getSimpleName() + "; " + RequestScopedMdc.class.getSimpleName() + " will not work.";
        MDC.get("");
        try {
            Field mdcAdapterField = MDC.class.getDeclaredField("mdcAdapter");
            mdcAdapterField.setAccessible(true);
            oldAdapter = (MDCAdapter)mdcAdapterField.get(null);
            mdcAdapterField.set(null, new Adapter(oldAdapter));
        }
        catch (Throwable t) {
            oldAdapter = null;
            logger.warn(ERROR_MESSAGE, t);
        }
        delegate = oldAdapter;
        MethodHandle oldAdapterGetPropertyMap = null;
        if (delegate != null) {
            try {
                oldAdapterGetPropertyMap = MethodHandles.publicLookup().findVirtual(oldAdapter.getClass(), "getPropertyMap", MethodType.methodType(Map.class)).bindTo(delegate);
                Map map = oldAdapterGetPropertyMap.invokeExact();
                logger.trace("Retrieved MDC property map via getPropertyMap(): {}", (Object)map);
                logger.debug("Using MDCAdapter.getPropertyMap()");
            }
            catch (Throwable t) {
                oldAdapterGetPropertyMap = null;
                logger.debug("getPropertyMap() is not available:", t);
            }
        }
        delegateGetPropertyMap = oldAdapterGetPropertyMap;
    }

    private static final class Adapter
    implements MDCAdapter {
        private final MDCAdapter delegate;

        Adapter(MDCAdapter delegate) {
            this.delegate = Objects.requireNonNull(delegate, "delegate");
        }

        @Override
        @Nullable
        public String get(String key) {
            String value;
            Object ctx = RequestContext.currentOrNull();
            if (ctx != null && (value = RequestScopedMdc.get(ctx, key)) != null) {
                return value;
            }
            return this.delegate.get(key);
        }

        @Override
        public Map<String, String> getCopyOfContextMap() {
            Object2ObjectOpenHashMap<String, String> merged;
            Map threadLocalMap = RequestScopedMdc.getDelegateContextMap();
            Object ctx = RequestContext.currentOrNull();
            if (ctx == null) {
                if (threadLocalMap != null) {
                    return Adapter.maybeCloneThreadLocalMap(threadLocalMap);
                }
                return Object2ObjectMaps.emptyMap();
            }
            Map<String, String> requestScopedMap = RequestScopedMdc.getAll(ctx);
            if (threadLocalMap == null || threadLocalMap.isEmpty()) {
                return requestScopedMap;
            }
            if (requestScopedMap.isEmpty()) {
                return Adapter.maybeCloneThreadLocalMap(threadLocalMap);
            }
            if (requestScopedMap instanceof Object2ObjectOpenHashMap) {
                merged = (Object2ObjectOpenHashMap<String, String>)requestScopedMap;
                threadLocalMap.forEach(merged::putIfAbsent);
            } else {
                merged = new Object2ObjectOpenHashMap<String, String>(threadLocalMap.size() + requestScopedMap.size());
                merged.putAll(threadLocalMap);
                merged.putAll(requestScopedMap);
            }
            return merged;
        }

        private static Map<String, String> maybeCloneThreadLocalMap(Map<String, String> threadLocalMap) {
            return delegateGetPropertyMap != null ? new Object2ObjectOpenHashMap(threadLocalMap) : threadLocalMap;
        }

        @Override
        public void put(String key, @Nullable String val) {
            this.delegate.put(key, val);
        }

        @Override
        public void remove(String key) {
            this.delegate.remove(key);
        }

        @Override
        public void clear() {
            this.delegate.clear();
        }

        @Override
        public void setContextMap(Map<String, String> contextMap) {
            this.delegate.setContextMap(contextMap);
        }
    }
}

