/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.logging;

import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.HttpStatusClass;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.logging.DefaultLogWriter;
import com.linecorp.armeria.common.logging.LogFormatter;
import com.linecorp.armeria.common.logging.LogLevel;
import com.linecorp.armeria.common.logging.LogWriter;
import com.linecorp.armeria.common.logging.RequestLogLevelMapper;
import com.linecorp.armeria.common.logging.ResponseLogLevelMapper;
import java.util.Objects;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LogWriterBuilder {
    static final LogLevel DEFAULT_REQUEST_LOG_LEVEL = LogLevel.DEBUG;
    static final RequestLogLevelMapper DEFAULT_REQUEST_LOG_LEVEL_MAPPER = RequestLogLevelMapper.of(DEFAULT_REQUEST_LOG_LEVEL);
    static final ResponseLogLevelMapper DEFAULT_RESPONSE_LOG_LEVEL_MAPPER = ResponseLogLevelMapper.of(LogLevel.DEBUG, LogLevel.WARN);
    private Logger logger = DefaultLogWriter.defaultLogger;
    @Nullable
    private RequestLogLevelMapper requestLogLevelMapper;
    @Nullable
    private ResponseLogLevelMapper responseLogLevelMapper;
    private Predicate<? super Throwable> responseCauseFilter = throwable -> false;
    private LogFormatter logFormatter = LogFormatter.ofText();

    LogWriterBuilder() {
    }

    public LogWriterBuilder logger(Logger logger) {
        this.logger = Objects.requireNonNull(logger, "logger");
        return this;
    }

    public LogWriterBuilder logger(String loggerName) {
        Objects.requireNonNull(loggerName, "loggerName");
        this.logger = LoggerFactory.getLogger(loggerName);
        return this;
    }

    public LogWriterBuilder requestLogLevel(LogLevel requestLogLevel) {
        Objects.requireNonNull(requestLogLevel, "requestLogLevel");
        return this.requestLogLevelMapper(RequestLogLevelMapper.of(requestLogLevel));
    }

    public LogWriterBuilder requestLogLevel(Class<? extends Throwable> clazz, LogLevel requestLogLevel) {
        Objects.requireNonNull(clazz, "clazz");
        Objects.requireNonNull(requestLogLevel, "requestLogLevel");
        return this.requestLogLevelMapper(RequestLogLevelMapper.of(clazz, requestLogLevel));
    }

    public LogWriterBuilder requestLogLevelMapper(RequestLogLevelMapper requestLogLevelMapper) {
        Objects.requireNonNull(requestLogLevelMapper, "requestLogLevelMapper");
        this.requestLogLevelMapper = this.requestLogLevelMapper == null ? requestLogLevelMapper : this.requestLogLevelMapper.orElse(requestLogLevelMapper);
        return this;
    }

    private RequestLogLevelMapper requestLogLevelMapper() {
        if (this.requestLogLevelMapper == null) {
            return DEFAULT_REQUEST_LOG_LEVEL_MAPPER;
        }
        return this.requestLogLevelMapper.orElse(DEFAULT_REQUEST_LOG_LEVEL_MAPPER);
    }

    public LogWriterBuilder responseLogLevel(HttpStatus status, LogLevel logLevel) {
        return this.responseLogLevelMapper(ResponseLogLevelMapper.of(status, logLevel));
    }

    public LogWriterBuilder responseLogLevel(HttpStatusClass statusClass, LogLevel logLevel) {
        return this.responseLogLevelMapper(ResponseLogLevelMapper.of(statusClass, logLevel));
    }

    public LogWriterBuilder responseLogLevel(Class<? extends Throwable> clazz, LogLevel logLevel) {
        Objects.requireNonNull(clazz, "clazz");
        Objects.requireNonNull(logLevel, "logLevel");
        return this.responseLogLevelMapper(ResponseLogLevelMapper.of(clazz, logLevel));
    }

    public LogWriterBuilder successfulResponseLogLevel(LogLevel successfulResponseLogLevel) {
        Objects.requireNonNull(successfulResponseLogLevel, "successfulResponseLogLevel");
        return this.responseLogLevelMapper(log -> log.responseCause() == null ? successfulResponseLogLevel : null);
    }

    public LogWriterBuilder failureResponseLogLevel(LogLevel failedResponseLogLevel) {
        Objects.requireNonNull(failedResponseLogLevel, "failedResponseLogLevel");
        return this.responseLogLevelMapper(log -> log.responseCause() != null ? failedResponseLogLevel : null);
    }

    public LogWriterBuilder responseLogLevelMapper(ResponseLogLevelMapper responseLogLevelMapper) {
        Objects.requireNonNull(responseLogLevelMapper, "responseLogLevelMapper");
        this.responseLogLevelMapper = this.responseLogLevelMapper == null ? responseLogLevelMapper : this.responseLogLevelMapper.orElse(responseLogLevelMapper);
        return this;
    }

    private ResponseLogLevelMapper responseLogLevelMapper() {
        if (this.responseLogLevelMapper == null) {
            return DEFAULT_RESPONSE_LOG_LEVEL_MAPPER;
        }
        return this.responseLogLevelMapper.orElse(DEFAULT_RESPONSE_LOG_LEVEL_MAPPER);
    }

    public LogWriterBuilder responseCauseFilter(Predicate<? super Throwable> responseCauseFilter) {
        this.responseCauseFilter = Objects.requireNonNull(responseCauseFilter, "responseCauseFilter");
        return this;
    }

    public LogWriterBuilder logFormatter(LogFormatter logFormatter) {
        this.logFormatter = Objects.requireNonNull(logFormatter, "logFormatter");
        return this;
    }

    public LogWriter build() {
        return new DefaultLogWriter(this.logger, this.requestLogLevelMapper(), this.responseLogLevelMapper(), this.responseCauseFilter, this.logFormatter);
    }
}

