/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.logging;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.logging.JsonLogFormatterBuilder;
import com.linecorp.armeria.common.logging.LogFormatter;
import com.linecorp.armeria.common.logging.RequestLog;
import com.linecorp.armeria.common.logging.RequestLogAccess;
import com.linecorp.armeria.common.logging.RequestLogProperty;
import com.linecorp.armeria.common.logging.RequestOnlyLog;
import com.linecorp.armeria.common.util.TextFormatter;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class JsonLogFormatter
implements LogFormatter {
    private static final Logger logger = LoggerFactory.getLogger(JsonLogFormatter.class);
    static final LogFormatter DEFAULT_INSTANCE = new JsonLogFormatterBuilder().build();
    private final BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable JsonNode> requestHeadersSanitizer;
    private final BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable JsonNode> responseHeadersSanitizer;
    private final BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable JsonNode> requestTrailersSanitizer;
    private final BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable JsonNode> responseTrailersSanitizer;
    private final BiFunction<? super RequestContext, Object, ? extends @Nullable JsonNode> requestContentSanitizer;
    private final BiFunction<? super RequestContext, Object, ? extends @Nullable JsonNode> responseContentSanitizer;
    private final ObjectMapper objectMapper;

    JsonLogFormatter(BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable JsonNode> requestHeadersSanitizer, BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable JsonNode> responseHeadersSanitizer, BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable JsonNode> requestTrailersSanitizer, BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable JsonNode> responseTrailersSanitizer, BiFunction<? super RequestContext, Object, ? extends @Nullable JsonNode> requestContentSanitizer, BiFunction<? super RequestContext, Object, ? extends @Nullable JsonNode> responseContentSanitizer, ObjectMapper objectMapper) {
        this.requestHeadersSanitizer = requestHeadersSanitizer;
        this.responseHeadersSanitizer = responseHeadersSanitizer;
        this.requestTrailersSanitizer = requestTrailersSanitizer;
        this.responseTrailersSanitizer = responseTrailersSanitizer;
        this.requestContentSanitizer = requestContentSanitizer;
        this.responseContentSanitizer = responseContentSanitizer;
        this.objectMapper = objectMapper;
    }

    @Override
    public String formatRequest(RequestOnlyLog log) {
        Objects.requireNonNull(log, "log");
        int flags = log.availabilityStamp();
        RequestContext ctx = log.context();
        if (!RequestLogProperty.REQUEST_START_TIME.isAvailable(flags)) {
            return "{\"type\": \"request\"}";
        }
        try {
            String contentPreview;
            Object content;
            Throwable cause;
            String requestCauseString = null;
            if (RequestLogProperty.REQUEST_CAUSE.isAvailable(flags) && (cause = log.requestCause()) != null) {
                requestCauseString = cause.toString();
            }
            JsonNode sanitizedHeaders = RequestLogProperty.REQUEST_HEADERS.isAvailable(flags) ? this.requestHeadersSanitizer.apply(ctx, log.requestHeaders()) : null;
            JsonNode sanitizedContent = null;
            if (RequestLogProperty.REQUEST_CONTENT.isAvailable(flags) && (content = log.requestContent()) != null) {
                sanitizedContent = this.requestContentSanitizer.apply(ctx, content);
            }
            if (sanitizedContent == null && RequestLogProperty.REQUEST_CONTENT_PREVIEW.isAvailable(flags) && (contentPreview = log.requestContentPreview()) != null) {
                sanitizedContent = this.requestContentSanitizer.apply(ctx, contentPreview);
            }
            JsonNode sanitizedTrailers = RequestLogProperty.REQUEST_TRAILERS.isAvailable(flags) && !log.requestTrailers().isEmpty() ? this.requestTrailersSanitizer.apply(ctx, log.requestTrailers()) : null;
            ObjectNode objectNode = this.objectMapper.createObjectNode();
            objectNode.put("type", "request");
            objectNode.put("startTime", TextFormatter.epochMicros(log.requestStartTimeMicros()).toString());
            if (RequestLogProperty.REQUEST_LENGTH.isAvailable(flags)) {
                objectNode.put("length", TextFormatter.size(log.requestLength()).toString());
            }
            if (RequestLogProperty.REQUEST_END_TIME.isAvailable(flags)) {
                objectNode.put("duration", TextFormatter.elapsed(log.requestDurationNanos()).toString());
            }
            if (requestCauseString != null) {
                objectNode.put("cause", requestCauseString);
            }
            if (RequestLogProperty.SCHEME.isAvailable(flags)) {
                objectNode.put("scheme", log.scheme().uriText());
            } else if (RequestLogProperty.SESSION.isAvailable(flags)) {
                objectNode.put("scheme", SerializationFormat.UNKNOWN.uriText() + '+' + (Object)((Object)log.sessionProtocol()));
            } else {
                objectNode.put("scheme", SerializationFormat.UNKNOWN.uriText() + "+unknown");
            }
            if (RequestLogProperty.NAME.isAvailable(flags)) {
                objectNode.put("name", log.name());
            }
            if (sanitizedHeaders != null) {
                objectNode.set("headers", sanitizedHeaders);
            }
            if (sanitizedContent != null) {
                objectNode.set("content", sanitizedContent);
            }
            if (sanitizedTrailers != null) {
                objectNode.set("trailers", sanitizedTrailers);
            }
            return this.objectMapper.writeValueAsString(objectNode);
        }
        catch (Exception e) {
            logger.warn("Unexpected exception while formatting a request log: {}", (Object)log, (Object)e);
            return "{}";
        }
    }

    @Override
    public String formatResponse(RequestLog log) {
        Objects.requireNonNull(log, "log");
        int flags = log.availabilityStamp();
        RequestContext ctx = log.context();
        if (!RequestLogProperty.RESPONSE_START_TIME.isAvailable(flags)) {
            return "{\"type\": \"response\"}";
        }
        try {
            List<RequestLogAccess> children;
            int numChildren;
            String contentPreview;
            Object content;
            Throwable cause;
            String responseCauseString = null;
            if (RequestLogProperty.RESPONSE_CAUSE.isAvailable(flags) && (cause = log.responseCause()) != null) {
                responseCauseString = cause.toString();
            }
            JsonNode sanitizedHeaders = RequestLogProperty.RESPONSE_HEADERS.isAvailable(flags) ? this.responseHeadersSanitizer.apply(ctx, log.responseHeaders()) : null;
            JsonNode sanitizedContent = null;
            if (RequestLogProperty.RESPONSE_CONTENT.isAvailable(flags) && (content = log.responseContent()) != null) {
                sanitizedContent = this.responseContentSanitizer.apply(ctx, content);
            }
            if (sanitizedContent == null && RequestLogProperty.RESPONSE_CONTENT_PREVIEW.isAvailable(flags) && (contentPreview = log.responseContentPreview()) != null) {
                sanitizedContent = this.responseContentSanitizer.apply(ctx, contentPreview);
            }
            JsonNode sanitizedTrailers = RequestLogProperty.RESPONSE_TRAILERS.isAvailable(flags) && !log.responseTrailers().isEmpty() ? this.responseTrailersSanitizer.apply(ctx, log.responseTrailers()) : null;
            ObjectNode objectNode = this.objectMapper.createObjectNode();
            objectNode.put("type", "response");
            objectNode.put("startTime", TextFormatter.epochMicros(log.responseStartTimeMicros()).toString());
            if (RequestLogProperty.RESPONSE_LENGTH.isAvailable(flags)) {
                objectNode.put("length", TextFormatter.size(log.responseLength()).toString());
            }
            if (RequestLogProperty.RESPONSE_END_TIME.isAvailable(flags)) {
                objectNode.put("duration", TextFormatter.elapsed(log.responseDurationNanos()).toString());
                objectNode.put("totalDuration", TextFormatter.elapsed(log.totalDurationNanos()).toString());
            }
            if (responseCauseString != null) {
                objectNode.put("cause", responseCauseString);
            }
            if (sanitizedHeaders != null) {
                objectNode.set("headers", sanitizedHeaders);
            }
            if (sanitizedContent != null) {
                objectNode.set("content", sanitizedContent);
            }
            if (sanitizedTrailers != null) {
                objectNode.set("trailers", sanitizedTrailers);
            }
            if ((numChildren = (children = log.children()).size()) > 1) {
                objectNode.put("totalAttempts", String.valueOf(numChildren));
            }
            return this.objectMapper.writeValueAsString(objectNode);
        }
        catch (Exception e) {
            logger.warn("Unexpected exception while formatting a response log: {}", (Object)log, (Object)e);
            return "{}";
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("objectMapper", this.objectMapper).add("requestHeadersSanitizer", this.requestHeadersSanitizer).add("requestContentSanitizer", this.requestContentSanitizer).add("requestTrailersSanitizer", this.requestTrailersSanitizer).add("responseHeadersSanitizer", this.responseHeadersSanitizer).add("responseContentSanitizer", this.responseContentSanitizer).add("responseTrailersSanitizer", this.responseTrailersSanitizer).toString();
    }
}

