/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.linecorp.armeria.common.Flags;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.base.Ascii;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.armeria.internal.shaded.guava.math.IntMath;
import io.netty.util.AsciiString;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.BitSet;
import java.util.Map;
import java.util.Objects;

public final class HttpHeaderNames {
    private static final BitSet PROHIBITED_NAME_CHARS;
    private static final String[] PROHIBITED_NAME_CHAR_NAMES;
    private static final byte LAST_PROHIBITED_NAME_CHAR;
    @Nullable
    private static ImmutableMap.Builder<AsciiString, String> inverseMapBuilder;
    public static final AsciiString METHOD;
    public static final AsciiString SCHEME;
    public static final AsciiString AUTHORITY;
    public static final AsciiString PATH;
    public static final AsciiString STATUS;
    public static final AsciiString PROTOCOL;
    public static final AsciiString CACHE_CONTROL;
    public static final AsciiString CONTENT_LENGTH;
    public static final AsciiString CONTENT_TYPE;
    public static final AsciiString DATE;
    public static final AsciiString PRAGMA;
    public static final AsciiString VIA;
    public static final AsciiString WARNING;
    public static final AsciiString ACCEPT;
    public static final AsciiString ACCEPT_CHARSET;
    public static final AsciiString ACCEPT_ENCODING;
    public static final AsciiString ACCEPT_LANGUAGE;
    public static final AsciiString ACCESS_CONTROL_ALLOW_PRIVATE_NETWORK;
    public static final AsciiString ACCESS_CONTROL_REQUEST_HEADERS;
    public static final AsciiString ACCESS_CONTROL_REQUEST_METHOD;
    public static final AsciiString AUTHORIZATION;
    public static final AsciiString CONNECTION;
    public static final AsciiString COOKIE;
    public static final AsciiString CROSS_ORIGIN_RESOURCE_POLICY;
    public static final AsciiString EARLY_DATA;
    public static final AsciiString EXPECT;
    public static final AsciiString FROM;
    public static final AsciiString FORWARDED;
    public static final AsciiString FOLLOW_ONLY_WHEN_PRERENDER_SHOWN;
    public static final AsciiString HOST;
    public static final AsciiString HTTP2_SETTINGS;
    public static final AsciiString IF_MATCH;
    public static final AsciiString IF_MODIFIED_SINCE;
    public static final AsciiString IF_NONE_MATCH;
    public static final AsciiString IF_RANGE;
    public static final AsciiString IF_UNMODIFIED_SINCE;
    public static final AsciiString LAST_EVENT_ID;
    public static final AsciiString MAX_FORWARDS;
    public static final AsciiString ORIGIN;
    public static final AsciiString ORIGIN_ISOLATION;
    public static final AsciiString PREFER;
    public static final AsciiString PROXY_AUTHORIZATION;
    public static final AsciiString RANGE;
    public static final AsciiString REFERER;
    public static final AsciiString REFERRER_POLICY;
    public static final AsciiString SERVICE_WORKER;
    public static final AsciiString TE;
    public static final AsciiString UPGRADE;
    public static final AsciiString UPGRADE_INSECURE_REQUESTS;
    public static final AsciiString USER_AGENT;
    public static final AsciiString ACCEPT_RANGES;
    public static final AsciiString ACCEPT_PATCH;
    public static final AsciiString ACCESS_CONTROL_ALLOW_HEADERS;
    public static final AsciiString ACCESS_CONTROL_ALLOW_METHODS;
    public static final AsciiString ACCESS_CONTROL_ALLOW_ORIGIN;
    public static final AsciiString ACCESS_CONTROL_ALLOW_CREDENTIALS;
    public static final AsciiString ACCESS_CONTROL_EXPOSE_HEADERS;
    public static final AsciiString ACCESS_CONTROL_MAX_AGE;
    public static final AsciiString AGE;
    public static final AsciiString ALLOW;
    public static final AsciiString CONTENT_BASE;
    public static final AsciiString CONTENT_DESCRIPTION;
    public static final AsciiString CONTENT_DISPOSITION;
    public static final AsciiString CONTENT_ENCODING;
    public static final AsciiString CONTENT_ID;
    public static final AsciiString CONTENT_LANGUAGE;
    public static final AsciiString CONTENT_LOCATION;
    public static final AsciiString CONTENT_MD5;
    public static final AsciiString CONTENT_RANGE;
    public static final AsciiString CONTENT_SECURITY_POLICY;
    public static final AsciiString CONTENT_SECURITY_POLICY_REPORT_ONLY;
    public static final AsciiString CONTENT_TRANSFER_ENCODING;
    public static final AsciiString CROSS_ORIGIN_EMBEDDER_POLICY;
    public static final AsciiString CROSS_ORIGIN_EMBEDDER_POLICY_REPORT_ONLY;
    public static final AsciiString CROSS_ORIGIN_OPENER_POLICY;
    public static final AsciiString ETAG;
    public static final AsciiString EXPIRES;
    public static final AsciiString LAST_MODIFIED;
    public static final AsciiString LINK;
    public static final AsciiString LOCATION;
    public static final AsciiString KEEP_ALIVE;
    public static final AsciiString NO_VARY_SEARCH;
    public static final AsciiString ORIGIN_TRIAL;
    public static final AsciiString P3P;
    public static final AsciiString PROXY_AUTHENTICATE;
    public static final AsciiString REFRESH;
    public static final AsciiString REPORT_TO;
    public static final AsciiString RETRY_AFTER;
    public static final AsciiString SERVER;
    public static final AsciiString SERVER_TIMING;
    public static final AsciiString SERVICE_WORKER_ALLOWED;
    public static final AsciiString SET_COOKIE;
    public static final AsciiString SET_COOKIE2;
    public static final AsciiString SOURCE_MAP;
    public static final AsciiString SUPPORTS_LOADING_MODE;
    public static final AsciiString STRICT_TRANSPORT_SECURITY;
    public static final AsciiString TIMING_ALLOW_ORIGIN;
    public static final AsciiString TRAILER;
    public static final AsciiString TRANSFER_ENCODING;
    public static final AsciiString VARY;
    public static final AsciiString WWW_AUTHENTICATE;
    public static final AsciiString DNT;
    public static final AsciiString X_CONTENT_TYPE_OPTIONS;
    public static final AsciiString X_DEVICE_IP;
    public static final AsciiString X_DEVICE_REFERER;
    public static final AsciiString X_DEVICE_ACCEPT_LANGUAGE;
    public static final AsciiString X_DEVICE_REQUESTED_WITH;
    public static final AsciiString X_DO_NOT_TRACK;
    public static final AsciiString X_FORWARDED_FOR;
    public static final AsciiString X_FORWARDED_PROTO;
    public static final AsciiString X_FORWARDED_HOST;
    public static final AsciiString X_FORWARDED_PORT;
    public static final AsciiString X_FRAME_OPTIONS;
    public static final AsciiString X_POWERED_BY;
    public static final AsciiString PUBLIC_KEY_PINS;
    public static final AsciiString PUBLIC_KEY_PINS_REPORT_ONLY;
    public static final AsciiString X_REQUEST_ID;
    public static final AsciiString X_REQUESTED_WITH;
    public static final AsciiString X_USER_IP;
    public static final AsciiString X_DOWNLOAD_OPTIONS;
    public static final AsciiString X_XSS_PROTECTION;
    public static final AsciiString X_DNS_PREFETCH_CONTROL;
    public static final AsciiString PING_FROM;
    public static final AsciiString PING_TO;
    public static final AsciiString PURPOSE;
    public static final AsciiString X_PURPOSE;
    public static final AsciiString X_MOZ;
    public static final AsciiString DEVICE_MEMORY;
    public static final AsciiString DOWNLINK;
    public static final AsciiString ECT;
    public static final AsciiString RTT;
    public static final AsciiString SAVE_DATA;
    public static final AsciiString VIEWPORT_WIDTH;
    public static final AsciiString WIDTH;
    public static final AsciiString PERMISSIONS_POLICY;
    public static final AsciiString ACCEPT_CH;
    public static final AsciiString CRITICAL_CH;
    public static final AsciiString SEC_CH_UA;
    public static final AsciiString SEC_CH_UA_ARCH;
    public static final AsciiString SEC_CH_UA_MODEL;
    public static final AsciiString SEC_CH_UA_PLATFORM;
    public static final AsciiString SEC_CH_UA_PLATFORM_VERSION;
    public static final AsciiString SEC_CH_UA_FULL_VERSION;
    public static final AsciiString SEC_CH_UA_FULL_VERSION_LIST;
    public static final AsciiString SEC_CH_UA_MOBILE;
    public static final AsciiString SEC_CH_UA_WOW64;
    public static final AsciiString SEC_CH_UA_BITNESS;
    public static final AsciiString SEC_CH_UA_FORM_FACTOR;
    public static final AsciiString SEC_CH_VIEWPORT_WIDTH;
    public static final AsciiString SEC_CH_VIEWPORT_HEIGHT;
    public static final AsciiString SEC_CH_DPR;
    public static final AsciiString SEC_FETCH_DEST;
    public static final AsciiString SEC_FETCH_MODE;
    public static final AsciiString SEC_FETCH_SITE;
    public static final AsciiString SEC_FETCH_USER;
    public static final AsciiString SEC_METADATA;
    public static final AsciiString SEC_TOKEN_BINDING;
    public static final AsciiString SEC_PROVIDED_TOKEN_BINDING_ID;
    public static final AsciiString SEC_REFERRED_TOKEN_BINDING_ID;
    public static final AsciiString SEC_WEBSOCKET_ACCEPT;
    public static final AsciiString SEC_WEBSOCKET_EXTENSIONS;
    public static final AsciiString SEC_WEBSOCKET_KEY;
    public static final AsciiString SEC_WEBSOCKET_PROTOCOL;
    public static final AsciiString SEC_WEBSOCKET_VERSION;
    public static final AsciiString SEC_BROWSING_TOPICS;
    public static final AsciiString OBSERVE_BROWSING_TOPICS;
    public static final AsciiString CDN_LOOP;
    private static final Map<CharSequence, AsciiString> map;
    private static final Map<AsciiString, String> inverseMap;

    private static AsciiString create(String name) {
        AsciiString cached = AsciiString.cached(Ascii.toLowerCase(name));
        inverseMapBuilder.put(cached, name);
        return cached;
    }

    public static AsciiString of(CharSequence name) {
        if (name instanceof AsciiString) {
            return HttpHeaderNames.of((AsciiString)name);
        }
        String lowerCased = Ascii.toLowerCase(Objects.requireNonNull(name, "name"));
        AsciiString cached = map.get(lowerCased);
        if (cached != null) {
            return cached;
        }
        return HttpHeaderNames.validate(AsciiString.cached(lowerCased));
    }

    public static AsciiString of(AsciiString name) {
        AsciiString lowerCased = name.toLowerCase();
        AsciiString cached = map.get(lowerCased);
        if (cached != null) {
            return cached;
        }
        return HttpHeaderNames.validate(lowerCased);
    }

    static String rawHeaderName(AsciiString name) {
        String headerName = inverseMap.get(name);
        if (headerName != null) {
            return headerName;
        }
        return name.toString();
    }

    private static AsciiString validate(AsciiString name) {
        int lastIndex;
        if (name.isEmpty()) {
            throw new IllegalArgumentException("malformed header name: <EMPTY>");
        }
        if (!Flags.validateHeaders()) {
            return name;
        }
        try {
            lastIndex = name.forEachByte(value -> {
                if (value > LAST_PROHIBITED_NAME_CHAR) {
                    return true;
                }
                return !PROHIBITED_NAME_CHARS.get(value);
            });
        }
        catch (Exception e) {
            throw new Error(e);
        }
        if (lastIndex >= 0) {
            throw new IllegalArgumentException(HttpHeaderNames.malformedHeaderNameMessage(name));
        }
        return name;
    }

    private static String malformedHeaderNameMessage(AsciiString name) {
        StringBuilder buf = new StringBuilder(IntMath.saturatedAdd(name.length(), 64));
        buf.append("malformed header name: ");
        int nameLength = name.length();
        for (int i = 0; i < nameLength; ++i) {
            char ch = name.charAt(i);
            if (PROHIBITED_NAME_CHARS.get(ch)) {
                buf.append(PROHIBITED_NAME_CHAR_NAMES[ch]);
                continue;
            }
            buf.append(ch);
        }
        return buf.toString();
    }

    private HttpHeaderNames() {
    }

    static {
        inverseMapBuilder = ImmutableMap.builder();
        PROHIBITED_NAME_CHARS = new BitSet();
        PROHIBITED_NAME_CHARS.set(0);
        PROHIBITED_NAME_CHARS.set(9);
        PROHIBITED_NAME_CHARS.set(10);
        PROHIBITED_NAME_CHARS.set(11);
        PROHIBITED_NAME_CHARS.set(12);
        PROHIBITED_NAME_CHARS.set(13);
        PROHIBITED_NAME_CHARS.set(32);
        PROHIBITED_NAME_CHARS.set(44);
        PROHIBITED_NAME_CHARS.set(58);
        PROHIBITED_NAME_CHARS.set(59);
        PROHIBITED_NAME_CHARS.set(61);
        LAST_PROHIBITED_NAME_CHAR = (byte)(PROHIBITED_NAME_CHARS.size() - 1);
        PROHIBITED_NAME_CHAR_NAMES = new String[PROHIBITED_NAME_CHARS.size()];
        HttpHeaderNames.PROHIBITED_NAME_CHAR_NAMES[0] = "<NUL>";
        HttpHeaderNames.PROHIBITED_NAME_CHAR_NAMES[9] = "<TAB>";
        HttpHeaderNames.PROHIBITED_NAME_CHAR_NAMES[10] = "<LF>";
        HttpHeaderNames.PROHIBITED_NAME_CHAR_NAMES[11] = "<VT>";
        HttpHeaderNames.PROHIBITED_NAME_CHAR_NAMES[12] = "<FF>";
        HttpHeaderNames.PROHIBITED_NAME_CHAR_NAMES[13] = "<CR>";
        HttpHeaderNames.PROHIBITED_NAME_CHAR_NAMES[32] = "<SP>";
        HttpHeaderNames.PROHIBITED_NAME_CHAR_NAMES[44] = ",";
        HttpHeaderNames.PROHIBITED_NAME_CHAR_NAMES[58] = ":";
        HttpHeaderNames.PROHIBITED_NAME_CHAR_NAMES[59] = ";";
        HttpHeaderNames.PROHIBITED_NAME_CHAR_NAMES[61] = "=";
        METHOD = HttpHeaderNames.create(":method");
        SCHEME = HttpHeaderNames.create(":scheme");
        AUTHORITY = HttpHeaderNames.create(":authority");
        PATH = HttpHeaderNames.create(":path");
        STATUS = HttpHeaderNames.create(":status");
        PROTOCOL = HttpHeaderNames.create(":protocol");
        CACHE_CONTROL = HttpHeaderNames.create("Cache-Control");
        CONTENT_LENGTH = HttpHeaderNames.create("Content-Length");
        CONTENT_TYPE = HttpHeaderNames.create("Content-Type");
        DATE = HttpHeaderNames.create("Date");
        PRAGMA = HttpHeaderNames.create("Pragma");
        VIA = HttpHeaderNames.create("Via");
        WARNING = HttpHeaderNames.create("Warning");
        ACCEPT = HttpHeaderNames.create("Accept");
        ACCEPT_CHARSET = HttpHeaderNames.create("Accept-Charset");
        ACCEPT_ENCODING = HttpHeaderNames.create("Accept-Encoding");
        ACCEPT_LANGUAGE = HttpHeaderNames.create("Accept-Language");
        ACCESS_CONTROL_ALLOW_PRIVATE_NETWORK = HttpHeaderNames.create("Access-Control-Allow-Private-Network");
        ACCESS_CONTROL_REQUEST_HEADERS = HttpHeaderNames.create("Access-Control-Request-Headers");
        ACCESS_CONTROL_REQUEST_METHOD = HttpHeaderNames.create("Access-Control-Request-Method");
        AUTHORIZATION = HttpHeaderNames.create("Authorization");
        CONNECTION = HttpHeaderNames.create("Connection");
        COOKIE = HttpHeaderNames.create("Cookie");
        CROSS_ORIGIN_RESOURCE_POLICY = HttpHeaderNames.create("Cross-Origin-Resource-Policy");
        EARLY_DATA = HttpHeaderNames.create("Early-Data");
        EXPECT = HttpHeaderNames.create("Expect");
        FROM = HttpHeaderNames.create("From");
        FORWARDED = HttpHeaderNames.create("Forwarded");
        FOLLOW_ONLY_WHEN_PRERENDER_SHOWN = HttpHeaderNames.create("Follow-Only-When-Prerender-Shown");
        HOST = HttpHeaderNames.create("Host");
        HTTP2_SETTINGS = HttpHeaderNames.create("HTTP2-Settings");
        IF_MATCH = HttpHeaderNames.create("If-Match");
        IF_MODIFIED_SINCE = HttpHeaderNames.create("If-Modified-Since");
        IF_NONE_MATCH = HttpHeaderNames.create("If-None-Match");
        IF_RANGE = HttpHeaderNames.create("If-Range");
        IF_UNMODIFIED_SINCE = HttpHeaderNames.create("If-Unmodified-Since");
        LAST_EVENT_ID = HttpHeaderNames.create("Last-Event-ID");
        MAX_FORWARDS = HttpHeaderNames.create("Max-Forwards");
        ORIGIN = HttpHeaderNames.create("Origin");
        ORIGIN_ISOLATION = HttpHeaderNames.create("Origin-Isolation");
        PREFER = HttpHeaderNames.create("Prefer");
        PROXY_AUTHORIZATION = HttpHeaderNames.create("Proxy-Authorization");
        RANGE = HttpHeaderNames.create("Range");
        REFERER = HttpHeaderNames.create("Referer");
        REFERRER_POLICY = HttpHeaderNames.create("Referrer-Policy");
        SERVICE_WORKER = HttpHeaderNames.create("Service-Worker");
        TE = HttpHeaderNames.create("TE");
        UPGRADE = HttpHeaderNames.create("Upgrade");
        UPGRADE_INSECURE_REQUESTS = HttpHeaderNames.create("Upgrade-Insecure-Requests");
        USER_AGENT = HttpHeaderNames.create("User-Agent");
        ACCEPT_RANGES = HttpHeaderNames.create("Accept-Ranges");
        ACCEPT_PATCH = HttpHeaderNames.create("Accept-Patch");
        ACCESS_CONTROL_ALLOW_HEADERS = HttpHeaderNames.create("Access-Control-Allow-Headers");
        ACCESS_CONTROL_ALLOW_METHODS = HttpHeaderNames.create("Access-Control-Allow-Methods");
        ACCESS_CONTROL_ALLOW_ORIGIN = HttpHeaderNames.create("Access-Control-Allow-Origin");
        ACCESS_CONTROL_ALLOW_CREDENTIALS = HttpHeaderNames.create("Access-Control-Allow-Credentials");
        ACCESS_CONTROL_EXPOSE_HEADERS = HttpHeaderNames.create("Access-Control-Expose-Headers");
        ACCESS_CONTROL_MAX_AGE = HttpHeaderNames.create("Access-Control-Max-Age");
        AGE = HttpHeaderNames.create("Age");
        ALLOW = HttpHeaderNames.create("Allow");
        CONTENT_BASE = HttpHeaderNames.create("Content-Base");
        CONTENT_DESCRIPTION = HttpHeaderNames.create("Content-Description");
        CONTENT_DISPOSITION = HttpHeaderNames.create("Content-Disposition");
        CONTENT_ENCODING = HttpHeaderNames.create("Content-Encoding");
        CONTENT_ID = HttpHeaderNames.create("Content-ID");
        CONTENT_LANGUAGE = HttpHeaderNames.create("Content-Language");
        CONTENT_LOCATION = HttpHeaderNames.create("Content-Location");
        CONTENT_MD5 = HttpHeaderNames.create("Content-MD5");
        CONTENT_RANGE = HttpHeaderNames.create("Content-Range");
        CONTENT_SECURITY_POLICY = HttpHeaderNames.create("Content-Security-Policy");
        CONTENT_SECURITY_POLICY_REPORT_ONLY = HttpHeaderNames.create("Content-Security-Policy-Report-Only");
        CONTENT_TRANSFER_ENCODING = HttpHeaderNames.create("Content-Transfer-Encoding");
        CROSS_ORIGIN_EMBEDDER_POLICY = HttpHeaderNames.create("Cross-Origin-Embedder-Policy");
        CROSS_ORIGIN_EMBEDDER_POLICY_REPORT_ONLY = HttpHeaderNames.create("Cross-Origin-Embedder-Policy-Report-Only");
        CROSS_ORIGIN_OPENER_POLICY = HttpHeaderNames.create("Cross-Origin-Opener-Policy");
        ETAG = HttpHeaderNames.create("ETag");
        EXPIRES = HttpHeaderNames.create("Expires");
        LAST_MODIFIED = HttpHeaderNames.create("Last-Modified");
        LINK = HttpHeaderNames.create("Link");
        LOCATION = HttpHeaderNames.create("Location");
        KEEP_ALIVE = HttpHeaderNames.create("Keep-Alive");
        NO_VARY_SEARCH = HttpHeaderNames.create("No-Vary-Search");
        ORIGIN_TRIAL = HttpHeaderNames.create("Origin-Trial");
        P3P = HttpHeaderNames.create("P3P");
        PROXY_AUTHENTICATE = HttpHeaderNames.create("Proxy-Authenticate");
        REFRESH = HttpHeaderNames.create("Refresh");
        REPORT_TO = HttpHeaderNames.create("Report-To");
        RETRY_AFTER = HttpHeaderNames.create("Retry-After");
        SERVER = HttpHeaderNames.create("Server");
        SERVER_TIMING = HttpHeaderNames.create("Server-Timing");
        SERVICE_WORKER_ALLOWED = HttpHeaderNames.create("Service-Worker-Allowed");
        SET_COOKIE = HttpHeaderNames.create("Set-Cookie");
        SET_COOKIE2 = HttpHeaderNames.create("Set-Cookie2");
        SOURCE_MAP = HttpHeaderNames.create("SourceMap");
        SUPPORTS_LOADING_MODE = HttpHeaderNames.create("Supports-Loading-Mode");
        STRICT_TRANSPORT_SECURITY = HttpHeaderNames.create("Strict-Transport-Security");
        TIMING_ALLOW_ORIGIN = HttpHeaderNames.create("Timing-Allow-Origin");
        TRAILER = HttpHeaderNames.create("Trailer");
        TRANSFER_ENCODING = HttpHeaderNames.create("Transfer-Encoding");
        VARY = HttpHeaderNames.create("Vary");
        WWW_AUTHENTICATE = HttpHeaderNames.create("WWW-Authenticate");
        DNT = HttpHeaderNames.create("DNT");
        X_CONTENT_TYPE_OPTIONS = HttpHeaderNames.create("X-Content-Type-Options");
        X_DEVICE_IP = HttpHeaderNames.create("X-Device-IP");
        X_DEVICE_REFERER = HttpHeaderNames.create("X-Device-Referer");
        X_DEVICE_ACCEPT_LANGUAGE = HttpHeaderNames.create("X-Device-Accept-Language");
        X_DEVICE_REQUESTED_WITH = HttpHeaderNames.create("X-Device-Requested-With");
        X_DO_NOT_TRACK = HttpHeaderNames.create("X-Do-Not-Track");
        X_FORWARDED_FOR = HttpHeaderNames.create("X-Forwarded-For");
        X_FORWARDED_PROTO = HttpHeaderNames.create("X-Forwarded-Proto");
        X_FORWARDED_HOST = HttpHeaderNames.create("X-Forwarded-Host");
        X_FORWARDED_PORT = HttpHeaderNames.create("X-Forwarded-Port");
        X_FRAME_OPTIONS = HttpHeaderNames.create("X-Frame-Options");
        X_POWERED_BY = HttpHeaderNames.create("X-Powered-By");
        PUBLIC_KEY_PINS = HttpHeaderNames.create("Public-Key-Pins");
        PUBLIC_KEY_PINS_REPORT_ONLY = HttpHeaderNames.create("Public-Key-Pins-Report-Only");
        X_REQUEST_ID = HttpHeaderNames.create("X-Request-ID");
        X_REQUESTED_WITH = HttpHeaderNames.create("X-Requested-With");
        X_USER_IP = HttpHeaderNames.create("X-User-IP");
        X_DOWNLOAD_OPTIONS = HttpHeaderNames.create("X-Download-Options");
        X_XSS_PROTECTION = HttpHeaderNames.create("X-XSS-Protection");
        X_DNS_PREFETCH_CONTROL = HttpHeaderNames.create("X-DNS-Prefetch-Control");
        PING_FROM = HttpHeaderNames.create("Ping-From");
        PING_TO = HttpHeaderNames.create("Ping-To");
        PURPOSE = HttpHeaderNames.create("Purpose");
        X_PURPOSE = HttpHeaderNames.create("X-Purpose");
        X_MOZ = HttpHeaderNames.create("X-Moz");
        DEVICE_MEMORY = HttpHeaderNames.create("Device-Memory");
        DOWNLINK = HttpHeaderNames.create("Downlink");
        ECT = HttpHeaderNames.create("ECT");
        RTT = HttpHeaderNames.create("RTT");
        SAVE_DATA = HttpHeaderNames.create("Save-Data");
        VIEWPORT_WIDTH = HttpHeaderNames.create("Viewport-Width");
        WIDTH = HttpHeaderNames.create("Width");
        PERMISSIONS_POLICY = HttpHeaderNames.create("Permissions-Policy");
        ACCEPT_CH = HttpHeaderNames.create("Accept-CH");
        CRITICAL_CH = HttpHeaderNames.create("Critical-CH");
        SEC_CH_UA = HttpHeaderNames.create("Sec-CH-UA");
        SEC_CH_UA_ARCH = HttpHeaderNames.create("Sec-CH-UA-Arch");
        SEC_CH_UA_MODEL = HttpHeaderNames.create("Sec-CH-UA-Model");
        SEC_CH_UA_PLATFORM = HttpHeaderNames.create("Sec-CH-UA-Platform");
        SEC_CH_UA_PLATFORM_VERSION = HttpHeaderNames.create("Sec-CH-UA-Platform-Version");
        SEC_CH_UA_FULL_VERSION = HttpHeaderNames.create("Sec-CH-UA-Full-Version");
        SEC_CH_UA_FULL_VERSION_LIST = HttpHeaderNames.create("Sec-CH-UA-Full-Version-List");
        SEC_CH_UA_MOBILE = HttpHeaderNames.create("Sec-CH-UA-Mobile");
        SEC_CH_UA_WOW64 = HttpHeaderNames.create("Sec-CH-UA-WoW64");
        SEC_CH_UA_BITNESS = HttpHeaderNames.create("Sec-CH-UA-Bitness");
        SEC_CH_UA_FORM_FACTOR = HttpHeaderNames.create("Sec-CH-UA-Form-Factor");
        SEC_CH_VIEWPORT_WIDTH = HttpHeaderNames.create("Sec-CH-Viewport-Width");
        SEC_CH_VIEWPORT_HEIGHT = HttpHeaderNames.create("Sec-CH-Viewport-Height");
        SEC_CH_DPR = HttpHeaderNames.create("Sec-CH-DPR");
        SEC_FETCH_DEST = HttpHeaderNames.create("Sec-Fetch-Dest");
        SEC_FETCH_MODE = HttpHeaderNames.create("Sec-Fetch-Mode");
        SEC_FETCH_SITE = HttpHeaderNames.create("Sec-Fetch-Site");
        SEC_FETCH_USER = HttpHeaderNames.create("Sec-Fetch-User");
        SEC_METADATA = HttpHeaderNames.create("Sec-Metadata");
        SEC_TOKEN_BINDING = HttpHeaderNames.create("Sec-Token-Binding");
        SEC_PROVIDED_TOKEN_BINDING_ID = HttpHeaderNames.create("Sec-Provided-Token-Binding-ID");
        SEC_REFERRED_TOKEN_BINDING_ID = HttpHeaderNames.create("Sec-Referred-Token-Binding-ID");
        SEC_WEBSOCKET_ACCEPT = HttpHeaderNames.create("Sec-WebSocket-Accept");
        SEC_WEBSOCKET_EXTENSIONS = HttpHeaderNames.create("Sec-WebSocket-Extensions");
        SEC_WEBSOCKET_KEY = HttpHeaderNames.create("Sec-WebSocket-Key");
        SEC_WEBSOCKET_PROTOCOL = HttpHeaderNames.create("Sec-WebSocket-Protocol");
        SEC_WEBSOCKET_VERSION = HttpHeaderNames.create("Sec-WebSocket-Version");
        SEC_BROWSING_TOPICS = HttpHeaderNames.create("Sec-Browsing-Topics");
        OBSERVE_BROWSING_TOPICS = HttpHeaderNames.create("Observe-Browsing-Topics");
        CDN_LOOP = HttpHeaderNames.create("CDN-Loop");
        ImmutableMap.Builder<CharSequence, AsciiString> builder = ImmutableMap.builder();
        for (Field f : HttpHeaderNames.class.getDeclaredFields()) {
            AsciiString name;
            int m = f.getModifiers();
            if (!Modifier.isPublic(m) || !Modifier.isStatic(m) || !Modifier.isFinal(m) || f.getType() != AsciiString.class) continue;
            try {
                name = (AsciiString)f.get(null);
            }
            catch (Exception e) {
                throw new Error(e);
            }
            builder.put(name, name);
            builder.put(name.toString(), name);
        }
        map = builder.build();
        inverseMap = inverseMapBuilder.build();
        inverseMapBuilder = null;
    }
}

