/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.endpoint.dns;

import com.linecorp.armeria.client.DnsCacheListener;
import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.endpoint.DynamicEndpointGroup;
import com.linecorp.armeria.client.endpoint.EndpointSelectionStrategy;
import com.linecorp.armeria.client.endpoint.dns.DnsQueryListener;
import com.linecorp.armeria.client.retry.Backoff;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.client.dns.DefaultDnsResolver;
import com.linecorp.armeria.internal.client.dns.DnsQuestionWithoutTrailingDot;
import com.linecorp.armeria.internal.client.dns.DnsUtil;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSortedSet;
import io.netty.channel.EventLoop;
import io.netty.handler.codec.dns.DnsQuestion;
import io.netty.handler.codec.dns.DnsRecord;
import io.netty.handler.codec.dns.DnsRecordType;
import io.netty.util.concurrent.ScheduledFuture;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class DnsEndpointGroup
extends DynamicEndpointGroup
implements DnsCacheListener {
    private final EventLoop eventLoop;
    private final Backoff backoff;
    private final List<DnsQuestionWithoutTrailingDot> questions;
    private final DefaultDnsResolver resolver;
    private final Logger logger;
    private final String logPrefix;
    private final int minTtl;
    private final int maxTtl;
    private final List<DnsQueryListener> dnsQueryListeners;
    private boolean started;
    @Nullable
    private volatile ScheduledFuture<?> scheduledFuture;
    int attemptsSoFar;

    DnsEndpointGroup(EndpointSelectionStrategy selectionStrategy, boolean allowEmptyEndpoints, long selectionTimeoutMillis, DefaultDnsResolver resolver, EventLoop eventLoop, List<DnsQuestionWithoutTrailingDot> questions, Backoff backoff, int minTtl, int maxTtl, List<DnsQueryListener> dnsQueryListeners) {
        super(selectionStrategy, allowEmptyEndpoints, selectionTimeoutMillis);
        this.resolver = resolver;
        this.eventLoop = eventLoop;
        this.backoff = backoff;
        this.questions = questions;
        this.minTtl = minTtl;
        this.maxTtl = maxTtl;
        List<DnsQueryListener> list = this.dnsQueryListeners = dnsQueryListeners.isEmpty() ? ImmutableList.of(DnsQueryListener.of()) : dnsQueryListeners;
        assert (!this.questions.isEmpty());
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.logPrefix = this.questions.stream().map(DnsRecord::name).distinct().collect(Collectors.joining(", "));
        resolver.dnsCache().addListener(this);
    }

    final Logger logger() {
        return this.logger;
    }

    final String logPrefix() {
        return this.logPrefix;
    }

    final void start() {
        Preconditions.checkState(!this.started);
        this.started = true;
        this.eventLoop.execute(() -> this.sendQueries(this.questions, ImmutableList.of()));
    }

    @Override
    public final void onRemoval(DnsQuestion question, @Nullable List<DnsRecord> records, @Nullable UnknownHostException cause) {
        if (cause != null) {
            return;
        }
        assert (question instanceof DnsQuestionWithoutTrailingDot);
        DnsQuestionWithoutTrailingDot cast = (DnsQuestionWithoutTrailingDot)question;
        boolean matched = this.questions.stream().anyMatch(q -> q.originalName().equals(cast.originalName()) && q.type().equals(cast.type()));
        if (matched) {
            this.eventLoop.execute(() -> this.sendQueries(this.questions, records != null ? records : ImmutableList.of()));
        }
    }

    @Override
    public void onEviction(DnsQuestion question, @Nullable List<DnsRecord> records, @Nullable UnknownHostException cause) {
    }

    private void sendQueries(List<DnsQuestionWithoutTrailingDot> questions, List<DnsRecord> oldRecords) {
        if (this.isClosing()) {
            return;
        }
        ScheduledFuture<?> scheduledFuture = this.scheduledFuture;
        if (scheduledFuture != null) {
            scheduledFuture.cancel(false);
        }
        CompletableFuture<List<DnsRecord>> future = this.resolver.resolve(questions, this.logPrefix);
        ++this.attemptsSoFar;
        future.handle((newRecords, cause) -> {
            if (this.isClosing()) {
                return null;
            }
            if (cause != null) {
                long delayMillis = this.backoff.nextDelayMillis(this.attemptsSoFar);
                for (DnsQueryListener listener : this.dnsQueryListeners) {
                    try {
                        listener.onFailure(oldRecords, (Throwable)cause, this.logPrefix, delayMillis, this.attemptsSoFar);
                    }
                    catch (Exception ex) {
                        this.logger.warn("Unexpected exception while invoking listener.onFailure(). listener: {}", (Object)listener, (Object)ex);
                    }
                }
                this.scheduledFuture = this.eventLoop.schedule(() -> this.sendQueries(questions, oldRecords), delayMillis, TimeUnit.MILLISECONDS);
                return null;
            }
            for (DnsQueryListener listener : this.dnsQueryListeners) {
                try {
                    listener.onSuccess(oldRecords, (List<DnsRecord>)newRecords, this.logPrefix);
                }
                catch (Exception ex) {
                    this.logger.warn("Unexpected exception while invoking listener.onSuccess(). listener: {}", (Object)listener, (Object)ex);
                }
            }
            this.attemptsSoFar = 0;
            long serverTtl = newRecords.stream().mapToLong(DnsRecord::timeToLive).min().orElse(this.minTtl);
            int effectiveTtl = (int)Math.max(Math.min(serverTtl, (long)this.maxTtl), (long)this.minTtl);
            try {
                this.setEndpoints(this.onDnsRecords((List<DnsRecord>)newRecords, effectiveTtl));
            }
            catch (Throwable t) {
                this.logger.warn("{} Failed to process the DNS query result: {}", this.logPrefix, newRecords, t);
            }
            finally {
                this.scheduledFuture = this.eventLoop.schedule(() -> this.sendQueries(questions, (List<DnsRecord>)newRecords), (long)effectiveTtl, TimeUnit.SECONDS);
            }
            return null;
        });
    }

    abstract ImmutableSortedSet<Endpoint> onDnsRecords(List<DnsRecord> var1, int var2) throws Exception;

    @Override
    protected final void doCloseAsync(CompletableFuture<?> future) {
        ScheduledFuture<?> scheduledFuture = this.scheduledFuture;
        if (scheduledFuture != null) {
            scheduledFuture.cancel(true);
        }
        future.complete(null);
    }

    final void warnInvalidRecord(DnsRecordType type, byte[] content) {
        DnsUtil.warnInvalidRecord(this.logger(), this.logPrefix, type, content);
    }

    final void logDnsResolutionResult(Collection<Endpoint> endpoints, int ttl) {
        if (endpoints.isEmpty()) {
            this.logger().warn("{} Resolved to empty endpoints (TTL: {})", (Object)this.logPrefix, (Object)ttl);
        } else if (this.logger().isDebugEnabled()) {
            this.logger().debug("{} Resolved: {} (TTL: {})", this.logPrefix, endpoints.stream().map(Object::toString).collect(Collectors.joining(", ")), ttl);
        }
    }

    @Override
    public String toString() {
        return this.toStringHelper().add("questions", this.questions).add("logPrefix", this.logPrefix).add("attemptsSoFar", this.attemptsSoFar).toString();
    }
}

