/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.endpoint;

import com.linecorp.armeria.client.endpoint.EndpointGroup;
import com.linecorp.armeria.client.endpoint.EndpointGroupException;
import com.linecorp.armeria.common.Flags;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import java.util.Objects;

public final class EndpointSelectionTimeoutException
extends EndpointGroupException {
    private static final long serialVersionUID = -3079582212067997365L;
    private static final EndpointSelectionTimeoutException INSTANCE = new EndpointSelectionTimeoutException();

    public static EndpointSelectionTimeoutException get(EndpointGroup endpointGroup, long selectionTimeoutMillis) {
        Objects.requireNonNull(endpointGroup, "endpointGroup");
        Preconditions.checkArgument(selectionTimeoutMillis >= 0L, "selectionTimeoutMillis: %s (expected: >= 0)", selectionTimeoutMillis);
        return Flags.verboseExceptionSampler().isSampled(EndpointSelectionTimeoutException.class) ? new EndpointSelectionTimeoutException(endpointGroup, selectionTimeoutMillis) : INSTANCE;
    }

    private EndpointSelectionTimeoutException() {
    }

    private EndpointSelectionTimeoutException(EndpointGroup endpointGroup, long selectionTimeoutMillis) {
        super("Failed to select within " + selectionTimeoutMillis + " ms an endpoint from: " + endpointGroup);
    }
}

