/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.circuitbreaker;

import com.linecorp.armeria.client.Client;
import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.HttpClient;
import com.linecorp.armeria.client.circuitbreaker.AbstractCircuitBreakerClient;
import com.linecorp.armeria.client.circuitbreaker.CircuitBreaker;
import com.linecorp.armeria.client.circuitbreaker.CircuitBreakerClientBuilder;
import com.linecorp.armeria.client.circuitbreaker.CircuitBreakerClientHandler;
import com.linecorp.armeria.client.circuitbreaker.CircuitBreakerDecision;
import com.linecorp.armeria.client.circuitbreaker.CircuitBreakerMapping;
import com.linecorp.armeria.client.circuitbreaker.CircuitBreakerRule;
import com.linecorp.armeria.client.circuitbreaker.CircuitBreakerRuleWithContent;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpResponseDuplicator;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.circuitbreaker.CircuitBreakerCallback;
import com.linecorp.armeria.common.logging.RequestLogProperty;
import com.linecorp.armeria.internal.client.TruncatingHttpResponse;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.Function;

public final class CircuitBreakerClient
extends AbstractCircuitBreakerClient<HttpRequest, HttpResponse>
implements HttpClient {
    private final boolean needsContentInRule;
    private final int maxContentLength;

    public static Function<? super HttpClient, CircuitBreakerClient> newDecorator(CircuitBreaker circuitBreaker, CircuitBreakerRule rule) {
        Objects.requireNonNull(circuitBreaker, "circuitBreaker");
        return CircuitBreakerClient.newDecorator(CircuitBreakerClientHandler.of(circuitBreaker), rule);
    }

    public static Function<? super HttpClient, CircuitBreakerClient> newDecorator(CircuitBreaker circuitBreaker, CircuitBreakerRuleWithContent<HttpResponse> ruleWithContent) {
        Objects.requireNonNull(circuitBreaker, "circuitBreaker");
        return CircuitBreakerClient.newDecorator(CircuitBreakerClientHandler.of(circuitBreaker), ruleWithContent);
    }

    public static Function<? super HttpClient, CircuitBreakerClient> newDecorator(CircuitBreakerMapping mapping, CircuitBreakerRule rule) {
        Objects.requireNonNull(mapping, "mapping");
        Objects.requireNonNull(rule, "rule");
        return CircuitBreakerClient.newDecorator(CircuitBreakerClientHandler.of(mapping), rule);
    }

    public static Function<? super HttpClient, CircuitBreakerClient> newDecorator(CircuitBreakerClientHandler handler, CircuitBreakerRule rule) {
        Objects.requireNonNull(rule, "rule");
        Objects.requireNonNull(handler, "handler");
        return delegate -> new CircuitBreakerClient((HttpClient)delegate, handler, rule);
    }

    public static Function<? super HttpClient, CircuitBreakerClient> newDecorator(CircuitBreakerMapping mapping, CircuitBreakerRuleWithContent<HttpResponse> ruleWithContent) {
        Objects.requireNonNull(mapping, "mapping");
        Objects.requireNonNull(ruleWithContent, "ruleWithContent");
        return CircuitBreakerClient.newDecorator(CircuitBreakerClientHandler.of(mapping), ruleWithContent);
    }

    public static Function<? super HttpClient, CircuitBreakerClient> newDecorator(CircuitBreakerClientHandler handler, CircuitBreakerRuleWithContent<HttpResponse> ruleWithContent) {
        Objects.requireNonNull(handler, "handler");
        Objects.requireNonNull(ruleWithContent, "ruleWithContent");
        return delegate -> new CircuitBreakerClient((HttpClient)delegate, handler, ruleWithContent);
    }

    public static Function<? super HttpClient, CircuitBreakerClient> newPerMethodDecorator(Function<String, ? extends CircuitBreaker> factory, CircuitBreakerRule rule) {
        return CircuitBreakerClient.newDecorator(CircuitBreakerMapping.perMethod(factory), rule);
    }

    public static Function<? super HttpClient, CircuitBreakerClient> newPerMethodDecorator(Function<String, ? extends CircuitBreaker> factory, CircuitBreakerRuleWithContent<HttpResponse> ruleWithContent) {
        return CircuitBreakerClient.newDecorator(CircuitBreakerMapping.perMethod(factory), ruleWithContent);
    }

    public static Function<? super HttpClient, CircuitBreakerClient> newPerHostDecorator(Function<String, ? extends CircuitBreaker> factory, CircuitBreakerRule rule) {
        return CircuitBreakerClient.newDecorator(CircuitBreakerMapping.perHost(factory), rule);
    }

    public static Function<? super HttpClient, CircuitBreakerClient> newPerHostDecorator(Function<String, ? extends CircuitBreaker> factory, CircuitBreakerRuleWithContent<HttpResponse> ruleWithContent) {
        return CircuitBreakerClient.newDecorator(CircuitBreakerMapping.perHost(factory), ruleWithContent);
    }

    public static Function<? super HttpClient, CircuitBreakerClient> newPerPathDecorator(Function<String, ? extends CircuitBreaker> factory, CircuitBreakerRule rule) {
        return CircuitBreakerClient.newDecorator(CircuitBreakerMapping.perPath(factory), rule);
    }

    public static Function<? super HttpClient, CircuitBreakerClient> newPerPathDecorator(Function<String, ? extends CircuitBreaker> factory, CircuitBreakerRuleWithContent<HttpResponse> ruleWithContent) {
        return CircuitBreakerClient.newDecorator(CircuitBreakerMapping.perPath(factory), ruleWithContent);
    }

    @Deprecated
    public static Function<? super HttpClient, CircuitBreakerClient> newPerHostAndMethodDecorator(BiFunction<String, String, ? extends CircuitBreaker> factory, CircuitBreakerRule rule) {
        return CircuitBreakerClient.newDecorator(CircuitBreakerMapping.perHostAndMethod(factory), rule);
    }

    @Deprecated
    public static Function<? super HttpClient, CircuitBreakerClient> newPerHostAndMethodDecorator(BiFunction<String, String, ? extends CircuitBreaker> factory, CircuitBreakerRuleWithContent<HttpResponse> ruleWithContent) {
        return CircuitBreakerClient.newDecorator(CircuitBreakerMapping.perHostAndMethod(factory), ruleWithContent);
    }

    public static CircuitBreakerClientBuilder builder(CircuitBreakerRule rule) {
        return new CircuitBreakerClientBuilder(rule);
    }

    public static CircuitBreakerClientBuilder builder(CircuitBreakerRuleWithContent<HttpResponse> ruleWithContent) {
        return CircuitBreakerClient.builder(ruleWithContent, Integer.MAX_VALUE);
    }

    public static CircuitBreakerClientBuilder builder(CircuitBreakerRuleWithContent<HttpResponse> ruleWithContent, int maxContentLength) {
        Preconditions.checkArgument(maxContentLength > 0, "maxContentLength: %s (expected: > 0)", maxContentLength);
        return new CircuitBreakerClientBuilder(ruleWithContent, maxContentLength);
    }

    CircuitBreakerClient(HttpClient delegate, CircuitBreakerClientHandler handler, CircuitBreakerRule rule) {
        this(delegate, handler, rule, (BiFunction<? super ClientRequestContext, ? super HttpRequest, ? extends HttpResponse>)null);
    }

    CircuitBreakerClient(HttpClient delegate, CircuitBreakerClientHandler handler, CircuitBreakerRule rule, @Nullable BiFunction<? super ClientRequestContext, ? super HttpRequest, ? extends HttpResponse> fallback) {
        super(delegate, handler, rule, fallback);
        this.needsContentInRule = false;
        this.maxContentLength = 0;
    }

    CircuitBreakerClient(HttpClient delegate, CircuitBreakerClientHandler handler, CircuitBreakerRuleWithContent<HttpResponse> ruleWithContent) {
        this(delegate, handler, ruleWithContent, Integer.MAX_VALUE, null);
    }

    CircuitBreakerClient(HttpClient delegate, CircuitBreakerClientHandler handler, CircuitBreakerRuleWithContent<HttpResponse> ruleWithContent, int maxContentLength, @Nullable BiFunction<? super ClientRequestContext, ? super HttpRequest, ? extends HttpResponse> fallback) {
        super(delegate, handler, ruleWithContent, fallback);
        this.needsContentInRule = true;
        this.maxContentLength = maxContentLength;
    }

    @Override
    protected HttpResponse doExecute(ClientRequestContext ctx, HttpRequest req, CircuitBreakerCallback callback) throws Exception {
        RequestLogProperty property;
        HttpResponse response;
        CircuitBreakerRule rule = this.needsContentInRule ? this.fromRuleWithContent() : this.rule();
        try {
            response = (HttpResponse)((Client)this.unwrap()).execute(ctx, req);
        }
        catch (Throwable cause) {
            CircuitBreakerClient.reportSuccessOrFailure(callback, rule.shouldReportAsSuccess(ctx, cause), ctx, cause);
            throw cause;
        }
        RequestLogProperty requestLogProperty = property = rule.requiresResponseTrailers() ? RequestLogProperty.RESPONSE_TRAILERS : RequestLogProperty.RESPONSE_HEADERS;
        if (!this.needsContentInRule) {
            this.reportResult(ctx, callback, property);
            return response;
        }
        return this.reportResultWithContent(ctx, response, callback, property);
    }

    private void reportResult(ClientRequestContext ctx, CircuitBreakerCallback callback, RequestLogProperty logProperty) {
        ctx.log().whenAvailable(logProperty).thenAccept(log -> {
            Throwable resCause = log.isAvailable(RequestLogProperty.RESPONSE_CAUSE) ? log.responseCause() : null;
            CircuitBreakerClient.reportSuccessOrFailure(callback, this.rule().shouldReportAsSuccess(ctx, resCause), ctx, resCause);
        });
    }

    private HttpResponse reportResultWithContent(ClientRequestContext ctx, HttpResponse response, CircuitBreakerCallback callback, RequestLogProperty logProperty) {
        HttpResponseDuplicator duplicator = response.toDuplicator(ctx.eventLoop().withoutContext(), ctx.maxResponseLength());
        TruncatingHttpResponse truncatingHttpResponse = new TruncatingHttpResponse(duplicator.duplicate(), this.maxContentLength);
        HttpResponse duplicate = duplicator.duplicate();
        duplicator.close();
        ctx.log().whenAvailable(logProperty).thenAccept(log -> {
            try {
                CompletionStage<CircuitBreakerDecision> f = this.ruleWithContent().shouldReportAsSuccess(ctx, truncatingHttpResponse, null);
                f.handle((unused1, unused2) -> {
                    truncatingHttpResponse.abort();
                    return null;
                });
                CircuitBreakerClient.reportSuccessOrFailure(callback, f, ctx, null);
            }
            catch (Throwable cause) {
                duplicator.abort(cause);
            }
        });
        return duplicate;
    }
}

